/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class ConcatIter
extends PlanIter {
    private final PlanIter[] theArgs;

    public ConcatIter(Expr e, int resultReg, PlanIter[] argIters) {
        super(e, resultReg);
        this.theArgs = argIters;
    }

    public ConcatIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theArgs = ConcatIter.deserializeIters(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        ConcatIter.serializeIters(this.theArgs, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.CONCAT;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new ConcatIterState());
        for (PlanIter arg : this.theArgs) {
            arg.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        ConcatIterState state = (ConcatIterState)rcb.getState(this.theStatePos);
        if (this.theArgs.length == 0 || state.isDone()) {
            return false;
        }
        do {
            PlanIter input;
            if ((input = this.theArgs[state.theCurrentInput]).next(rcb)) {
                rcb.setRegVal(this.theResultReg, rcb.getRegVal(input.getResultReg()));
                return true;
            }
            ++state.theCurrentInput;
        } while (state.theCurrentInput < this.theArgs.length);
        state.done();
        return false;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter arg : this.theArgs) {
            arg.reset(rcb);
        }
        ConcatIterState state = (ConcatIterState)rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        ConcatIterState state = (ConcatIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter arg : this.theArgs) {
            arg.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theArgs.length; ++i) {
            this.theArgs[i].display(sb, formatter);
            if (i >= this.theArgs.length - 1) continue;
            sb.append(",\n");
        }
    }

    private static class ConcatIterState
    extends PlanIterState {
        int theCurrentInput = 0;

        private ConcatIterState() {
        }

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            this.theCurrentInput = 0;
        }

        @Override
        protected void close() {
            super.close();
            this.theCurrentInput = 0;
        }
    }
}

