/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.table.FieldDef;

public class IsOfTypeIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final boolean theNotFlag;
    private final List<FieldDef> theTargetTypes;
    private final List<ExprType.Quantifier> theTargetQuantifiers;
    private final List<Boolean> theOnlyTargetFlags;

    public IsOfTypeIter(Expr e, int resultReg, PlanIter inputIter, boolean notFlag, List<FieldDef> targetTypes, List<ExprType.Quantifier> targetQuantifiers, List<Boolean> onlyTargetFlags) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        assert (targetTypes != null && targetQuantifiers != null && onlyTargetFlags != null && targetTypes.size() == targetQuantifiers.size() && targetTypes.size() == onlyTargetFlags.size());
        this.theNotFlag = notFlag;
        this.theTargetTypes = targetTypes;
        this.theTargetQuantifiers = targetQuantifiers;
        this.theOnlyTargetFlags = onlyTargetFlags;
    }

    IsOfTypeIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInputIter = IsOfTypeIter.deserializeIter(in, serialVersion);
        this.theNotFlag = in.readBoolean();
        int size = in.readInt();
        this.theTargetTypes = new ArrayList<FieldDef>(size);
        this.theTargetQuantifiers = new ArrayList<ExprType.Quantifier>(size);
        this.theOnlyTargetFlags = new ArrayList<Boolean>(size);
        for (int i = 0; i < size; ++i) {
            this.theTargetTypes.add(IsOfTypeIter.deserializeFieldDef(in, serialVersion));
            this.theTargetQuantifiers.add(IsOfTypeIter.deserializeQuantifier(in, serialVersion));
            this.theOnlyTargetFlags.add(in.readBoolean());
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        IsOfTypeIter.serializeIter(this.theInputIter, out, serialVersion);
        out.writeBoolean(this.theNotFlag);
        int size = this.theTargetTypes.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            IsOfTypeIter.serializeFieldDef(this.theTargetTypes.get(i), out, serialVersion);
            IsOfTypeIter.serializeQuantifier(this.theTargetQuantifiers.get(i), out, serialVersion);
            out.writeBoolean(this.theOnlyTargetFlags.get(i));
        }
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.IS_OF_TYPE;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new IsOfTypeIterState(this));
        this.theInputIter.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        IsOfTypeIterState state = (IsOfTypeIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        int targetTypesSize = this.theTargetTypes.size();
        int inputSize = 0;
        boolean seenNull = false;
        int validTypesCounter = targetTypesSize;
        while (true) {
            boolean hasNext;
            if (!(hasNext = this.theInputIter.next(rcb))) {
                boolean result;
                if (inputSize == 0) {
                    result = false;
                    for (int i = 0; i < targetTypesSize; ++i) {
                        ExprType.Quantifier quantifier = this.theTargetQuantifiers.get(i);
                        if (quantifier != ExprType.Quantifier.QSTN && quantifier != ExprType.Quantifier.STAR) continue;
                        result = true;
                        break;
                    }
                    BooleanValueImpl retValue = BooleanValueImpl.create(this.theNotFlag ? !result : result);
                    rcb.setRegVal(this.theResultReg, retValue);
                    state.done();
                    return true;
                }
                if (seenNull && validTypesCounter > 0) {
                    NullValueImpl retValue = NullValueImpl.getInstance();
                    rcb.setRegVal(this.theResultReg, retValue);
                    state.done();
                    return true;
                }
                boolean bl = result = validTypesCounter > 0;
                BooleanValueImpl retValue = BooleanValueImpl.create(this.theNotFlag ? !result : result);
                rcb.setRegVal(this.theResultReg, retValue);
                state.done();
                return true;
            }
            ++inputSize;
            int inputReg = this.theInputIter.getResultReg();
            FieldValueImpl inValue = rcb.getRegVal(inputReg);
            if (inValue.isNull()) {
                seenNull = true;
                continue;
            }
            FieldDefImpl valDef = inValue.getDefinition();
            for (int i = 0; i < targetTypesSize; ++i) {
                if (!state.theValidTypes[i]) continue;
                ExprType.Quantifier quantifier = this.theTargetQuantifiers.get(i);
                if (inputSize >= 2 && (quantifier == ExprType.Quantifier.QSTN || quantifier == ExprType.Quantifier.ONE)) {
                    state.theValidTypes[i] = false;
                    --validTypesCounter;
                    continue;
                }
                FieldDef targetType = this.theTargetTypes.get(i);
                boolean onlyFlag = this.theOnlyTargetFlags.get(i);
                boolean isOfType = onlyFlag ? targetType.equals(valDef) : valDef.isSubtype((FieldDefImpl)targetType);
                if (isOfType) continue;
                state.theValidTypes[i] = false;
                --validTypesCounter;
            }
            if (validTypesCounter == 0) break;
        }
        boolean result = false;
        BooleanValueImpl retValue = BooleanValueImpl.create(this.theNotFlag ? !result : result);
        rcb.setRegVal(this.theResultReg, retValue);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        state.close();
    }

    @Override
    void displayName(StringBuilder sb) {
        sb.append(" IS_");
        if (this.theNotFlag) {
            sb.append("NOT_");
        }
        sb.append("OF_TYPE");
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append("\n");
        formatter.indent(sb);
        for (int i = 0; i < this.theTargetTypes.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this.theOnlyTargetFlags.get(i).booleanValue()) {
                sb.append("ONLY ");
            }
            sb.append(((FieldDefImpl)this.theTargetTypes.get(i)).getDDLString());
            sb.append((Object)this.theTargetQuantifiers.get(i));
        }
    }

    private static class IsOfTypeIterState
    extends PlanIterState {
        boolean[] theValidTypes;

        IsOfTypeIterState(IsOfTypeIter iter) {
            this.theValidTypes = new boolean[iter.theTargetTypes.size()];
            for (int i = 0; i < this.theValidTypes.length; ++i) {
                this.theValidTypes[i] = true;
            }
        }

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            for (int i = 0; i < this.theValidTypes.length; ++i) {
                this.theValidTypes[i] = true;
            }
        }
    }
}

