/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;

public class SFWIter
extends PlanIter {
    private final PlanIter[] theFromIters;
    private final String[] theFromVarNames;
    private final PlanIter theWhereIter;
    private final PlanIter[] theColumnIters;
    private final String[] theColumnNames;
    private final boolean theDoNullOnEmpty;
    private final int[] theTupleRegs;
    private final FieldDefImpl theTypeDefinition;
    private final PlanIter theOffsetIter;
    private final PlanIter theLimitIter;

    public SFWIter(Expr e, int resultReg, int[] tupleRegs, PlanIter[] fromIters, String[] fromVarNames, PlanIter whereIter, PlanIter[] columnIters, String[] columnNames, boolean nullOnEmpty, PlanIter offsetIter, PlanIter limitIter) {
        super(e, resultReg);
        this.theFromIters = fromIters;
        this.theFromVarNames = fromVarNames;
        this.theWhereIter = whereIter;
        this.theColumnIters = columnIters;
        this.theColumnNames = columnNames;
        this.theDoNullOnEmpty = nullOnEmpty;
        this.theTupleRegs = tupleRegs;
        this.theTypeDefinition = e.getType().getDef();
        this.theOffsetIter = offsetIter;
        this.theLimitIter = limitIter;
    }

    SFWIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theTypeDefinition = (FieldDefImpl)SFWIter.deserializeFieldDef(in, serialVersion);
        this.theTupleRegs = SFWIter.deserializeIntArray(in);
        this.theColumnNames = SFWIter.deserializeStringArray(in);
        this.theColumnIters = SFWIter.deserializeIters(in, serialVersion);
        if (serialVersion < 12) {
            this.theFromIters = new PlanIter[1];
            this.theFromVarNames = new String[1];
            this.theFromIters[0] = SFWIter.deserializeIter(in, serialVersion);
            this.theFromVarNames[0] = SerializationUtil.readString(in, serialVersion);
        } else {
            this.theFromIters = SFWIter.deserializeIters(in, serialVersion);
            this.theFromVarNames = new String[this.theFromIters.length];
            for (int i = 0; i < this.theFromIters.length; ++i) {
                this.theFromVarNames[i] = SerializationUtil.readString(in, serialVersion);
            }
        }
        this.theWhereIter = SFWIter.deserializeIter(in, serialVersion);
        this.theOffsetIter = SFWIter.deserializeIter(in, serialVersion);
        this.theLimitIter = SFWIter.deserializeIter(in, serialVersion);
        this.theDoNullOnEmpty = serialVersion < 14 ? true : in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SFWIter.serializeFieldDef(this.theTypeDefinition, out, serialVersion);
        SFWIter.serializeIntArray(this.theTupleRegs, out);
        SFWIter.serializeStringArray(this.theColumnNames, out);
        SFWIter.serializeIters(this.theColumnIters, out, serialVersion);
        if (serialVersion < 12) {
            String QV2String = SerialVersion.getKVVersion((short)12).getNumericVersionString();
            if (this.theTupleRegs == null) {
                throw new QueryException("Cannot execute a query with a single expression in the SELECT with no associated AS clause at a server whose version is less than " + QV2String + "\nserialVersion = " + serialVersion + " expected version = " + 12);
            }
            if (this.theFromIters.length > 1) {
                throw new QueryException("Cannot execute a query with more than one expression in the FROM clause at a server whose version is less than " + QV2String + "\nserialVersion = " + serialVersion + " expected version = " + 12);
            }
            SFWIter.serializeIter(this.theFromIters[0], out, serialVersion);
            SerializationUtil.writeString(out, serialVersion, this.theFromVarNames[0]);
        } else {
            SFWIter.serializeIters(this.theFromIters, out, serialVersion);
            for (int i = 0; i < this.theFromIters.length; ++i) {
                SerializationUtil.writeString(out, serialVersion, this.theFromVarNames[i]);
            }
        }
        SFWIter.serializeIter(this.theWhereIter, out, serialVersion);
        SFWIter.serializeIter(this.theOffsetIter, out, serialVersion);
        SFWIter.serializeIter(this.theLimitIter, out, serialVersion);
        if (serialVersion >= 14) {
            out.writeBoolean(this.theDoNullOnEmpty);
        }
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SFW;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theTupleRegs;
    }

    public int getNumColumns() {
        return this.theColumnNames.length;
    }

    public String getColumnName(int i) {
        return this.theColumnNames[i];
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new SFWIterState());
        if (this.theTupleRegs != null) {
            TupleValue tuple = new TupleValue((RecordDefImpl)this.theTypeDefinition, rcb.getRegisters(), this.theTupleRegs);
            rcb.setRegVal(this.theResultReg, tuple);
        }
        for (int i = 0; i < this.theFromIters.length; ++i) {
            this.theFromIters[i].open(rcb);
        }
        if (this.theWhereIter != null) {
            this.theWhereIter.open(rcb);
        }
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.open(rcb);
        }
        this.computeOffsetLimit(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.theNumResults >= state.theLimit) {
            state.done();
            this.theFromIters[0].reset(rcb);
            return false;
        }
        while (true) {
            if (this.theWhereIter != null) {
                boolean whereValue = true;
                do {
                    FieldValueImpl val;
                    if (!this.getNextFROMTuple(rcb, state)) {
                        return false;
                    }
                    boolean more = this.theWhereIter.next(rcb);
                    whereValue = !more ? false : ((val = rcb.getRegVal(this.theWhereIter.getResultReg())).isNull() ? false : val.getBoolean());
                    this.theWhereIter.reset(rcb);
                } while (!whereValue);
            } else if (!this.getNextFROMTuple(rcb, state)) {
                return false;
            }
            if (state.theOffset == 0L) break;
            --state.theOffset;
        }
        ++state.theNumResults;
        if (this.theTupleRegs == null) {
            boolean more = this.theColumnIters[0].next(rcb);
            if (!more) {
                rcb.setRegVal(this.theResultReg, this.theDoNullOnEmpty ? NullValueImpl.getInstance() : EmptyValueImpl.getInstance());
            }
            this.theColumnIters[0].reset(rcb);
            return true;
        }
        for (int i = 0; i < this.theColumnIters.length; ++i) {
            PlanIter columnIter = this.theColumnIters[i];
            boolean more = columnIter.next(rcb);
            if (!more) {
                rcb.setRegVal(this.theTupleRegs[i], this.theDoNullOnEmpty ? NullValueImpl.getInstance() : EmptyValueImpl.getInstance());
            } else {
                FieldValueImpl value = rcb.getRegVal(columnIter.getResultReg());
                if (value.isTuple()) {
                    value = ((TupleValue)value).toRecord();
                    rcb.setRegVal(this.theTupleRegs[i], value);
                }
            }
            columnIter.reset(rcb);
        }
        return true;
    }

    boolean getNextFROMTuple(RuntimeControlBlock rcb, SFWIterState state) {
        while (0 <= state.theNumBoundVars && state.theNumBoundVars < this.theFromIters.length) {
            if (!this.theFromIters[state.theNumBoundVars].next(rcb)) {
                this.theFromIters[state.theNumBoundVars].reset(rcb);
                --state.theNumBoundVars;
                continue;
            }
            ++state.theNumBoundVars;
        }
        if (state.theNumBoundVars < 0) {
            state.done();
            return false;
        }
        --state.theNumBoundVars;
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (int i = 0; i < this.theFromIters.length; ++i) {
            this.theFromIters[i].reset(rcb);
        }
        if (this.theWhereIter != null) {
            this.theWhereIter.reset(rcb);
        }
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.reset(rcb);
        }
        if (this.theOffsetIter != null) {
            this.theOffsetIter.reset(rcb);
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.reset(rcb);
        }
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        state.reset(this);
        this.computeOffsetLimit(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (int i = 0; i < this.theFromIters.length; ++i) {
            this.theFromIters[i].close(rcb);
        }
        if (this.theWhereIter != null) {
            this.theWhereIter.close(rcb);
        }
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.close(rcb);
        }
        if (this.theOffsetIter != null) {
            this.theOffsetIter.close(rcb);
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.close(rcb);
        }
        state.close();
    }

    private void computeOffsetLimit(RuntimeControlBlock rcb) {
        FieldValueImpl val;
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        long offset = 0L;
        long limit = -1L;
        if (this.theOffsetIter != null) {
            this.theOffsetIter.open(rcb);
            this.theOffsetIter.next(rcb);
            val = rcb.getRegVal(this.theOffsetIter.getResultReg());
            offset = val.getLong();
            if (offset < 0L) {
                throw new QueryException("Offset can not be a negative number", this.theOffsetIter.theLocation);
            }
            if (offset > Integer.MAX_VALUE) {
                throw new QueryException("Offset can not be greater than Integer.MAX_VALUE", this.theOffsetIter.theLocation);
            }
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.open(rcb);
            this.theLimitIter.next(rcb);
            val = rcb.getRegVal(this.theLimitIter.getResultReg());
            limit = val.getLong();
            if (limit < 0L) {
                throw new QueryException("Limit can not be a negative number", this.theLimitIter.theLocation);
            }
            if (limit > Integer.MAX_VALUE) {
                throw new QueryException("Limit can not be greater than Integer.MAX_VALUE", this.theOffsetIter.theLocation);
            }
        }
        long numResultsComputed = rcb.getNumResultsComputed();
        limit = limit < 0L ? Long.MAX_VALUE : (limit -= numResultsComputed);
        if (numResultsComputed > 0L) {
            offset = 0L;
        }
        state.theOffset = offset;
        state.theLimit = limit;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        for (i = 0; i < this.theFromIters.length; ++i) {
            formatter.indent(sb);
            sb.append("FROM:\n");
            this.theFromIters[i].display(sb, formatter);
            sb.append(" as " + this.theFromVarNames[i] + "\n\n");
        }
        if (this.theWhereIter != null) {
            formatter.indent(sb);
            sb.append("WHERE:\n");
            this.theWhereIter.display(sb, formatter);
            sb.append("\n\n");
        }
        formatter.indent(sb);
        sb.append("SELECT:\n");
        for (i = 0; i < this.theColumnIters.length; ++i) {
            this.theColumnIters[i].display(sb, formatter);
            if (i >= this.theColumnIters.length - 1) continue;
            sb.append(",\n");
        }
        if (this.theOffsetIter != null) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("OFFSET:\n");
            this.theOffsetIter.display(sb, formatter);
        }
        if (this.theLimitIter != null) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("LIMIT:\n");
            this.theLimitIter.display(sb, formatter);
        }
    }

    public static class SFWIterState
    extends PlanIterState {
        private int theNumBoundVars;
        private long theOffset;
        private long theLimit;
        private long theNumResults;

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            this.theNumBoundVars = 0;
            this.theNumResults = 0L;
        }
    }
}

