/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import oracle.kv.LoginCredentials;

public class KerberosClientCreds
implements LoginCredentials,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String HOST_PRINCIPAL_PAIR_PATTERN = "^([^:,]+):([^:,]+)(,([^:,]+):([^:,]+))*";
    private final String username;
    private Subject loginSubj;
    private final KrbServicePrincipals servicePrincipalInfo;
    private final boolean requireMutualAuth;

    public KerberosClientCreds(String username, Subject subject, String hostPrincPairs, boolean requireMutualAuth) throws IllegalArgumentException {
        if (username == null) {
            throw new IllegalArgumentException("The username argument must not be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.username = username;
        this.loginSubj = subject;
        this.servicePrincipalInfo = hostPrincPairs == null ? new KrbServicePrincipals() : new KrbServicePrincipals(this.makeServicePrincipalMap(hostPrincPairs));
        this.requireMutualAuth = requireMutualAuth;
    }

    public Subject getLoginSubject() {
        return this.loginSubj;
    }

    public KrbServicePrincipals getKrbServicePrincipals() {
        return this.servicePrincipalInfo;
    }

    public boolean getRequireMutualAuth() {
        return this.requireMutualAuth;
    }

    public void addServicePrincipal(String hostName, String instanceName) {
        this.servicePrincipalInfo.addPrincipal(hostName, instanceName);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "user name: " + this.username + "\n" + "login subject: " + this.loginSubj.toString();
    }

    private Map<String, String> makeServicePrincipalMap(String hostPrincPairs) {
        if (!Pattern.matches(HOST_PRINCIPAL_PAIR_PATTERN, hostPrincPairs)) {
            throw new IllegalArgumentException("Service principal input " + hostPrincPairs + " does not match the pattern " + "host:principal [,host:principal]*");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String comp : hostPrincPairs.trim().split(",")) {
            String[] pair = comp.split(":");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Invalid pair of service principal: " + comp);
            }
            String host = pair[0].trim();
            String principal = pair[1].trim();
            map.put(host, principal);
        }
        return map;
    }

    public static class KrbServicePrincipals {
        private static final char KRB_COMPONENT_SEPARATOR = '/';
        private static final char KRB_REALM_SEPARATOR = '@';
        private static final String KRB_SERVICE_NAME_DEFAULT = "oraclenosql";
        private final Map<String, String> principals;
        private String defaultRealm;
        private String serviceName;

        KrbServicePrincipals() {
            this.serviceName = KRB_SERVICE_NAME_DEFAULT;
            this.principals = new HashMap<String, String>();
        }

        KrbServicePrincipals(Map<String, String> helperHostPrincs) throws IllegalArgumentException {
            this.principals = helperHostPrincs;
            this.discoverPrincipalInfo();
        }

        public Map<String, String> getHelperhostPrincipals() {
            return this.principals;
        }

        public String getPrincipal(String hostName) {
            if (this.principals.isEmpty() && this.serviceName != null) {
                return this.serviceName;
            }
            return this.principals.get(hostName);
        }

        public void addPrincipal(String hostName, String instanceName) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.serviceName);
            if (instanceName != null && !instanceName.equals("")) {
                sb.append("/");
                sb.append(instanceName);
            }
            if (this.defaultRealm != null) {
                sb.append("@");
                sb.append(this.defaultRealm);
            }
            this.principals.put(hostName, sb.toString());
        }

        public String getDefaultRealm() {
            return this.defaultRealm;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        private void discoverPrincipalInfo() throws IllegalArgumentException {
            boolean first = true;
            for (String principal : this.principals.values()) {
                int compSeparator = -1;
                int realmSeparator = -1;
                for (int i = 0; i < principal.length(); ++i) {
                    int c = principal.charAt(i);
                    if (c == 47 && (realmSeparator == -1 || c < realmSeparator)) {
                        compSeparator = i;
                    }
                    if (c != 64) continue;
                    if (realmSeparator != -1) {
                        throw new IllegalArgumentException("Invalid principal name " + principal);
                    }
                    realmSeparator = i;
                }
                String service = principal;
                String realm = null;
                if (compSeparator != -1) {
                    service = principal.substring(0, compSeparator);
                }
                if (realmSeparator != -1) {
                    realm = principal.substring(realmSeparator + '\u0001', principal.length());
                }
                if (this.serviceName == null) {
                    this.serviceName = service;
                } else if (!this.serviceName.equals(service)) {
                    throw new IllegalArgumentException("Principal service name must be the same in a store");
                }
                if (first) {
                    this.defaultRealm = realm;
                    first = false;
                    continue;
                }
                if (this.defaultRealm == null) {
                    if (realm == null) continue;
                    throw new IllegalArgumentException("Principal " + principal + " cannot specify" + " a realm when the principal for the first" + " host mapping uses the default realm");
                }
                if (this.defaultRealm.equals(realm)) continue;
                throw new IllegalArgumentException("Principal " + principal + " must specify the" + " same realm as the first principal: " + this.defaultRealm);
            }
        }
    }
}

