/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.util.concurrent.TimeUnit;
import oracle.kv.Durability;

public class WriteOptions
implements Cloneable {
    private Durability durability;
    private long timeout;
    private TimeUnit timeoutUnit;
    private boolean updateTTL;

    public WriteOptions() {
        this(null, 0L, null);
    }

    public WriteOptions(Durability durability, long timeout, TimeUnit timeoutUnit) {
        this.setTimeout(timeout, timeoutUnit).setDurability(durability);
    }

    public WriteOptions(WriteOptions options) {
        this(options.durability, options.timeout, options.timeoutUnit);
        this.updateTTL = options.updateTTL;
    }

    public WriteOptions setDurability(Durability durability) {
        this.durability = durability;
        return this;
    }

    public WriteOptions setTimeout(long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        if (timeout != 0L && timeoutUnit == null) {
            throw new IllegalArgumentException("A non-zero timeout requires a non-null timeout unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public WriteOptions setUpdateTTL(boolean flag) {
        this.updateTTL = flag;
        return this;
    }

    public boolean getUpdateTTL() {
        return this.updateTTL;
    }

    protected Object clone() throws CloneNotSupportedException {
        WriteOptions clone = new WriteOptions();
        clone.setDurability(this.durability);
        clone.setTimeout(this.timeout, this.timeoutUnit);
        return clone;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Durability ").append(this.durability).append(" timeout=").append(this.timeout).append(this.timeoutUnit == null ? "" : this.timeoutUnit).append(" updateTTL=").append(this.updateTTL);
        return buf.toString();
    }
}

