/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.io.IOException;
import java.io.PrintStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStoreException;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.admin.AdminStatus;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.arb.ArbNodeStatus;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.ErrorMessage;
import oracle.kv.util.PingCollector;
import oracle.kv.util.PingDisplay;
import oracle.kv.util.shell.Shell;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class Ping {
    private static final int MAX_N_THREADS = 10;
    public static final String COMMAND_NAME = "ping";
    public static final String COMMAND_DESC = "attempts to contact a store to get status of running services";
    private static final String HELPER_HOSTS_FLAG = "-helper-hosts";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " or\n\t" + "-helper-hosts" + " <host:port[,host:port]*>\n\t" + CommandParser.getUserUsage() + "\n\t" + CommandParser.getSecurityUsage() + "\n\t" + CommandParser.optional((String)"-json");
    static final String EXIT_CODE_FIELD = "exit_code";
    private Topology topo;
    private final Parameters params;
    private final boolean showHidden;
    private final boolean getJson;
    private final PrintStream ps;
    private final LoginManager loginManager;
    private final LoginCredentials loginCreds;
    private PingCollector collector;
    private final List<Problem> problemReport = Collections.synchronizedList(new ArrayList());
    private ExitCode exitCode = ExitCode.EXIT_UNEXPECTED;

    public static void main(String[] args) {
        class PingParser
        extends CommandParser {
            private final String DONT_EXIT_FLAG = "-no-exit";
            private String helperHosts = null;
            private boolean dontExit = false;
            private boolean showHidden = false;

            PingParser(String[] args1) {
                super(args1);
            }

            public void usage(String errorMsg) {
                if (!this.getJson()) {
                    if (errorMsg != null) {
                        System.err.println(errorMsg);
                    }
                    System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar ping\n\t" + COMMAND_ARGS);
                }
                Ping.exit(this.dontExit, errorMsg, ExitCode.EXIT_USAGE, this.getJson(), System.err);
            }

            protected boolean checkArg(String arg) {
                if (arg.equals(Ping.HELPER_HOSTS_FLAG)) {
                    this.helperHosts = this.nextArg(arg);
                    return true;
                }
                if (arg.equals("-no-exit")) {
                    this.dontExit = true;
                    return true;
                }
                if (arg.equals("-hidden")) {
                    this.showHidden = true;
                    return true;
                }
                return false;
            }

            private String getHelperHosts() {
                return this.helperHosts;
            }

            private boolean getDontExit() {
                return this.dontExit;
            }

            protected void verifyArgs() {
                if (this.getHelperHosts() != null && (this.getHostname() != null || this.getRegistryPort() != 0)) {
                    this.usage("Only one of either -helper-hosts or -host plus -portmay be specified");
                }
                if (this.getHelperHosts() == null) {
                    if (this.getHostname() == null) {
                        this.missingArg("-host");
                    }
                    if (this.getRegistryPort() == 0) {
                        this.missingArg("-port");
                    }
                } else {
                    try {
                        this.validateHelperHosts(this.getHelperHosts());
                    }
                    catch (IllegalArgumentException e) {
                        this.usage("Illegal value for -helper-hosts");
                    }
                }
            }

            private void validateHelperHosts(String helperHostVal) throws IllegalArgumentException {
                if (helperHostVal == null) {
                    throw new IllegalArgumentException("helper hosts cannot be null");
                }
                String[] hosts = helperHostVal.split(",");
                HostPort.parse(hosts);
            }

            List<String> createHostPortList() {
                String[] hosts = null;
                hosts = this.helperHosts != null ? this.helperHosts.split(",") : new String[]{this.getHostname() + ":" + this.getRegistryPort()};
                HostPort[] hps = HostPort.parse(hosts);
                ArrayList<String> hpList = new ArrayList<String>();
                for (HostPort hp : hps) {
                    hpList.add(hp.toString());
                }
                return hpList;
            }
        }
        PingParser pp = new PingParser(args);
        try {
            pp.parseArgs();
        }
        catch (Exception e) {
            boolean json = Shell.checkArg((String[])args, (String)"-json");
            Ping.exit(pp.getDontExit(), "Argument error: " + e.getMessage(), ExitCode.EXIT_USAGE, json, System.err);
            return;
        }
        KVStoreLogin storeLogin = new KVStoreLogin(pp.getUserName(), pp.getSecurityFile());
        try {
            storeLogin.loadSecurityProperties();
        }
        catch (IllegalArgumentException iae) {
            Ping.exit(pp.getDontExit(), iae.getMessage(), ExitCode.EXIT_USAGE, pp.getJson(), System.err);
            return;
        }
        LoginCredentials loginCreds = null;
        if (storeLogin.foundSSLTransport()) {
            storeLogin.prepareRegistryCSF();
            try {
                loginCreds = storeLogin.makeShellLoginCredentials();
            }
            catch (IOException ioe) {
                Ping.exit(pp.getDontExit(), "Failed to get login credentials: " + ioe.getMessage(), ExitCode.EXIT_USAGE, pp.getJson(), System.err);
                return;
            }
            catch (IllegalArgumentException iae) {
                Ping.exit(pp.getDontExit(), iae.getMessage(), ExitCode.EXIT_USAGE, pp.getJson(), System.err);
                return;
            }
        }
        Ping ping = null;
        List<String> hostports = pp.createHostPortList();
        try {
            ping = new Ping(hostports, pp.showHidden, pp.getJson(), System.err, loginCreds);
        }
        catch (KVStoreException e) {
            if (!pp.getJson()) {
                Ping.checkIfSNAIsDeployed(hostports.get(0));
            }
            Ping.exit(pp.getDontExit(), "Can't find store topology: " + e.getMessage(), ExitCode.EXIT_TOPOLOGY_FAILURE, pp.getJson(), System.err);
            return;
        }
        catch (KVSecurityException e) {
            Ping.exit(pp.getDontExit(), "Access issue: " + e.getMessage(), ExitCode.EXIT_USAGE, pp.getJson(), System.err);
            return;
        }
        ping.pingTopology();
        Ping.exitNoDisplay(pp.getDontExit(), ping.exitCode);
    }

    private Ping(Topology topo, Parameters params, boolean showHidden, boolean getJson, PrintStream ps, LoginManager loginManager) {
        this.topo = topo;
        this.params = params;
        this.showHidden = showHidden;
        this.getJson = getJson;
        this.ps = ps;
        this.loginManager = loginManager;
        this.loginCreds = null;
    }

    public Ping(List<String> hostPorts, boolean showHidden, boolean getJson, PrintStream ps, LoginCredentials loginCreds) throws KVStoreException {
        this.showHidden = showHidden;
        this.getJson = getJson;
        this.ps = ps;
        String[] hostPortsArray = new String[hostPorts.size()];
        hostPortsArray = hostPorts.toArray(hostPortsArray);
        this.loginManager = loginCreds == null ? null : KVStoreLogin.getRepNodeLoginMgr(hostPortsArray, loginCreds, null);
        this.loginCreds = loginCreds;
        this.topo = this.findTopo(hostPortsArray);
        this.params = this.findParams();
    }

    public Ping(List<String> hostPorts, boolean showHidden, boolean getJson, PrintStream ps, LoginManager loginManager) throws KVStoreException {
        this.showHidden = showHidden;
        this.getJson = getJson;
        this.ps = ps;
        this.loginManager = loginManager;
        this.loginCreds = null;
        String[] hostPortsArray = new String[hostPorts.size()];
        hostPortsArray = hostPorts.toArray(hostPortsArray);
        this.topo = this.findTopo(hostPortsArray);
        this.params = this.findParams();
    }

    public static Topology findTopology(String hostname, int port) throws KVStoreException {
        ArrayList<String> helpers = new ArrayList<String>();
        helpers.add(new HostPort(hostname, port).toString());
        Ping ping = new Ping(helpers, false, false, System.err, (LoginCredentials)null);
        return ping.getTopology();
    }

    public Topology getTopology() {
        return this.topo;
    }

    public PingCollector getPingCollector() {
        return this.collector;
    }

    public static void pingTopology(Topology topo, Parameters params, boolean showHidden, boolean getJson, PrintStream ps, LoginManager loginManager) {
        Ping p = new Ping(topo, params, showHidden, getJson, ps, loginManager);
        p.pingTopology();
    }

    public void pingTopology() {
        if (this.topo == null) {
            return;
        }
        this.collector = new PingCollector(this.topo, this.params, this.loginManager);
        this.exitCode = this.analyzeStatus();
        ObjectNode jsonTop = this.convertStatusToJson();
        if (this.getJson) {
            Ping.createResultsJson(jsonTop, new PingResult(this.exitCode, null));
            if (this.showHidden) {
                this.problemReport.addAll(this.collector.getProblems());
                this.addProblemReport(jsonTop);
            }
            ObjectWriter writer = JsonUtils.createWriter(true);
            try {
                this.ps.println(writer.writeValueAsString(jsonTop));
            }
            catch (IOException e) {
                this.ps.println(e);
            }
        } else {
            this.ps.print("Pinging components of ");
            this.ps.println(PingDisplay.displayTopologyOverview(jsonTop));
            this.ps.println(PingDisplay.displayShardOverview(jsonTop));
            String adminOverview = PingDisplay.displayAdminOverview(jsonTop);
            if (!"".equals(adminOverview)) {
                this.ps.println(adminOverview);
            }
            for (JsonNode jsonZone : JsonUtils.getArray(jsonTop, "zoneStatus")) {
                this.ps.println(PingDisplay.displayZoneOverview(jsonZone));
            }
            for (JsonNode jsonSN : JsonUtils.getArray(jsonTop, "snStatus")) {
                this.ps.println(PingDisplay.displayStorageNode(jsonSN));
                JsonNode jsonAdmin = jsonSN.get("adminStatus");
                if (jsonAdmin != null) {
                    this.ps.println(PingDisplay.displayAdmin(jsonAdmin));
                }
                for (JsonNode jsonRN : JsonUtils.getArray(jsonSN, "rnStatus")) {
                    this.ps.println(PingDisplay.displayRepNode(jsonRN));
                }
                for (JsonNode jsonAN : JsonUtils.getArray(jsonSN, "anStatus")) {
                    this.ps.println(PingDisplay.displayArbNode(jsonAN));
                }
            }
        }
    }

    private ObjectNode convertStatusToJson() {
        Map<StorageNode, StorageNodeStatus> snMap = this.collector.getSNMap();
        ArrayList<StorageNode> sns = new ArrayList<StorageNode>(snMap.keySet());
        Collections.sort(sns, new Comparator<StorageNode>(){

            @Override
            public int compare(StorageNode o1, StorageNode o2) {
                return o1.getStorageNodeId().getStorageNodeId() - o2.getStorageNodeId().getStorageNodeId();
            }
        });
        final Map<RepNode, RepNodeStatus> rnMap = this.collector.getRNMap();
        HashMap<RepGroupId, RepNodeStatus> masterStatusMap = new HashMap<RepGroupId, RepNodeStatus>();
        for (Map.Entry<RepNode, RepNodeStatus> e : rnMap.entrySet()) {
            RepNodeStatus status = e.getValue();
            if (status == null || !status.getReplicationState().isMaster()) continue;
            RepNode rn = e.getKey();
            masterStatusMap.put(rn.getRepGroupId(), status);
        }
        ObjectNode jsonTop = JsonUtils.createObjectNode();
        PingDisplay.topologyOverviewToJson(this.topo, jsonTop);
        final Map<AdminId, PingCollector.AdminInfo> adminMap = this.collector.getAdminMap();
        if (this.params != null) {
            AdminStatusFunction adminStatusFunc = new AdminStatusFunction(){

                @Override
                public AdminStatus get(AdminId adminId) {
                    PingCollector.AdminInfo adminInfo = (PingCollector.AdminInfo)adminMap.get(adminId);
                    return adminInfo.adminStatus;
                }
            };
            PingDisplay.adminOverviewToJson(this.params, adminStatusFunc, jsonTop);
        }
        RepNodeStatusFunction rnfunc = new RepNodeStatusFunction(){

            @Override
            public RepNodeStatus get(RepNode rn) {
                return (RepNodeStatus)rnMap.get(rn);
            }
        };
        final Map<ArbNode, ArbNodeStatus> anMap = this.collector.getANMap();
        ArbNodeStatusFunction anfunc = new ArbNodeStatusFunction(){

            @Override
            public ArbNodeStatus get(ArbNode an) {
                return (ArbNodeStatus)anMap.get(an);
            }
        };
        PingDisplay.shardOverviewToJson(this.topo, rnfunc, anfunc, jsonTop);
        ArrayNode jsonZones = jsonTop.putArray("zoneStatus");
        for (Datacenter dc : this.topo.getSortedDatacenters()) {
            jsonZones.add(PingDisplay.zoneOverviewToJson(this.topo, dc, rnfunc, anfunc));
        }
        ArrayNode jsonSNs = jsonTop.putArray("snStatus");
        for (StorageNode sn : sns) {
            Map.Entry<AdminId, PingCollector.AdminInfo> aentry2;
            StorageNodeStatus status = snMap.get(sn);
            ObjectNode jsonSN = PingDisplay.storageNodeToJson(this.topo, sn, status);
            jsonSNs.add(jsonSN);
            for (Map.Entry<AdminId, PingCollector.AdminInfo> aentry2 : adminMap.entrySet()) {
                PingCollector.AdminInfo info = aentry2.getValue();
                if (info == null || !sn.getStorageNodeId().equals(info.snId)) continue;
                jsonSN.put("adminStatus", PingDisplay.adminToJson((AdminId)aentry2.getKey(), info.adminStatus));
                break;
            }
            ArrayNode jsonRNs = jsonSN.putArray("rnStatus");
            aentry2 = rnMap.entrySet().iterator();
            while (aentry2.hasNext()) {
                Map.Entry rentry = (Map.Entry)aentry2.next();
                RepNode rn = (RepNode)rentry.getKey();
                if (!sn.getStorageNodeId().equals(rn.getStorageNodeId())) continue;
                jsonRNs.add(PingDisplay.repNodeToJson(rn, (RepNodeStatus)rentry.getValue(), (RepNodeStatus)masterStatusMap.get(rn.getRepGroupId()), null));
            }
            ArrayNode jsonANs = jsonSN.putArray("anStatus");
            for (Map.Entry<ArbNode, ArbNodeStatus> rentry : anMap.entrySet()) {
                ArbNode an = rentry.getKey();
                if (!sn.getStorageNodeId().equals(an.getStorageNodeId())) continue;
                jsonANs.add(PingDisplay.arbNodeToJson(an, rentry.getValue(), null));
            }
        }
        return jsonTop;
    }

    private Topology findTopo(String[] hostPortsArray) throws KVStoreException {
        Topology newtopo;
        block2: {
            newtopo = null;
            try {
                newtopo = TopologyLocator.get(hostPortsArray, 0, this.loginManager, null);
            }
            catch (KVStoreException topoLocEx) {
                newtopo = this.searchAdminsForTopo(hostPortsArray);
                if (newtopo != null) break block2;
                throw topoLocEx;
            }
        }
        return newtopo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Parameters findParams() {
        if (this.topo == null) {
            return null;
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<5> tasks = new ArrayList<5>();
        for (final StorageNode sn : this.topo.getStorageNodeMap().getAll()) {
            tasks.add(new Callable<Parameters>(){

                @Override
                public Parameters call() throws Exception {
                    try {
                        CommandServiceAPI admin = Ping.this.getAdmin(sn.getHostname(), sn.getRegistryPort());
                        return admin.getParameters();
                    }
                    catch (RemoteException e) {
                        Ping.this.problemReport.add(new Problem((ResourceId)sn.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "Admin Service exists on this SN but ping couldn't contact it: ", e));
                        throw e;
                    }
                }
            });
        }
        try {
            Parameters parameters = (Parameters)executor.invokeAny(tasks);
            return parameters;
        }
        catch (Exception e) {
            this.problemReport.add(new Problem("Can't contact any Admin services in the store"));
            Parameters parameters = null;
            return parameters;
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topology searchAdminsForTopo(String[] hostPortStrings) {
        HostPort[] targetHPs = HostPort.parse(hostPortStrings);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<6> tasks = new ArrayList<6>();
        for (final HostPort hp : targetHPs) {
            tasks.add(new Callable<Topology>(){

                @Override
                public Topology call() throws Exception {
                    try {
                        CommandServiceAPI admin = Ping.this.getAdmin(hp.hostname(), hp.port());
                        return admin.getTopology();
                    }
                    catch (RemoteException e) {
                        Ping.this.problemReport.add(new Problem(hp.hostname(), hp.port(), "Admin Service exists on this SN but ping couldn't contact it: ", e));
                        throw e;
                    }
                }
            });
        }
        try {
            Topology topology = (Topology)executor.invokeAny(tasks);
            return topology;
        }
        catch (Exception exception) {
            this.problemReport.add(new Problem("Searching for topology, can't contact any Admin services in the store"));
            Topology topology = null;
            return topology;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private CommandServiceAPI getAdmin(String snHostname, int snRegistryPort) throws NotBoundException, RemoteException {
        if (this.loginManager != null) {
            return RegistryUtils.getAdmin(snHostname, snRegistryPort, this.loginManager);
        }
        if (this.loginCreds != null) {
            return RegistryUtils.getAdmin(snHostname, snRegistryPort, (LoginManager)KVStoreLogin.getAdminLoginMgr(snHostname, snRegistryPort, this.loginCreds));
        }
        return RegistryUtils.getAdmin(snHostname, snRegistryPort, null);
    }

    private ExitCode analyzeStatus() {
        if (this.topo == null) {
            return ExitCode.EXIT_TOPOLOGY_FAILURE;
        }
        HashSet<AdminId> failedAdmins = new HashSet<AdminId>();
        TreeMap failedShards = new TreeMap();
        int numFail = 0;
        List<StorageNode> sns = this.topo.getSortedStorageNodes();
        Map<StorageNode, StorageNodeStatus> snMap = this.collector.getSNMap();
        for (StorageNode sn : sns) {
            StorageNodeStatus snStatus = snMap.get(sn);
            Object status = snStatus == null ? ConfigurableService.ServiceStatus.UNREACHABLE : snStatus.getServiceStatus();
            if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) continue;
            this.problemReport.add(new Problem((ResourceId)sn.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "Unexpected status " + (Object)status));
            ++numFail;
        }
        Map<RepNode, RepNodeStatus> rnMap = this.collector.getRNMap();
        Map<ResourceId, ServiceChange> monitoredChanges = this.collector.getMonitoredChanges();
        int noRNQuorum = 0;
        for (RepGroup rg : this.topo.getRepGroupMap().getAll()) {
            Collection<RepNode> rns = rg.getRepNodes();
            int rf = rns.size();
            int numNeeded = rf / 2 + 1;
            int numBadInShard = 0;
            for (RepNode rn : rns) {
                RepNodeStatus rnStatus = rnMap.get(rn);
                Object status = rnStatus == null ? ConfigurableService.ServiceStatus.UNREACHABLE : rnStatus.getServiceStatus();
                if (((Enum)status).equals((Object)ConfigurableService.ServiceStatus.RUNNING)) continue;
                RepNodeId rid = (RepNodeId)rn.getResourceId();
                StringBuilder sb = new StringBuilder();
                sb.append("RN is not running: ").append(status);
                if (rnStatus == null) {
                    ServiceChange change = monitoredChanges.get(rid);
                    sb.append(", last known status is ");
                    if (change == null) {
                        sb.append("UNKNOWN");
                    } else {
                        String reportTime = FormatUtils.formatDateAndTime(change.getChangeTime());
                        sb.append((Object)change.getStatus()).append(", reported at ").append(reportTime);
                    }
                }
                StorageNode sn = this.topo.get(rn.getStorageNodeId());
                this.problemReport.add(new Problem(rid, sn.getHostname(), sn.getRegistryPort(), sb.toString()));
                ++numFail;
                ++numBadInShard;
            }
            int numFailAN = 0;
            Map<ArbNode, ArbNodeStatus> anMap = this.collector.getANMap();
            Collection<ArbNode> ans = rg.getArbNodes();
            for (ArbNode an : ans) {
                ArbNodeStatus anStatus = anMap.get(an);
                ConfigurableService.ServiceStatus status = anStatus == null ? ConfigurableService.ServiceStatus.UNREACHABLE : anStatus.getServiceStatus();
                if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) continue;
                ArbNodeId aid = (ArbNodeId)an.getResourceId();
                StringBuilder sb = new StringBuilder();
                sb.append("AN is not running: ").append((Object)status);
                if (anStatus == null) {
                    ServiceChange change = monitoredChanges.get(aid);
                    sb.append(", last known status is ");
                    if (change == null) {
                        sb.append("UNKNOWN");
                    } else {
                        String reportTime = FormatUtils.formatDateAndTime(change.getChangeTime());
                        sb.append((Object)change.getStatus()).append(", reported at ").append(reportTime);
                    }
                }
                StorageNode sn = this.topo.get(an.getStorageNodeId());
                this.problemReport.add(new Problem(aid, sn.getHostname(), sn.getRegistryPort(), sb.toString()));
                ++numFailAN;
                ++numBadInShard;
            }
            if (numBadInShard <= 0) continue;
            failedShards.put(rg.getResourceId(), numBadInShard);
            if (rf == 2 && !ans.isEmpty()) {
                if (numBadInShard + numFailAN <= 1) continue;
                ++noRNQuorum;
                continue;
            }
            if (numBadInShard < numNeeded) continue;
            ++noRNQuorum;
        }
        boolean noAdminQuorum = false;
        if (this.params != null) {
            Map<AdminId, PingCollector.AdminInfo> adminMap = this.collector.getAdminMap();
            int numAdmins = this.params.getAdminIds().size();
            int numNeeded = numAdmins / 2 + 1;
            for (AdminId aid : this.params.getAdminIds()) {
                ConfigurableService.ServiceStatus status;
                PingCollector.AdminInfo ainfo = adminMap.get(aid);
                AdminStatus adminStatus = null;
                if (ainfo != null) {
                    adminStatus = ainfo.adminStatus;
                }
                if ((status = adminStatus == null ? ConfigurableService.ServiceStatus.UNREACHABLE : adminStatus.getServiceStatus()).equals((Object)ConfigurableService.ServiceStatus.RUNNING)) continue;
                AdminParams ap = this.params.get(aid);
                StorageNodeId snId = ap.getStorageNodeId();
                StorageNodeParams snp = this.params.get(snId);
                this.problemReport.add(new Problem(aid, snp.getHostname(), snp.getRegistryPort(), "Admin is not running: " + (Object)((Object)status)));
                failedAdmins.add(aid);
                ++numFail;
            }
            if (failedAdmins.size() >= numNeeded) {
                noAdminQuorum = true;
            }
        } else {
            ++numFail;
        }
        if (noRNQuorum > 0) {
            return ExitCode.EXIT_NO_SHARD_QUORUM;
        }
        if (noAdminQuorum) {
            return ExitCode.EXIT_NO_ADMIN_QUORUM;
        }
        if (numFail > 0) {
            return ExitCode.EXIT_OPERATIONAL;
        }
        return ExitCode.EXIT_OK;
    }

    private static void createResultsJson(ObjectNode on, PingResult result) {
        if (result == null) {
            return;
        }
        on.put("operation", COMMAND_NAME);
        on.put("return_code", result.getErrorCode());
        on.put("description", result.getDescription());
        on.put(EXIT_CODE_FIELD, result.getExitCode().value());
    }

    private static void displayExitJson(PrintStream ps, ExitCode exitCode, String errorMsg) {
        ObjectNode exitStatus = JsonUtils.createObjectNode();
        PingResult pingResult = new PingResult(exitCode, errorMsg);
        Ping.createResultsJson(exitStatus, pingResult);
        ObjectWriter writer = JsonUtils.createWriter(true);
        try {
            ps.println(writer.writeValueAsString(exitStatus));
        }
        catch (IOException e) {
            ps.println(e);
        }
    }

    private void addProblemReport(ObjectNode resultsJson) {
        if (this.problemReport.isEmpty()) {
            return;
        }
        Object[] problemArray = new Problem[this.problemReport.size()];
        problemArray = this.problemReport.toArray(problemArray);
        Arrays.sort(problemArray);
        ArrayNode problemJson = resultsJson.putArray("problems");
        for (Object p : problemArray) {
            ((Problem)p).addToArrayNode(problemJson);
        }
    }

    private static void checkIfSNAIsDeployed(String hostPort) {
        HostPort hp = HostPort.parse(hostPort);
        try {
            Registry snRegistry = RegistryUtils.getRegistry(hp.hostname(), hp.port(), null);
            ArrayList serviceNames = new ArrayList();
            Collections.addAll(serviceNames, snRegistry.list());
            if (serviceNames.contains("snaService")) {
                System.err.println("SNA at hostname: " + hp.hostname() + ", registry port: " + hp.port() + " is not registered." + "\n\tNo further information is available");
                return;
            }
        }
        catch (RemoteException e) {
            System.err.println("Could not connect to registry at " + hostPort + " " + e.getMessage());
        }
    }

    private static void exit(boolean dontExit, String msg, ExitCode exitCode, boolean getJson, PrintStream ps) {
        if (msg != null && ps != null) {
            if (getJson) {
                Ping.displayExitJson(ps, exitCode, msg);
            } else {
                ps.println(msg);
            }
        }
        if (!dontExit) {
            System.exit(exitCode.value());
        }
    }

    private static void exitNoDisplay(boolean dontExit, ExitCode exitCode) {
        Ping.exit(dontExit, null, exitCode, false, null);
    }

    static class Problem
    implements Comparable<Problem> {
        private final String componentName;
        private final String description;
        private final String hostname;
        private final int port;

        Problem(ResourceId resourceId, String hostname, int port, String description) {
            this.componentName = resourceId.toString();
            this.description = description;
            this.hostname = hostname;
            this.port = port;
        }

        Problem(ResourceId resourceId, String hostname, int port, String description, Exception e) {
            this.componentName = resourceId.toString();
            this.description = description + " " + e.getMessage();
            this.hostname = hostname;
            this.port = port;
        }

        Problem(String description) {
            this.componentName = null;
            this.description = description;
            this.hostname = null;
            this.port = 0;
        }

        public Problem(String hostname, int port, String description, RemoteException e) {
            this.componentName = null;
            this.description = description + " " + e.getMessage();
            this.hostname = hostname;
            this.port = port;
        }

        private void addToArrayNode(ArrayNode problemList) {
            ObjectNode on = problemList.addObject();
            on.put("component", this.componentName);
            on.put("hostname", this.hostname);
            on.put("port", this.port);
            on.put("description", this.description);
        }

        @Override
        public int compareTo(Problem o) {
            if (o == null) {
                return 1;
            }
            if (o.componentName == null) {
                return 1;
            }
            if (this.componentName == null) {
                if (o.componentName == null) {
                    return 0;
                }
                return -1;
            }
            return this.componentName.compareTo(o.componentName);
        }
    }

    private static class PingResult
    implements CommandResult {
        private final ExitCode exitCode;
        private final String errorMsg;

        PingResult(ExitCode exitCode, String errorMsg) {
            this.exitCode = exitCode;
            this.errorMsg = errorMsg;
        }

        @Override
        public String getReturnValue() {
            return null;
        }

        ExitCode getExitCode() {
            return this.exitCode;
        }

        @Override
        public String getDescription() {
            if (this.errorMsg == null) {
                return this.exitCode.getDescription();
            }
            return this.exitCode.getDescription() + " - " + this.errorMsg;
        }

        @Override
        public int getErrorCode() {
            return this.exitCode.getErrorCode().getValue();
        }

        @Override
        public String[] getCleanupJobs() {
            return null;
        }
    }

    public static interface ArbNodeStatusFunction {
        public ArbNodeStatus get(ArbNode var1);
    }

    public static interface RepNodeStatusFunction {
        public RepNodeStatus get(RepNode var1);
    }

    public static interface AdminStatusFunction {
        public AdminStatus get(AdminId var1);
    }

    public static enum ExitCode {
        EXIT_OK(0, ErrorMessage.NOSQL_5000, "No errors found"),
        EXIT_OPERATIONAL(1, ErrorMessage.NOSQL_5301, "Store is operational but some services are unavailable"),
        EXIT_NO_ADMIN_QUORUM(2, ErrorMessage.NOSQL_5302, "All data operations are full available but administrative changes are disabled"),
        EXIT_NO_SHARD_QUORUM(3, ErrorMessage.NOSQL_5303, "One or more shards cannot accept write operations"),
        EXIT_USAGE(100, ErrorMessage.NOSQL_5100, "Usage error"),
        EXIT_TOPOLOGY_FAILURE(101, ErrorMessage.NOSQL_5304, "Topology cannot be found"),
        EXIT_UNEXPECTED(102, ErrorMessage.NOSQL_5500, "Internal error");

        private final int returnCode;
        private final ErrorMessage errorCode;
        private final String description;

        private ExitCode(int returnCode, ErrorMessage errorCode, String description) {
            this.returnCode = returnCode;
            this.errorCode = errorCode;
            this.description = description;
        }

        public int value() {
            return this.returnCode;
        }

        public ErrorMessage getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

