/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.lbs.util.APIKeyManager;
import oracle.lbs.util.APIKeyStorage;
import oracle.sdovis.util.XMLDOMParser;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class APIKeyFileStore
implements APIKeyStorage {
    String configFileFolder;
    String keyFileName = "api-keys.xml";

    public void setConfigFileFolder(String folder) {
        this.configFileFolder = folder;
        if (!this.configFileFolder.endsWith(File.pathSeparator)) {
            this.configFileFolder = this.configFileFolder + File.pathSeparator;
        }
    }

    public void setKeyFileName(String file) {
        this.keyFileName = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseFile() {
        XMLDocument doc = null;
        DOMParser parser = null;
        doc = null;
        parser = new DOMParser();
        Reader rdr = null;
        try {
            rdr = new FileReader(this.configFileFolder + this.keyFileName);
            parser.setErrorStream((OutputStream)System.err);
            parser.setValidationMode(0);
            parser.setEntityResolver((EntityResolver)new XMLDOMParser.MyResolver());
            parser.setPreserveWhitespace(false);
            parser.showWarnings(true);
            parser.parse(rdr);
            XMLDocument xMLDocument = doc = parser.getDocument();
            return xMLDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            Document document = null;
            return document;
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public synchronized HashMap loadAll(HashMap<String, APIKeyManager.APIKeyEntry> cache) {
        Document doc;
        if (cache == null) {
            cache = new HashMap();
        }
        if ((doc = this.parseFile()) == null) {
            return null;
        }
        Node root = doc.getElementsByTagName("apps").item(0);
        if (root == null) {
            System.err.println("Missing <apps> root node.");
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
        try {
            ArrayList nodes = XMLDOMParser.getRealChildNodes(root);
            for (int i = 0; i < nodes.size(); ++i) {
                Node app = (Node)nodes.get(i);
                APIKeyManager.APIKeyEntry ent = new APIKeyManager.APIKeyEntry();
                ent.hash = XMLDOMParser.getAttribute(app, "hash");
                ent.appName = XMLDOMParser.getSubElementValue(app, "appName");
                ent.uid = XMLDOMParser.getSubElementValue(app, "uid");
                ent.contact = XMLDOMParser.getSubElementValue(app, "contact");
                String issueDate = XMLDOMParser.getSubElementValue(app, "issueDate");
                ent.issueDate = format.parse(issueDate);
                String expires = XMLDOMParser.getSubElementValue(app, "expires");
                ent.expireWithinDays = Integer.parseInt(expires);
                ent.organization = XMLDOMParser.getSubElementValue(app, "org");
                cache.put(ent.hash, ent);
            }
            return cache;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveAll(HashMap<String, APIKeyManager.APIKeyEntry> cache) {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<!-- Warning: this file is automatically generated. Do not modify! -->\n");
        sb.append("<apps>\n");
        Iterator<Map.Entry<String, APIKeyManager.APIKeyEntry>> iter = cache.entrySet().iterator();
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
        while (iter.hasNext()) {
            APIKeyManager.APIKeyEntry entry = (APIKeyManager.APIKeyEntry)((Object)iter.next());
            sb.append("  <app hash=\"" + entry.hash + "\">\n");
            sb.append("    <uid>" + entry.uid + "</uid>\n");
            sb.append("    <contact>" + entry.contact + "</uid>\n");
            sb.append("    <issueDate>" + format.format(entry.issueDate) + "</issueDate>\n");
            sb.append("    <expires" + entry.expireWithinDays + "</expires>\n");
            sb.append("    <org>" + entry.organization + "</org>\n");
            sb.append("  </app>\n");
        }
        sb.append("</apps>\n");
        File f = new File(this.configFileFolder + this.keyFileName);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write(sb.toString());
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public synchronized void update(APIKeyManager.APIKeyEntry entry) {
    }

    @Override
    public synchronized void delete(APIKeyManager.APIKeyEntry entry) {
    }

    @Override
    public synchronized void insert(APIKeyManager.APIKeyEntry entry) {
    }
}

