/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.mapcache;

import java.awt.geom.Rectangle2D;

public class TileDefinition {
    public static final int FORMAT_GIF = 7;
    public static final int FORMAT_PNG = 14;
    public static final int FORMAT_JPEG = 22;
    public static final String CUSTOM_TEXT_PREFIX = "?&?";
    private int tileImageWidth = 0;
    private int tileImageHeight = 0;
    private int zoomLevel = 0;
    private Rectangle2D boundingBox = null;
    private int imageFormat = 14;
    private String zoomLevelName = null;
    private double scale = -1.0;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String serverURL = null;
    private long meshX = -1L;
    private long meshY = -1L;

    public TileDefinition(int zoomLevel, double scale, String zoomLevelName, Rectangle2D bbox, long meshX, long meshY, int imageWidth, int imageHeight, int format, String serverURL, String proxyHost, String proxyPort) {
        this.zoomLevel = zoomLevel;
        this.scale = scale;
        this.zoomLevelName = zoomLevelName;
        this.boundingBox = bbox;
        this.meshX = meshX;
        this.meshY = meshY;
        this.tileImageWidth = imageWidth;
        this.tileImageHeight = imageHeight;
        this.imageFormat = format;
        this.serverURL = serverURL;
        this.proxyHost = proxyHost;
        try {
            this.proxyPort = Integer.parseInt(proxyPort);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public double getScale() {
        return this.scale;
    }

    public String getZoomLevelName() {
        return this.zoomLevelName;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public int getImageWidth() {
        return this.tileImageWidth;
    }

    public int getImageHeight() {
        return this.tileImageHeight;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public void setImageSize(int width, int height) {
        this.tileImageWidth = width;
        this.tileImageHeight = height;
    }

    public void setBoundingBox(Rectangle2D bbox) {
        this.boundingBox = bbox;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public long getMeshX() {
        return this.meshX;
    }

    public long getMeshY() {
        return this.meshY;
    }
}

