/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.svg.SVGUtil;
import oracle.sdovis.util.RectArray;
import oracle.sql.STRUCT;

public class LabelingTest
extends JFrame {
    private static final int FLOAT_FACTOR = 10;
    private static final String ds = "sdovis_ds";
    static Image img = null;
    static final int mapWidth = 640;
    static final int mapHeight = 400;
    static final Rectangle2D r2d = new Rectangle2D.Double(1.0, 21.0, 638.0, 378.0);
    private static StyleText sty = new StyleText(new Font("Sans Serif", 1, 14), Color.red);
    private static RectArray[] limitRects = new RectArray[10];
    private static Shape[] shapes = null;

    public LabelingTest() {
        this.setSize(640, 400);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paint(g);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, 1200, 1200);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
        for (int i = 0; i < limitRects.length; ++i) {
            for (int k = 0; k < limitRects[i].size(); ++k) {
                Rectangle2D r2 = limitRects[i].elementAt(k);
                if (r2 == null) continue;
                g2.draw(r2);
            }
        }
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.blue);
        Random rand = new Random();
        if (shapes != null) {
            int i;
            for (i = 0; i < shapes.length; ++i) {
                g2.setColor(new Color(Math.abs(rand.nextInt()) % 255, Math.abs(rand.nextInt()) % 255, Math.abs(rand.nextInt()) % 255));
                g2.draw(shapes[i]);
            }
            for (i = 0; i < shapes.length; ++i) {
                Shape shp = shapes[i];
                float[] coords = new float[4];
                float[] res = null;
                res = LabelingTest.findTextLabelPoint(shp, coords, sty, "Nashua River", true, limitRects, 1.0, r2d);
                if (res == null) continue;
                try {
                    sty.drawString(g2, (int)res[0], (int)res[1], res[2], "Nashua River", null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.out.println("x:" + res[0] + ", y:" + res[1] + ", rotation:" + res[2]);
            }
        }
    }

    public static void drawStuff(Graphics2D g2) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shape[] getShape(String query) {
        ArrayList<Shape> al = new ArrayList<Shape>();
        double[] mbr = null;
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            DSManager.registerOracleJdbcDS(ds, "elocation.us.oracle.com", "1521", "orcl901", "mapper", "mapper", "thin", 1);
            conn = ((AbstractDBDataSource)DSManager.get(ds)).getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                STRUCT obj = (STRUCT)rs.getObject(1);
                JSDOGeometry geom = JSDOGeometry.loadFromDB(obj);
                al.add(geom.createShape());
                double[] gmbr = geom.getMBR();
                if (mbr == null) {
                    mbr = new double[]{gmbr[0], gmbr[1], gmbr[2], gmbr[3]};
                    continue;
                }
                LabelingTest.expandMBR(mbr, gmbr[0], gmbr[1], gmbr[2], gmbr[3]);
            }
            XFViewPort view = new XFViewPort();
            view.setDeviceView(1, 1, 639, 399);
            view.setDataView((double)mbr[0], (double)mbr[1], (double)mbr[2], mbr[3]);
            AffineTransform xfm = view.getAffineTransform();
            Shape[] res = new Shape[al.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = xfm.createTransformedShape((Shape)al.get(i));
            }
            Shape[] shapeArray = res;
            return shapeArray;
        }
        catch (Exception e) {
            Shape[] shapeArray = null;
            return shapeArray;
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    private static void expandMBR(double[] mbr, double x1, double y1, double x2, double y2) {
        if (mbr[0] > x1) {
            mbr[0] = x1;
        }
        if (mbr[1] > y1) {
            mbr[1] = y1;
        }
        if (mbr[2] < x2) {
            mbr[2] = x2;
        }
        if (mbr[3] < y2) {
            mbr[3] = y2;
        }
    }

    public static void main(String[] args) {
        new LabelingTest();
    }

    public static float[] findTextLabelPoint(Shape shp, float[] coords, StyleText stx, String label, boolean forcedLabeling, RectArray[] limitRects, double scale, Rectangle2D r2d) {
        int[] segLength;
        int[] type;
        int[] y;
        int[] x;
        if (shp == null) {
            return null;
        }
        Rectangle2D textRect = stx.getVisualBounds(label, null);
        Rectangle shpRect = shp.getBounds();
        float tx = (float)(textRect.getMinX() / scale);
        float ty = (float)(textRect.getMinY() / scale);
        float tw = (float)(textRect.getWidth() / scale);
        float th = (float)(textRect.getHeight() / scale);
        if ("COLISEUM AVE".equals(label)) {
            // empty if block
        }
        float[] segcoords = new float[4];
        PathIterator pi = shp.getPathIterator(null);
        int coordNum = LabelingTest.getCoordinatesNumber(pi);
        pi = shp.getPathIterator(null);
        coordNum = LabelingTest.getCoordinates(pi, x = new int[coordNum * 2], y = new int[coordNum * 2], type = new int[coordNum * 2], segLength = new int[coordNum * 2], r2d);
        if (coordNum < 2) {
            return null;
        }
        int[] pointIndex = new int[2];
        float[] resultCoords = new float[4];
        float dist = 0.0f;
        int startIdx = 0;
        while (startIdx < coordNum && LabelingTest.findBaseLinePoints(pointIndex, tw, x, y, coordNum, type, startIdx)) {
            dist = LabelingTest.shiftBaseLine(pointIndex[0], pointIndex[1], x, y, (float)((double)th / 3.0), resultCoords);
            if (label.equals("COLISEUM AVE")) {
                System.out.println("<path stroke=\"green\" fill=\"none\" d=\"M" + resultCoords[0] + "," + resultCoords[1] + " L" + resultCoords[2] + "," + resultCoords[3] + "\"/>\n");
            }
            if ((double)dist > (double)th * 2.0 / 3.0) {
                startIdx = LabelingTest.findNextStartPoint(startIdx, (int)tw, segLength, coordNum);
                continue;
            }
            float x1 = resultCoords[0];
            float y1 = resultCoords[1];
            float x2 = resultCoords[2];
            float y2 = resultCoords[3];
            boolean rotationComputed = false;
            float len = (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            float factor = (len - tw) / (2.0f * len);
            float startX = x1 + factor * (x2 - x1);
            float startY = y1 + factor * (y2 - y1);
            float endX = x2 - factor * (x2 - x1);
            float endY = y2 - factor * (y2 - y1);
            float ratio = (y2 - y1) / (x2 - x1);
            ArrayList rects = LabelHelper.getBoundingRectsWithoutConflicts(limitRects, (double)startX, (double)startY, (double)endX, (double)endY, (double)th);
            if (rects == null && len > 2.0f * tw && (rects = LabelHelper.getBoundingRectsWithoutConflicts(limitRects, (double)(startX = x1 + (factor = (len / 2.0f - tw) / (2.0f * len)) * (x2 - x1)), (double)(startY = y1 + factor * (y2 - y1)), (double)(endX = (x1 + x2) / 2.0f - factor * (x2 - x1)), (double)(endY = (y1 + y2) / 2.0f - factor * (y2 - y1)), (double)th)) == null) {
                startX = (x1 + x2) / 2.0f + factor * (x2 - x1);
                startY = (y1 + y2) / 2.0f + factor * (y2 - y1);
                endX = x2 - factor * (x2 - x1);
                endY = y2 - factor * (y2 - y1);
                rects = LabelHelper.getBoundingRectsWithoutConflicts(limitRects, (double)startX, (double)startY, (double)endX, (double)endY, (double)th);
            }
            if (rects != null) {
                for (int i = 0; i < rects.size(); ++i) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, (Rectangle2D)rects.get(i));
                }
                coords[0] = startX;
                coords[1] = startY;
                coords[2] = (float)Math.atan((y2 - y1) / (x2 - x1));
                return coords;
            }
            startIdx = LabelingTest.findNextStartPoint(startIdx, (int)tw, segLength, coordNum);
        }
        return null;
    }

    private static int findNextStartPoint(int startIdx, int textLength, int[] segLengths, int coordNum) {
        int i;
        int offset = 0;
        for (i = startIdx + 1; i < coordNum; ++i) {
            offset = segLengths[i] == 0 ? 0 : (offset += segLengths[i]);
            if (offset > textLength / 3) break;
        }
        return i;
    }

    private static int getCoordinatesNumber(PathIterator pi) {
        if (pi.isDone()) {
            return 0;
        }
        int count = 0;
        while (!pi.isDone()) {
            pi.next();
            ++count;
        }
        return count;
    }

    private static int getCoordinates(PathIterator pi, int[] x, int[] y, int[] type, int[] segLength, Rectangle2D r2d) {
        int ly;
        int lx;
        float[] segcoords = new float[4];
        int x1 = (int)(r2d.getMinX() * 10.0);
        int x2 = (int)(r2d.getMaxX() * 10.0);
        int y1 = (int)(r2d.getMinY() * 10.0);
        int y2 = (int)(r2d.getMaxY() * 10.0);
        if (pi.isDone()) {
            return 0;
        }
        int ltype = pi.currentSegment(segcoords);
        int llx = lx = (int)(segcoords[0] * 10.0f);
        int lly = ly = (int)(segcoords[1] * 10.0f);
        pi.next();
        int count = 0;
        while (!pi.isDone()) {
            Point2D p;
            ArrayList intersections;
            int ctype = pi.currentSegment(segcoords);
            int cx = (int)(segcoords[0] * 10.0f);
            int cy = (int)(segcoords[1] * 10.0f);
            if (LabelingTest.pointInsideRectangle(x1, y1, x2, y2, lx, ly)) {
                x[count] = lx;
                y[count] = ly;
                type[count] = ltype;
                if (LabelingTest.pointInsideRectangle(x1, y1, x2, y2, cx, cy)) {
                    x[++count] = cx;
                    y[count] = cy;
                    type[count] = ctype;
                } else if (ctype == 1 && (intersections = SVGUtil.getIntersectionPoints(x1, y1, x2, y2, lx, ly, cx, cy)).size() > 0) {
                    p = (Point2D)intersections.get(0);
                    x[++count] = (int)p.getX();
                    y[count] = (int)p.getY();
                    type[count] = 1;
                }
            } else if (ctype == 1 && (intersections = SVGUtil.getIntersectionPoints(x1, y1, x2, y2, lx, ly, cx, cy)) != null && intersections.size() > 0) {
                p = (Point2D)intersections.get(0);
                x[count] = (int)p.getX();
                y[count] = (int)p.getY();
                type[count] = 0;
                ++count;
                if (intersections.size() == 1) {
                    x[count] = cx;
                    y[count] = cy;
                } else {
                    p = (Point2D)intersections.get(1);
                    x[count] = (int)p.getX();
                    y[count] = (int)p.getY();
                }
                type[count] = 1;
            }
            lx = cx;
            ly = cy;
            ltype = ctype;
            pi.next();
        }
        segLength[0] = 0;
        for (int i = 1; i <= count; ++i) {
            segLength[i] = type[i] == 0 ? 0 : (int)(Math.sqrt((x[i] - x[i - 1]) * (x[i] - x[i - 1]) + (y[i] - y[i - 1]) * (y[i] - y[i - 1])) / 10.0);
        }
        return count + 1;
    }

    private static boolean pointInsideRectangle(float x1, float y1, float x2, float y2, float x, float y) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static boolean findBaseLinePoints(int[] pointsIndex, float labelLength, int[] x, int[] y, int coordNum, int[] type, int startIdx) {
        float labelLengthSQR = labelLength * labelLength * 10.0f * 10.0f;
        for (int i = startIdx; i < coordNum; ++i) {
            if (type[i] == 0) {
                startIdx = i;
                continue;
            }
            int lengthSQR = (x[i] - x[startIdx]) * (x[i] - x[startIdx]) + (y[i] - y[startIdx]) * (y[i] - y[startIdx]);
            if (!(labelLengthSQR <= (float)lengthSQR)) continue;
            pointsIndex[0] = startIdx;
            pointsIndex[1] = i;
            return true;
        }
        return false;
    }

    public static float shiftBaseLine(int startIdx, int endIdx, int[] x, int[] y, float offset, float[] resultCoords) {
        boolean isVertical = false;
        float x1 = (float)(1.0 * (double)x[startIdx] / 10.0);
        float x2 = (float)(1.0 * (double)x[endIdx] / 10.0);
        float y1 = (float)(1.0 * (double)y[startIdx] / 10.0);
        float y2 = (float)(1.0 * (double)y[endIdx] / 10.0);
        float ox1 = x1;
        float oy1 = y1;
        float ox2 = x2;
        float oy2 = y2;
        float a = 0.0f;
        float b = 0.0f;
        if (x1 == x2) {
            a = x2;
        } else {
            a = (y2 - y1) / (x2 - x1);
            b = (x2 * y1 - x1 * y2) / (x2 - x1);
        }
        float area = 0.0f;
        float lx = x1;
        float ly = y1;
        float offsetLength = 0.0f;
        float lengthSQR = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        for (int i = startIdx + 1; i <= endIdx; ++i) {
            float segLength;
            float newOffsetLength;
            float px = (float)(1.0 * (double)x[i] / 10.0);
            float py = (float)(1.0 * (double)y[i] / 10.0);
            float lineDist = 0.0f;
            int dist1 = 0;
            int dist2 = 0;
            if (x1 == x2) {
                if (px < x1) {
                    lineDist = Math.abs(x1 - px);
                    x1 = px;
                    x2 = px;
                }
                dist1 = (int)Math.abs(x1 - lx);
                dist2 = (int)Math.abs(x1 - px);
                newOffsetLength = Math.abs(y1 - py);
                segLength = Math.abs(py - ly);
            } else if (y1 == y2) {
                if (py < y1) {
                    lineDist = Math.abs(y1 - py);
                    y1 = py;
                    y2 = py;
                }
                dist1 = (int)Math.abs(y1 - ly);
                dist2 = (int)Math.abs(y1 - py);
                newOffsetLength = Math.abs(x1 - px);
                segLength = Math.abs(px - lx);
            } else {
                float tmpY = a * px + b;
                segLength = (float)Math.sqrt((px - lx) * (px - lx) + (py - ly) * (py - ly));
                float factor = (float)Math.sqrt(a * a + 1.0f);
                if (tmpY > py) {
                    lineDist = Math.abs(a * px - py + b) / factor;
                    b += py - tmpY;
                    float xOffset = (x2 - x1) * (y2 - y1) * (py - tmpY) / lengthSQR;
                    float yOffset = py - tmpY - (y2 - y1) * (y2 - y1) * (py - tmpY) / lengthSQR;
                    x1 -= xOffset;
                    y1 += yOffset;
                    x2 -= xOffset;
                    y2 += yOffset;
                    dist1 = (int)(Math.abs(a * lx - ly + b) / factor);
                    dist2 = 0;
                } else {
                    dist1 = (int)(Math.abs(a * lx - ly + b) / factor);
                    dist2 = (int)(Math.abs(a * px - py + b) / factor);
                }
                newOffsetLength = offsetLength + segLength;
            }
            area += (float)(dist1 + dist2) * segLength / 2.0f + offsetLength * lineDist;
            offsetLength = newOffsetLength;
            lx = px;
            ly = py;
        }
        if (x1 < x2 || x1 == x2 && y1 < y2) {
            resultCoords[0] = x1;
            resultCoords[1] = y1;
            resultCoords[2] = x2;
            resultCoords[3] = y2;
        } else {
            resultCoords[0] = x2;
            resultCoords[1] = y2;
            resultCoords[2] = x1;
            resultCoords[3] = y1;
        }
        if (x1 == x2) {
            resultCoords[0] = resultCoords[0] + offset;
            resultCoords[2] = resultCoords[0];
        } else if (y1 == y2) {
            resultCoords[1] = resultCoords[1] - offset;
            resultCoords[3] = resultCoords[1];
        } else {
            float length = (float)Math.sqrt(lengthSQR);
            float xoffset = offset * Math.abs(oy2 - oy1) / length;
            float yoffset = offset * Math.abs(ox2 - ox1) / length;
            if (resultCoords[3] > resultCoords[1]) {
                resultCoords[0] = resultCoords[0] + xoffset;
                resultCoords[2] = resultCoords[2] + xoffset;
            } else {
                resultCoords[0] = resultCoords[0] - xoffset;
                resultCoords[2] = resultCoords[2] - xoffset;
            }
            resultCoords[1] = resultCoords[1] - yoffset;
            resultCoords[3] = resultCoords[3] - yoffset;
        }
        return area / offsetLength;
    }

    static {
        for (int i = 0; i < limitRects.length; ++i) {
            LabelingTest.limitRects[i] = new RectArray(25);
        }
        shapes = LabelingTest.getShape("select geometry from map_rivers_us where rowid = 'AAASSTAAUAABmnTAAF' ");
    }
}

