/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.HeatMapStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.style.Style;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.stylex.HeatMapStyleModifiers;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.theme.VectorThemeDefinition;

public class LoadThemeData2 {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    Theme mTheme = null;
    Rectangle2D mQueryWin = null;
    VisContext vc = null;
    long reqTimeout = 0L;
    Exception exception = null;

    public LoadThemeData2(Theme mt, Rectangle2D mqw, VisContext vc) {
        this.mTheme = mt;
        this.mQueryWin = mqw;
        this.vc = vc;
        if (vc.isTileRequest() && mt.getDefinition() instanceof VectorThemeDefinition) {
            if (this.isLabelTheme(mt, vc)) {
                mt.windowBuffer = VisContext.BUFFER_LABEL_THEME;
            } else if (ThemeUtils.isHeatMapTheme(mt.getDefinition(), vc)) {
                HeatMapStyle style = ThemeUtils.getHeatMapStyle(mt.getDefinition(), vc);
                HeatMapStyleModel model = (HeatMapStyleModel)style.getModel();
                if (model != null) {
                    double splRadius = model.getSpotLightRadius();
                    HeatMapStyleModifiers hmmods = (HeatMapStyleModifiers)style.convertToPixelSize(vc);
                    if (hmmods != null) {
                        splRadius = hmmods.getSpotLightRadius();
                    }
                    mt.windowBuffer = (int)splRadius;
                } else {
                    mt.windowBuffer = VisContext.BUFFER_VECTOR_THEME;
                }
            } else {
                mt.windowBuffer = VisContext.BUFFER_VECTOR_THEME;
            }
            this.mQueryWin = vc.getExtendedQueryWindow(mt.windowBuffer);
        }
        this.reqTimeout = mt instanceof WMSMapTheme || mt instanceof MapCacheTheme ? mt.getDecorator().getRequestTimeout() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.finer("LoadThemeData2 running thread: " + Thread.currentThread().getName());
        try {
            this.mTheme.prepareData(this.mQueryWin, this.vc);
            this.mTheme.postPreparation(this.vc);
        }
        catch (OutOfMemoryError om) {
            log.severe("Out of memory error while preparing " + this.mTheme.getName() + " : " + om.getMessage());
            if (this.vc != null) {
                this.vc.setDataException(new DataException("Out of memory."));
            }
        }
        catch (DataException de) {
            if (de.isAbortedByUser()) {
                log.log(Level.FINEST, "Theme " + this.mTheme.getName() + " is aborted per user's request.", de);
            } else {
                this.exception = de;
                if (this.vc != null) {
                    this.vc.setDataException(de);
                }
                log.log(Level.SEVERE, "Exception fetching data for theme " + this.mTheme.getName() + ".", de);
            }
        }
        finally {
            try {
                this.mTheme.getDecorator().setPrepared(true);
            }
            catch (Exception npe) {}
            this.mTheme = null;
            this.vc = null;
        }
    }

    private boolean isLabelTheme(Theme theme, VisContext vc) {
        String[] styles = theme.getRenderingStyles();
        if (styles == null) {
            return false;
        }
        for (int i = 0; i < styles.length; ++i) {
            Style sty = MapMaker.getStyleWithName(styles[i], theme.getDataSourceName(), vc);
            if (sty == null) continue;
            if (sty.getModel().getType() == 5) {
                return true;
            }
            if (!theme.isTextLabelPresent()) continue;
            if (sty.getModel().getType() == 2) {
                return true;
            }
            if (!(sty instanceof BucketStyle)) continue;
            BucketStyle bsty = (BucketStyle)sty;
            for (int j = 0; j < bsty.getNumBuckets(); ++j) {
                Bucket b = bsty.getBucket(j);
                Style s = (Style)b.getRenderStyle();
                if (s == null) {
                    s = MapMaker.getStyleWithName(b.getRenderStyleName(), theme.getDataSourceName(), vc);
                }
                if (s == null || s.getModel().getType() != 2) continue;
                return true;
            }
        }
        return false;
    }
}

