/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.ProjAzEd;
import oracle.sdovis.SRSConstants;
import oracle.sdovis.Spheroid;
import oracle.sdovis.VisContext;
import oracle.sdovis.util.CoordList;
import oracle.sdovis.util.ElemList;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class SRS {
    public static final int UNDEFINED_CS = 0;
    public static final int GEODETIC_CS = 1;
    public static final int PROJECTED_CS = 2;
    public static final int LOCAL_CS = 3;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String mDataSource = null;
    private int srid = 0;
    private String unit = null;
    private double conversionFactor = 1.0;
    private Spheroid spheroid = null;
    private int csType = 0;
    public static final double srid54004_minx = -2.00375083E7;
    public static final double srid54004_maxx = 2.00375083E7;
    public static final double srid54004_miny = -7.42569498E7;
    public static final double srid54004_maxy = 7.42569498E7;
    public static final double srid3785_minx = -2.00375083E7;
    public static final double srid3785_maxx = 2.00375083E7;
    public static final double srid3785_miny = -7.42997432E7;
    public static final double srid3785_maxy = 7.42997432E7;
    public static final double srid3857_minx = -2.00375083E7;
    public static final double srid3857_maxx = 2.00375083E7;
    public static final double srid3857_miny = -7.42997432E7;
    public static final double srid3857_maxy = 7.42997432E7;
    public static Hashtable distUnitList = new Hashtable(79);
    public static Hashtable angularUnitList = new Hashtable(17);

    public SRS() {
    }

    public SRS(String dataSrc) {
        this.mDataSource = dataSrc;
    }

    public void set(int srid, String unit, double conversionFactor, int coordSysType, Spheroid spheroid) {
        this.srid = srid;
        this.unit = unit;
        this.conversionFactor = conversionFactor;
        this.csType = coordSysType;
        this.spheroid = spheroid;
    }

    public boolean isGeodetic() {
        return this.csType == 1;
    }

    public int getCoordSysType() {
        return this.csType;
    }

    public int getSRID() {
        return this.srid;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public Rectangle2D getOptimalQueryWindow(double cx, double cy, double size, Rectangle2D deviceWin, VisContext vc) {
        size = Math.abs(size);
        if (this.isGeodetic() && "DECIMAL DEGREE".equals(this.unit) && MapMaker.getUGP()) {
            return this.getQW4GP(cx, cy, size, deviceWin, vc);
        }
        double ratio = deviceWin.getWidth() / deviceWin.getHeight();
        double h = size;
        double w = ratio * size;
        log.finest("*** isGeodetic=" + this.isGeodetic() + ", unit=" + this.unit);
        Rectangle2D.Double qw = new Rectangle2D.Double(cx - w / 2.0, cy - h / 2.0, w, h);
        boolean flag = false;
        if (this.isGeodetic() && "DECIMAL DEGREE".equals(this.unit)) {
            double minX = qw.getMinX();
            double minY = qw.getMinY();
            double maxX = qw.getMaxX();
            double maxY = qw.getMaxY();
            log.finest("before adjusting: minX = " + minX + ", maxX=" + maxX + " minY=" + minY + ", maxY=" + maxY + "  w=" + w + ", h=" + h);
            if (w >= 360.0) {
                double cx_;
                double d = cx_ = 180.0 - Math.abs(cx) >= Math.abs(cx) ? 0.0 : 180.0;
                if (cx_ == 0.0) {
                    minX = -180.0;
                    maxX = 180.0;
                } else {
                    minX = 0.0;
                    maxX = 360.0;
                }
                flag = true;
            }
            if (minY < -90.0) {
                minY = -90.0;
                flag = true;
            }
            if (maxY > 90.0) {
                maxY = 90.0;
                flag = true;
            }
            log.finest("After adjusting: minX = " + minX + ", maxX=" + maxX + " minY=" + minY + ", maxY=" + maxY + "  w=" + w + ", h=" + h);
            if (flag) {
                log.warning("Resizing query window to be within valid bounds.");
                qw = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
            }
        }
        return qw;
    }

    public Rectangle2D getOptimalQueryWindow(double x1, double y1, double x2, double y2, Rectangle2D deviceWin, VisContext vc) {
        if (this.isGeodetic() && "DECIMAL DEGREE".equals(this.unit) && GlobalVisContext.getUgp()) {
            double cx = x1 + (x2 - x1) / 2.0;
            double cy = y1 + (y2 - y1) / 2.0;
            double size = Math.abs(y2 - y1);
            return this.getQW4GP(cx, cy, size, deviceWin, vc);
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    private Rectangle2D getQW4GP(double cx, double cy, double size, Rectangle2D deviceWin, VisContext vc) {
        size = Math.abs(size);
        Rectangle2D qw = null;
        Proj[] pickedProj = new Proj[1];
        qw = ProjAzEd.getQueryWindow(cx, cy, size, deviceWin, pickedProj);
        vc.setProjection(pickedProj[0]);
        return qw;
    }

    public Spheroid getSpheroid() {
        return this.spheroid;
    }

    public double getRatioScale(double screeninchScale, Point2D center) {
        Double df_ = SRS.getDistanceConversionFactor(this.unit);
        boolean geodetic = this.isGeodetic();
        double df = 0.0;
        if (df_ == null && !geodetic) {
            return -1.0;
        }
        double inMeter = -1.0;
        if (geodetic) {
            if (this.spheroid == null) {
                return -1.0;
            }
            double[] p1 = new double[2];
            double[] p2 = new double[2];
            if (center == null) {
                p1[0] = 0.0;
                p2[0] = p1[0];
                p1[1] = 0.0;
                p2[1] = Math.PI / 180;
            } else {
                p1[0] = center.getX() * (Math.PI / 180);
                p2[0] = p1[0];
                p1[1] = center.getY() * (Math.PI / 180);
                p2[1] = (center.getY() + 1.0) * (Math.PI / 180);
            }
            inMeter = Util.dist(p1, p2, this.spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - this.spheroid.getEccentricity2()), this.spheroid.getFlattening());
            df = 1.0 / inMeter;
        } else {
            df = 1.0 / df_;
        }
        double inch_factor = 0.0254;
        Double df_inch = SRS.getDistanceConversionFactor("INCH");
        if (df_inch != null) {
            inch_factor = df_inch;
        }
        return screeninchScale / (inch_factor * df);
    }

    public double getScreenInchScale(double ratioScale, Point2D center) {
        Double df_ = SRS.getDistanceConversionFactor(this.unit);
        boolean geodetic = this.isGeodetic();
        double df = 0.0;
        if (df_ == null && !geodetic) {
            return -1.0;
        }
        double inMeter = -1.0;
        if (geodetic) {
            if (this.spheroid == null) {
                return -1.0;
            }
            double[] p1 = new double[2];
            double[] p2 = new double[2];
            if (center == null) {
                p1[0] = 0.0;
                p2[0] = p1[0];
                p1[1] = 0.0;
                p2[1] = Math.PI / 180;
            } else {
                p1[0] = center.getX() * (Math.PI / 180);
                p2[0] = p1[0];
                p1[1] = center.getY() * (Math.PI / 180);
                p2[1] = (center.getY() + 1.0) * (Math.PI / 180);
            }
            inMeter = Util.dist(p1, p2, this.spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - this.spheroid.getEccentricity2()), this.spheroid.getFlattening());
            df = 1.0 / inMeter;
        } else {
            df = 1.0 / df_;
        }
        double inch_factor = 0.0254;
        Double df_inch = SRS.getDistanceConversionFactor("INCH");
        if (df_inch != null) {
            inch_factor = df_inch;
        }
        return ratioScale * inch_factor * df;
    }

    public JSDOGeometry shift(JSDOGeometry in, Rectangle2D queryWin) {
        JSDOGeometry out;
        if (in == null) {
            return null;
        }
        if (!this.isGeodetic()) {
            out = in;
        } else {
            boolean isMBRSmall = SRS.isMBRSmall(in);
            boolean isMBRInWindow = SRS.isMBRInWindow(in, queryWin);
            out = isMBRSmall && isMBRInWindow ? in : (in.isPoint() ? (in.isOrientedPoint() ? this.shiftOrientedPoint(in, queryWin) : this.shiftSinglePoint(in, queryWin)) : (in.isMultiPoint() ? (in.isOrientedMultiPoint() ? this.shiftOrientedPoint(in, queryWin) : this.shiftMultiPoint(in, queryWin)) : this.shiftRegularGeometry(in, queryWin)));
        }
        return out;
    }

    private JSDOGeometry shiftSinglePoint(JSDOGeometry in, Rectangle2D queryWin) {
        double[] coords = in.getPoint();
        if (coords == null) {
            return null;
        }
        double x = SRS.shiftPoint(coords[0], queryWin.getMinX(), queryWin.getMaxX());
        JSDOGeometry rt = null;
        rt = coords.length > 2 && !Double.isNaN(coords[2]) ? new JSDOGeometry(x, coords[1], coords[2], this.srid) : new JSDOGeometry(x, coords[1], this.srid);
        return rt;
    }

    private JSDOGeometry shiftMultiPoint(JSDOGeometry in, Rectangle2D queryWin) {
        int dim = in.getDimensions();
        double[] coords = in.getOrdinatesArray();
        if (coords == null) {
            return null;
        }
        int[] elems = in.getElemInfo();
        boolean isSimgleElementUsed = elems.length == 3;
        int numPoints = 0;
        numPoints = isSimgleElementUsed ? elems[2] : elems.length / 3;
        if (numPoints < 1) {
            return null;
        }
        int[] elemsout = new int[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            elemsout[i] = elems[i];
        }
        double[] coordsout = new double[coords.length];
        double xmin = queryWin.getMinX();
        double xmax = queryWin.getMaxX();
        for (int i = 0; i < numPoints; ++i) {
            int iStart = i * dim;
            coordsout[iStart] = SRS.shiftPoint(coords[iStart], xmin, xmax);
            for (int j = 1; j < dim; ++j) {
                coordsout[iStart + j] = coords[iStart + j];
            }
        }
        JSDOGeometry rt = this.copyJGeometry(in, elemsout, coordsout);
        return rt;
    }

    private JSDOGeometry shiftOrientedPoint(JSDOGeometry in, Rectangle2D queryWin) {
        int dim = in.getDimensions();
        double[] coords = in.getOrdinatesArray();
        if (coords == null) {
            return null;
        }
        int[] elems = in.getElemInfo();
        int numPoints = elems.length / 6;
        if (numPoints < 1) {
            return null;
        }
        int[] elemsout = new int[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            elemsout[i] = elems[i];
        }
        double[] coordsout = new double[coords.length];
        double xmin = queryWin.getMinX();
        double xmax = queryWin.getMaxX();
        for (int i = 0; i < numPoints; ++i) {
            int iStart = i * (dim + 2);
            coordsout[iStart] = SRS.shiftPoint(coords[iStart], xmin, xmax);
            for (int j = 1; j < dim + 2; ++j) {
                coordsout[iStart + j] = coords[iStart + j];
            }
        }
        JSDOGeometry rt = this.copyJGeometry(in, elemsout, coordsout);
        return rt;
    }

    private JSDOGeometry shiftRegularGeometry(JSDOGeometry in, Rectangle2D queryWin) {
        double[] coords = in.getOrdinatesArray();
        if (coords == null) {
            return null;
        }
        boolean isMBRSmall = SRS.isMBRSmall(in);
        int dim = in.getDimensions();
        int[] elems = in.getElemInfo();
        boolean isComplex = elems.length > 3;
        boolean multipleElementsAdded = false;
        int iStart = 0;
        int length = 0;
        CoordList coordArray = new CoordList(coords.length);
        ElemList elemArray = new ElemList(elems.length);
        CoordList tmpCoordArray = new CoordList();
        int subElemStartIndex = 0;
        if (isComplex && elems[3] - elems[0] == 0) {
            elemArray.add(elems[0]);
            elemArray.add(elems[1]);
            elemArray.add(elems[2]);
            subElemStartIndex = 3;
        }
        for (int i = subElemStartIndex; i < elems.length; i += 3) {
            iStart = elems[i] - 1;
            int eType = elems[i + 1];
            int itpr = elems[i + 2];
            length = i + 3 < elems.length ? elems[i + 3] - elems[i] : coords.length - elems[i] + 1;
            tmpCoordArray.clear();
            if (eType % 100 == 1 || isMBRSmall) {
                for (int j = iStart; j < iStart + length; ++j) {
                    tmpCoordArray.add(coords[j]);
                }
            } else if (eType % 100 == 3 && itpr == 3) {
                this.prepareRectangle(tmpCoordArray, dim, coords, iStart);
            } else {
                this.prepareOtherShape(tmpCoordArray, dim, coords, iStart, length);
            }
            int shiftDir = this.computeShiftDirection(tmpCoordArray, dim, queryWin.getMinX(), queryWin.getMaxX());
            if (shiftDir == 1 || shiftDir == 4 || shiftDir == 5) {
                this.addElement(elemArray, coordArray, tmpCoordArray, dim, eType, itpr, 0.0);
            }
            if (shiftDir == 2 || shiftDir == 4) {
                this.addElement(elemArray, coordArray, tmpCoordArray, dim, eType, itpr, -360.0);
            }
            if (shiftDir == 3 || shiftDir == 5) {
                this.addElement(elemArray, coordArray, tmpCoordArray, dim, eType, itpr, 360.0);
            }
            multipleElementsAdded = shiftDir == 4 || shiftDir == 5;
        }
        if (elemArray.size() == 0) {
            return null;
        }
        coordArray.trim();
        double[] coordsout = coordArray.getCoords();
        elemArray.trim();
        int[] elemsout = elemArray.getElems();
        JSDOGeometry rt = this.copyJGeometry(in, elemsout, coordsout);
        return rt;
    }

    private JSDOGeometry copyJGeometry(JSDOGeometry in, int[] elems, double[] coords) {
        int dim = in.getDimensions();
        int gtype = in.getType();
        gtype += dim * 1000;
        if (in.isLRSGeometry()) {
            gtype += in.getLRMDimension() * 100;
        }
        JSDOGeometry rt = new JSDOGeometry(gtype, in.getSRID(), elems, coords);
        return rt;
    }

    private void prepareOtherShape(CoordList tmpCoordArray, int dim, double[] coords, int iStart, int length) {
        boolean split = false;
        boolean[] group = new boolean[length / dim];
        boolean shiftRight = false;
        group[0] = true;
        tmpCoordArray.clear();
        int k = 1;
        int j = iStart + dim;
        while (k < group.length) {
            double dist = Math.abs(coords[j] - coords[j - dim]);
            if (dist > 180.0) {
                boolean bl = group[k] = !group[k - 1];
                if (!split) {
                    shiftRight = !(coords[j] > coords[j - dim]);
                }
                split = true;
            } else {
                group[k] = group[k - 1];
            }
            j = iStart + dim * ++k;
        }
        if (!split) {
            for (int j2 = iStart; j2 < iStart + length; ++j2) {
                tmpCoordArray.add(coords[j2]);
            }
        } else {
            for (k = 0; k < group.length; ++k) {
                double coordx = coords[iStart + k * dim];
                if (group[k] != group[0]) {
                    if (shiftRight) {
                        tmpCoordArray.add(coordx + 360.0);
                    } else {
                        tmpCoordArray.add(coordx - 360.0);
                    }
                } else {
                    tmpCoordArray.add(coordx);
                }
                for (j = 1; j < dim; ++j) {
                    tmpCoordArray.add(coords[iStart + k * dim + j]);
                }
            }
        }
    }

    private static boolean isMBRSmall(JGeometry in) {
        double[] mbr = in.getMBR();
        if (mbr == null) {
            return true;
        }
        return mbr[mbr.length / 2] - mbr[0] < 180.0;
    }

    private static boolean isMBRInWindow(JGeometry in, Rectangle2D queryWin) {
        double ymax;
        double ymin;
        double xmax;
        double xmin = queryWin.getMinX();
        if (Util.isFullExtent(xmin, xmax = queryWin.getMaxX(), ymin = queryWin.getMinY(), ymax = queryWin.getMaxY())) {
            return true;
        }
        double[] mbr = in.getMBR();
        if (mbr == null) {
            return true;
        }
        return mbr[0] >= xmin && mbr[mbr.length / 2] <= xmax;
    }

    private void prepareRectangle(CoordList tmpCoordArray, int dim, double[] coords, int iStart) {
        int i;
        double x2 = coords[iStart + dim];
        double x1 = coords[iStart];
        if (x2 < x1) {
            x2 += 360.0;
        }
        tmpCoordArray.add(x1);
        for (i = 1; i < dim; ++i) {
            tmpCoordArray.add(coords[iStart + i]);
        }
        tmpCoordArray.add(x2);
        for (i = 1; i < dim; ++i) {
            tmpCoordArray.add(coords[iStart + dim + i]);
        }
    }

    private void addElement(ElemList elemArray, CoordList coordArray, CoordList tmpCoordArray, int dim, int elemType, int interpretation, double shift) {
        elemArray.add(coordArray.size() + 1);
        elemArray.add(elemType);
        elemArray.add(interpretation);
        for (int j = 0; j < tmpCoordArray.size(); j += dim) {
            double coordx = tmpCoordArray.get(j);
            coordArray.add(coordx + shift);
            for (int k = 1; k < dim; ++k) {
                coordArray.add(tmpCoordArray.get(j + k));
            }
        }
    }

    private int computeShiftDirection(CoordList coordArray, int dim, double qmin, double qmax) {
        double xmax;
        if (coordArray.size() < 1) {
            return 0;
        }
        if (Math.abs(qmax - qmin) > 360.0) {
            return 1;
        }
        boolean left = false;
        boolean right = false;
        boolean noshift = true;
        double xmin = xmax = coordArray.get(0);
        for (int i = dim; i < coordArray.size(); i += dim) {
            double x = coordArray.get(i);
            if (x < xmin) {
                xmin = x;
            }
            if (!(x > xmax)) continue;
            xmax = x;
        }
        noshift = !(xmin > qmax) && !(xmax < qmin);
        left = !(xmin - 360.0 > qmax) && !(xmax - 360.0 < qmin);
        boolean bl = right = !(xmin + 360.0 > qmax) && !(xmax + 360.0 < qmin);
        if (!(noshift || left || right)) {
            return 0;
        }
        if (noshift && !left && !right) {
            return 1;
        }
        if (!noshift && left && !right) {
            return 2;
        }
        if (!noshift && !left && right) {
            return 3;
        }
        if (noshift && left && !right) {
            return 4;
        }
        if (noshift && !left && right) {
            return 5;
        }
        return 1;
    }

    private static double shiftPoint(double coord, double min, double max) {
        double x;
        for (x = coord; x < min; x += 360.0) {
        }
        while (x > max) {
            x -= 360.0;
        }
        if (x >= min && x <= max) {
            return x;
        }
        return coord;
    }

    public static final JSDOGeometry proj(JSDOGeometry in, Proj prj, int srid) {
        double[] coords = in.getOrdinatesArray();
        Proj.P2 p = new Proj.P2();
        if (coords != null) {
            double[] out = new double[coords.length];
            int dim = in.getDimensions();
            for (int i = 0; i < coords.length; i += dim) {
                double lon = coords[i];
                double lat = coords[i + 1];
                boolean res = prj.forward(lon, lat, p);
                out[i] = p.x;
                out[i + 1] = p.y;
            }
            return new JSDOGeometry(in.getType(), srid, in.getElemInfo(), out);
        }
        coords = in.getPoint();
        if (coords == null) {
            log.severe("Invalid input geometry in proj().");
            return null;
        }
        prj.forward(coords[0], coords[1], p);
        if (coords.length > 2 && !Double.isNaN(coords[2])) {
            return new JSDOGeometry(p.x, p.y, coords[2], srid);
        }
        return new JSDOGeometry(p.x, p.y, srid);
    }

    public static double getDPI() {
        return SRSConstants.getDPI();
    }

    public static Double getDistanceConversionFactor(String unitStr) {
        if (unitStr == null) {
            return null;
        }
        unitStr = unitStr.toUpperCase();
        return (Double)distUnitList.get(unitStr);
    }

    public static Hashtable getDistanceUnitList() {
        return distUnitList;
    }

    public static Hashtable getAngularUnitList() {
        return angularUnitList;
    }

    public static boolean getSRSBounds(int srid, double[] bounds) {
        boolean b = false;
        switch (srid) {
            case 54004: {
                bounds[0] = -2.00375083E7;
                bounds[1] = -7.42569498E7;
                bounds[2] = 2.00375083E7;
                bounds[3] = 7.42569498E7;
                b = true;
                break;
            }
            case 3857: {
                bounds[0] = -2.00375083E7;
                bounds[1] = -7.42997432E7;
                bounds[2] = 2.00375083E7;
                bounds[3] = 7.42997432E7;
                b = true;
                break;
            }
            case 3785: {
                bounds[0] = -2.00375083E7;
                bounds[1] = -7.42997432E7;
                bounds[2] = 2.00375083E7;
                bounds[3] = 7.42997432E7;
                b = true;
                break;
            }
            case 8307: {
                bounds[0] = -180.0;
                bounds[1] = -90.0;
                bounds[2] = 180.0;
                bounds[3] = 90.0;
                b = true;
            }
        }
        return b;
    }

    public static boolean isWrapAroundSupported(int srid) {
        boolean b = false;
        switch (srid) {
            case 3785: 
            case 3857: 
            case 8307: 
            case 54004: {
                b = true;
            }
        }
        return b;
    }

    public static boolean splitQueryMBR(double[] inmbr, double[] inmbrValid1, double[] inmbrValid2, int masterSRID) {
        double[] bounds = new double[4];
        double srsMinX = inmbr[0];
        double srsMaxX = inmbr[2];
        if (!SRS.isWrapAroundSupported(masterSRID)) {
            inmbrValid1[0] = inmbr[0];
            inmbrValid1[2] = inmbr[2];
            inmbrValid1[1] = inmbr[1];
            inmbrValid1[3] = inmbr[3];
            return false;
        }
        SRS.getSRSBounds(masterSRID, bounds);
        boolean fullextent = MapMaker.isSpecial(inmbr[0], inmbr[1], inmbr[2], inmbr[3]);
        if (fullextent) {
            inmbrValid1[0] = Double.NEGATIVE_INFINITY;
            inmbrValid1[2] = Double.POSITIVE_INFINITY;
            inmbrValid1[1] = Double.NEGATIVE_INFINITY;
            inmbrValid1[3] = Double.POSITIVE_INFINITY;
            return false;
        }
        srsMinX = bounds[0];
        srsMaxX = bounds[2];
        if (inmbr[0] >= srsMinX && inmbr[2] <= srsMaxX) {
            for (int k = 0; k < 4; ++k) {
                inmbrValid1[k] = inmbr[k];
            }
            return false;
        }
        if (inmbr[0] <= srsMinX && inmbr[2] >= srsMaxX) {
            inmbrValid1[0] = srsMinX;
            inmbrValid1[2] = srsMaxX;
            inmbrValid1[1] = inmbr[1];
            inmbrValid1[3] = inmbr[3];
            return false;
        }
        if (inmbr[0] < srsMinX) {
            double width1 = inmbr[2] - srsMinX;
            double extraWidth = srsMinX - inmbr[0];
            if (width1 + extraWidth >= srsMaxX - srsMinX) {
                inmbrValid1[0] = srsMinX;
                inmbrValid1[2] = srsMaxX;
                inmbrValid1[1] = inmbr[1];
                inmbrValid1[3] = inmbr[3];
                return false;
            }
            inmbrValid1[0] = srsMinX;
            inmbrValid1[2] = inmbr[2];
            inmbrValid1[1] = inmbr[1];
            inmbrValid1[3] = inmbr[3];
            inmbrValid2[0] = srsMaxX - extraWidth;
            inmbrValid2[2] = srsMaxX;
            inmbrValid2[1] = inmbr[1];
            inmbrValid2[3] = inmbr[3];
            return true;
        }
        if (inmbr[2] > srsMaxX) {
            double width1 = srsMaxX - inmbr[0];
            double extraWidth = inmbr[2] - srsMaxX;
            if (width1 + extraWidth >= srsMaxX - srsMinX) {
                inmbrValid1[0] = srsMinX;
                inmbrValid1[2] = srsMaxX;
                inmbrValid1[1] = inmbr[1];
                inmbrValid1[3] = inmbr[3];
                return false;
            }
            inmbrValid1[0] = inmbr[0];
            inmbrValid1[2] = srsMaxX;
            inmbrValid1[1] = inmbr[1];
            inmbrValid1[3] = inmbr[3];
            inmbrValid2[0] = srsMinX;
            inmbrValid2[2] = srsMinX + extraWidth;
            inmbrValid2[1] = inmbr[1];
            inmbrValid2[3] = inmbr[3];
            return true;
        }
        return false;
    }

    static {
        distUnitList.put("CENTIMETER", new Double(0.01));
        distUnitList.put("CHAIN", new Double(20.1168));
        distUnitList.put("CHN_BEN", new Double(20.1167825));
        distUnitList.put("CHN_SRS", new Double(20.1167651));
        distUnitList.put("CL_FT", new Double(0.304797265));
        distUnitList.put("CM", new Double(0.01));
        distUnitList.put("FATHOM", new Double(1.8288));
        distUnitList.put("FOOT", new Double(0.3048));
        distUnitList.put("U.S. FOOT", new Double(0.3048));
        distUnitList.put("INCH", new Double(0.0254));
        distUnitList.put("IND_FT", new Double(0.304799518));
        distUnitList.put("IND_YARD", new Double(0.914398554));
        distUnitList.put("KILOMETER", new Double(1000.0));
        distUnitList.put("KM", new Double(1000.0));
        distUnitList.put("LINK", new Double(0.201166195));
        distUnitList.put("LINK_BEN", new Double(0.201167651));
        distUnitList.put("LINK_SRS", new Double(0.201167651));
        distUnitList.put("M", new Double(1.0));
        distUnitList.put("METER", new Double(1.0));
        distUnitList.put("METRE", new Double(1.0));
        distUnitList.put("MILE", new Double(1609.344));
        distUnitList.put("MILLIMETER", new Double(0.001));
        distUnitList.put("MM", new Double(0.001));
        distUnitList.put("MOD_USFT", new Double(0.304812253));
        distUnitList.put("NAUT_MILE", new Double(1852.0));
        distUnitList.put("ROD", new Double(5.0292));
        distUnitList.put("SRS_YARD", new Double(0.914398415));
        distUnitList.put("SURVEY_FOOT", new Double(0.3048006));
        distUnitList.put("YARD", new Double(0.9144));
        angularUnitList.put("DECIMAL DEGREE", new Double(Math.PI / 180));
        angularUnitList.put("RADIAN", new Double(1.0));
        angularUnitList.put("DECIMAL MINUTE", new Double(2.908882086657216E-4));
        angularUnitList.put("DECIMAL SECOND", new Double(4.84813681109536E-6));
        angularUnitList.put("GON", new Double(0.015707963267948967));
        angularUnitList.put("GRAD", new Double(0.015707963267948967));
    }
}

