/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.sdovis.cache.MVHashMap;

class MVLinkedHashMap
extends MVHashMap {
    private transient Entry header;
    private final boolean accessOrder;

    public MVLinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public MVLinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public MVLinkedHashMap() {
        this.accessOrder = false;
    }

    public MVLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null, 0));
    }

    @Override
    void transfer(MVHashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = MVLinkedHashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return e.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    @Override
    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    void addEntry(int hash, Object key, Object value, int bucketIndex, int esize) {
        this.createEntry(hash, key, value, bucketIndex, esize);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int hash, Object key, Object value, int bucketIndex, int esize) {
        Entry e = new Entry(hash, key, value, this.table[bucketIndex], esize);
        this.table[bucketIndex] = e;
        e.addBefore(this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((MVLinkedHashMap)MVLinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = MVLinkedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != MVLinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (MVLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            MVLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = MVLinkedHashMap.this.modCount;
        }

        Entry nextEntry() {
            if (MVLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == MVLinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.nextEntry;
            this.nextEntry = e.after;
            return e;
        }
    }

    public static class Entry
    extends MVHashMap.Entry {
        Entry before;
        Entry after;

        Entry(int hash, Object key, Object value, MVHashMap.Entry next, int esize) {
            super(hash, key, value, next, esize);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(MVHashMap m) {
            MVLinkedHashMap lm = (MVLinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        @Override
        void recordRemoval(MVHashMap m) {
            this.remove();
        }
    }
}

