/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.session.layer;

import java.util.Hashtable;
import oracle.mapviewer.share.SpatialTableMetadata;
import org.w3c.dom.Node;

public abstract class EditSessionLayer {
    public static String GEOMETRY_TYPE = SpatialTableMetadata.GEOMETRY_TYPE;
    public static String ANNOTATION_TYPE = SpatialTableMetadata.ANNOTATION_TYPE;
    public static String GEORASTER_TYPE = SpatialTableMetadata.GEORASTER_TYPE;
    public static String TOPOFEATURE_TYPE = SpatialTableMetadata.TOPOFEATURE_TYPE;
    public static String NETWORKMODEL_TYPE = "network";
    public static String TOPOMODEL_TYPE = "topology";
    public static String TILECACHE_TYPE = "tilecache";
    public static String BASEMAP_TYPE = "basemap";
    public static String PREDEFINEDTHEME_TYPE = "predefined";
    protected String name = null;
    protected boolean isEditable = false;
    protected boolean isVisible = true;
    protected boolean sharedBoundary = false;
    protected String baseTable = null;
    protected String spatialColumn = null;
    protected String keyColumn = null;
    protected String tilecacheName = null;
    protected Hashtable<String, String> paramValues = new Hashtable();
    protected double liveScale = Double.NaN;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean edit) {
        this.isEditable = edit;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean show) {
        this.isVisible = show;
    }

    public boolean isPredefinedTheme() {
        String type = this.getSpatialType();
        return type != null && type.equalsIgnoreCase(PREDEFINEDTHEME_TYPE);
    }

    public boolean isSharedBoundary() {
        return this.sharedBoundary;
    }

    public void setSharedBoundary(boolean shared) {
        this.sharedBoundary = shared;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String table) {
        this.baseTable = table;
    }

    public String getSpatialColumn() {
        return this.spatialColumn;
    }

    public void setSpatialColumn(String sptColumn) {
        this.spatialColumn = sptColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String key) {
        this.keyColumn = key;
    }

    public void setTileCache(String tile) {
        this.tilecacheName = tile;
    }

    public String getTileCache() {
        return this.tilecacheName;
    }

    public String getParameterValue(String keyAttr) {
        if (keyAttr == null) {
            return null;
        }
        return this.paramValues.get(keyAttr);
    }

    public Hashtable<String, String> getParameterValues() {
        return this.paramValues;
    }

    public void addParameterValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.paramValues.put(key, value);
    }

    public void removeParameter(String key) {
        if (key == null) {
            return;
        }
        this.paramValues.remove(key);
    }

    public double getLiveScale() {
        return this.liveScale;
    }

    public void setLiveScale(double scale) {
        this.liveScale = Double.isNaN(scale) || scale <= 0.0 ? Double.NaN : scale;
    }

    public abstract String getSpatialType();

    public abstract boolean allowDataLoad();

    public abstract Object parseElement(Node var1) throws Exception;

    public abstract boolean allowGetConflicts();

    public abstract String object2String(Object var1) throws Exception;

    public abstract boolean isMyObjectType(Object var1);

    public abstract Object loadFromDB(Object var1) throws Exception;
}

