/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.ColorSchemeStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ColorSchemeStyle
extends BucketStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public ColorSchemeStyle() {
        this.bean = new ColorSchemeStyleModel();
    }

    public ColorSchemeStyle(StyleModel model) {
        this.setModel(model);
    }

    public ColorSchemeStyle(Document doc) throws StyleException {
        this.bean = new ColorSchemeStyleModel();
        try {
            String stkwd;
            Color bc;
            int op;
            String opac;
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            Node elemCS = XMLDOMParser.getSubElement(elem, "ColorSchemeStyle");
            elem = XMLDOMParser.getSubElement(elemCS, "Buckets");
            BucketStyle.fetchBuckets(elem, this.bean.getBucketSeries());
            Color baseColor = StyleUtils.getColor(XMLDOMParser.getAttribute(elemCS, "basecolor"));
            if (baseColor != null) {
                ((ColorSchemeStyleModel)this.bean).setBaseColor(baseColor);
            }
            if (XMLDOMParser.getAttribute(elemCS, "strokecolor").length() > 0) {
                ((ColorSchemeStyleModel)this.bean).setStrokeColor(StyleUtils.getColor(XMLDOMParser.getAttribute(elemCS, "strokecolor")));
            }
            if ((opac = XMLDOMParser.getAttribute(elemCS, "basecolor_opacity")) != null && opac.trim().length() > 0) {
                try {
                    op = Integer.parseInt(opac.trim());
                    if (op >= 0 && op <= 255 && (bc = ((ColorSchemeStyleModel)this.bean).getBaseColor()) != null) {
                        ((ColorSchemeStyleModel)this.bean).setBaseColor(new Color(bc.getRed(), bc.getGreen(), bc.getBlue(), op));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if ((opac = XMLDOMParser.getAttribute(elemCS, "strokecolor_opacity")) != null && opac.trim().length() > 0) {
                try {
                    op = Integer.parseInt(opac.trim());
                    if (op >= 0 && op <= 255 && (bc = ((ColorSchemeStyleModel)this.bean).getStrokeColor()) != null) {
                        ((ColorSchemeStyleModel)this.bean).setStrokeColor(new Color(bc.getRed(), bc.getGreen(), bc.getBlue(), op));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if ((stkwd = XMLDOMParser.getAttribute(elemCS, "strokewidth")) != null && stkwd.trim().length() > 0) {
                try {
                    Color bc2;
                    float op2 = Float.parseFloat(stkwd.trim());
                    if (op2 < 1.0f) {
                        op2 = 1.0f;
                    }
                    if ((bc2 = ((ColorSchemeStyleModel)this.bean).getStrokeColor()) != null) {
                        ((ColorSchemeStyleModel)this.bean).setStrokeWidth(op2);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.reset();
        }
        catch (Exception e) {
            throw new StyleException("Invalid ColorScheme style definition.");
        }
    }

    public ColorSchemeStyle(BucketSeries bkts, Color baseColor, Color strokeColor) {
        this.bean = new ColorSchemeStyleModel(bkts);
        ((ColorSchemeStyleModel)this.bean).setBaseColor(baseColor);
        ((ColorSchemeStyleModel)this.bean).setStrokeColor(strokeColor);
        this.reset();
    }

    public ColorSchemeStyle(BucketSeries bkts, Color baseColor, Color strokeColor, float strokeWidth) {
        this.bean = new ColorSchemeStyleModel(bkts);
        ((ColorSchemeStyleModel)this.bean).setBaseColor(baseColor);
        ((ColorSchemeStyleModel)this.bean).setStrokeColor(strokeColor);
        ((ColorSchemeStyleModel)this.bean).setStrokeWidth(strokeWidth);
        this.reset();
    }

    @Override
    public Object clone() {
        ColorSchemeStyle sty = (ColorSchemeStyle)super.clone();
        sty.setModel((StyleModel)this.bean.clone());
        return sty;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public Color getBaseColor() {
        return ((ColorSchemeStyleModel)this.bean).getBaseColor();
    }

    public void setBaseColor(Color c) {
        ((ColorSchemeStyleModel)this.bean).setBaseColor(c);
        this.reset();
    }

    public Color getStrokeColor() {
        return ((ColorSchemeStyleModel)this.bean).getStrokeColor();
    }

    public void setStrokeColor(Color c) {
        ((ColorSchemeStyleModel)this.bean).setStrokeColor(c);
        this.reset();
    }

    public void reset() {
        Color baseColor = ((ColorSchemeStyleModel)this.bean).getBaseColor();
        Color strokeColor = ((ColorSchemeStyleModel)this.bean).getStrokeColor();
        float strokeWidth = ((ColorSchemeStyleModel)this.bean).getStrokeWidth();
        int r = baseColor.getRed();
        int g = baseColor.getGreen();
        int b = baseColor.getBlue();
        int alpha = baseColor.getAlpha();
        float[] hsb = new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        BucketSeries buckets = this.bean.getBucketSeries();
        int nBuckets = buckets.size();
        float incr = 1.0f / (float)nBuckets;
        for (int i = 0; i < nBuckets; ++i) {
            Bucket sb = buckets.getBucket(i);
            if (sb.getRenderStyle() != null || sb.getRenderStyleName() != null) {
                log.finest("using user specified style.");
                continue;
            }
            float brightness = hsb[2] - hsb[2] * (incr * (float)i);
            Color hsbtorgb = new Color(Color.HSBtoRGB(hsb[0], hsb[1], brightness));
            Color c = new Color(hsbtorgb.getRed(), hsbtorgb.getGreen(), hsbtorgb.getBlue(), alpha);
            StyleColor stycolor = new StyleColor(c, strokeColor);
            if (strokeColor != null) {
                stycolor.setStrokeWidth(strokeWidth);
            }
            sb.setRenderStyle(stycolor);
        }
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        return super.getMaxLegendWidth(g, fontSize);
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        super.refreshResolvedStyles(sc, dynaStyles);
        BucketSeries buckets = this.bean.getBucketSeries();
        if (buckets != null) {
            int nBuckets = buckets.size();
            for (int i = 0; i < nBuckets; ++i) {
                Bucket sb = buckets.getBucket(i);
                sb.setRenderStyleName(null);
            }
        }
        this.reset();
        return true;
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        if (this.bean == null) {
            return true;
        }
        String defaultStyleName = this.bean.getBucketSeries().getDefaultRenderStyleName();
        Style defaultStyle = (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        if (defaultStyleName != null && defaultStyle == null) {
            defaultStyle = Util.getStyle(defaultStyleName, sc, dynaStyles);
            this.bean.getBucketSeries().setDefaultRenderStyle(defaultStyle);
        }
        if (defaultStyle != null && !(defaultStyle instanceof AdvancedStyle)) {
            defaultStyle.resolveStyles(sc, dynaStyles);
        }
        return true;
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof ColorSchemeStyleModel)) {
            throw new IllegalArgumentException("Not a ColorSchemeStyleModel instance.");
        }
        this.bean = (ColorSchemeStyleModel)model;
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply ColorSchemeStyle to a point.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        BucketSeries buckets = this.bean.getBucketSeries();
        int nBuckets = buckets.size();
        double incr = (rect.getHeight() - 4.0) / (double)nBuckets;
        Rectangle2D.Float sr = new Rectangle2D.Float();
        for (int i = 0; i < nBuckets; ++i) {
            Bucket bucket = buckets.getBucket(i);
            double y = rect.getMinY() + incr * (double)i;
            ((Rectangle2D)sr).setRect(rect.getMinX(), y, rect.getWidth(), incr);
            this.drawBucketWithLabel(g, bucket, sr, 0.2f, 0.8f, null);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("ColorSchemeStyle not applicable without an attr value.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        Style sty = this.chooseStyle(values[0]);
        if (sty != null) {
            sty.apply(null, g, shp, gtype, label, labelPoint, cr, values, null);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        super.apply(vc, g, shp, gtype, label, labelPoint, cr, values, styleColumns, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        super.apply(vc, g, shp, gtype, label, labelPoint, cr, values, styleColumns, subStyle, substyleColumns, changeProperty, stymods);
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }
}

