/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Vector;
import oracle.sdovis.stylex.Grid;

class Dot {
    Object[] grids;
    Point2D.Double[] dots;

    public Dot() {
    }

    public Dot(long numofgrids, Area shape, Rectangle2D.Double square) {
        this.dots = new Point2D.Double[(int)numofgrids];
        Vector<Grid> ref = new Vector<Grid>();
        int i = 0;
        while ((long)i < numofgrids) {
            ref.add(new Grid(i, numofgrids, shape, square));
            ++i;
        }
        this.grids = ref.toArray();
        Arrays.sort(this.grids);
    }

    private boolean checkContainment(int index) {
        return ((Grid)this.grids[index]).isContained();
    }

    public Point2D.Double getDot(int index) {
        return this.dots[index];
    }

    public void arrangeDot(int index) {
        if (this.checkContainment(index)) {
            this.placeDot(index);
        } else if (this.dotInside(index)) {
            this.placeDot(index);
        } else {
            Point2D centroid = this.getCentroid(index);
            this.placeDot(index, centroid);
        }
    }

    private void placeDot(int index) {
        Point2D.Double cent;
        double width = ((Grid)this.grids[index]).getWidth();
        this.dots[index] = cent = new Point2D.Double();
        this.dots[index].setLocation(((Grid)this.grids[index]).getX() + width / 2.0, ((Grid)this.grids[index]).getY() + width / 2.0);
        this.randomizeDot(index, width / 4.0);
    }

    private void placeDot(int index, Point2D centroid) {
        Point2D.Double cent;
        this.dots[index] = cent = new Point2D.Double();
        this.dots[index].setLocation(centroid);
        double width = ((Grid)this.grids[index]).getWidth();
        this.randomizeDot(index, width);
    }

    private void randomizeDot(int index, double width) {
        double direction = 0.0;
        double radius = 0.0;
        double[] org = new double[]{this.dots[index].getX(), this.dots[index].getY()};
        int i = 0;
        do {
            direction = Math.PI * Math.random() * 2.0;
            radius = width * Math.random();
            this.dots[index].setLocation(org[0] + radius * Math.cos(direction), org[1] + radius * Math.sin(direction));
        } while (!this.dotInside(index, this.dots[index].getX(), this.dots[index].getY()) && i++ < 10);
    }

    private boolean dotInside(int index) {
        double width = ((Grid)this.grids[index]).getWidth();
        Point2D.Double center = new Point2D.Double(((Grid)this.grids[index]).getX() + width / 2.0, ((Grid)this.grids[index]).getY() + width / 2.0);
        return ((Grid)this.grids[index]).getIntersection().contains(center);
    }

    private boolean dotInside(int index, double xPos, double yPos) {
        Point2D.Double loc = new Point2D.Double();
        loc.setLocation(xPos, yPos);
        return ((Grid)this.grids[index]).getIntersection().contains(loc);
    }

    private Point2D getCentroid(int index) {
        double simplearea = 0.0;
        double simplecentx = 0.0;
        double simplecenty = 0.0;
        double singleton = 0.0;
        Area polygon = ((Grid)this.grids[index]).getIntersection();
        double[] coords = new double[6];
        double[] oldcoords = new double[2];
        double[] startcoords = new double[2];
        PathIterator itor = polygon.getPathIterator(null);
        while (!itor.isDone()) {
            int type = itor.currentSegment(coords);
            switch (type) {
                case 0: {
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    startcoords[0] = coords[0];
                    startcoords[1] = coords[1];
                    break;
                }
                case 4: {
                    singleton = oldcoords[0] * startcoords[1] - oldcoords[1] * startcoords[0];
                    simplearea += singleton;
                    simplecentx += (oldcoords[0] + startcoords[0]) * singleton;
                    simplecenty += (oldcoords[1] + startcoords[1]) * singleton;
                    break;
                }
                case 1: {
                    singleton = oldcoords[0] * coords[1] - oldcoords[1] * coords[0];
                    simplearea += singleton;
                    simplecentx += (oldcoords[0] + coords[0]) * singleton;
                    simplecenty += (oldcoords[1] + coords[1]) * singleton;
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            itor.next();
        }
        double xPos = simplecentx / ((simplearea /= 2.0) * 6.0);
        double yPos = simplecenty / (simplearea * 6.0);
        return new Point2D.Double(xPos, yPos);
    }

    private double Area2(Point2D a, Point2D b, Point2D c) {
        return (b.getX() - a.getX()) * (c.getY() - a.getY()) - (c.getX() - a.getX()) * (b.getY() - a.getY());
    }

    private void Centroid3(Point2D a, Point2D b, Point2D c, Point2D centroid) {
        double xPos = a.getX() + b.getX() + c.getX();
        double yPos = a.getY() + b.getY() + c.getY();
        centroid.setLocation(xPos, yPos);
    }

    private double getAreaSize(Area area, AffineTransform at) {
        double size = 0.0;
        double size2 = 0.0;
        double[] coords = new double[6];
        double[] oldcoords = new double[2];
        PathIterator itor = area.getPathIterator(at);
        while (!itor.isDone()) {
            int type = itor.currentSegment(coords);
            switch (type) {
                case 0: {
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    size += (oldcoords[0] + coords[0]) * (coords[1] - oldcoords[1]);
                    size2 += oldcoords[0] * coords[1] - oldcoords[1] * coords[0];
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            itor.next();
        }
        size2 /= 2.0;
        return size > 0.0 ? size : -1.0 * (size /= 2.0);
    }
}

