/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.stylex.DotDensityStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.DotDensityStyleModifiers;
import oracle.sdovis.stylex.DotDistributor;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DotDensityStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private DotDensityStyleModel bean;
    transient StyleMarker markerStyle = null;

    public DotDensityStyle() {
        this.bean = new DotDensityStyleModel();
    }

    public DotDensityStyle(StyleModel model) {
        this.setModel(model);
    }

    public DotDensityStyle(int dotWidth, int dotHeight, String markerStyleName) {
        this.bean = new DotDensityStyleModel();
        this.bean.setDotWidth(dotWidth);
        this.bean.setDotHeight(dotHeight);
        this.bean.setMarkerStyleName(markerStyleName);
    }

    public DotDensityStyle(Document doc) throws StyleException {
        this.bean = new DotDensityStyleModel();
        try {
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            Node elemVMS = XMLDOMParser.getSubElement(elem, "DotDensityStyle");
            String bwidth = XMLDOMParser.getAttribute(elemVMS, "DotWidth");
            String bheight = XMLDOMParser.getAttribute(elemVMS, "DotHeight");
            SizeDefinition2D dotsize = SizeDefinition2D.parse(bwidth, bheight);
            if (dotsize == null) {
                throw new StyleException("Invalid dot size in DotDensityStyle definition.");
            }
            this.bean.setDotWidth(dotsize.getWidth());
            this.bean.setDotHeight(dotsize.getHeight());
            this.bean.setDotUnit(dotsize.getUnit());
            this.bean.setMarkerStyleName(XMLDOMParser.getAttribute(elemVMS, "MarkerStyle"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new StyleException("Invalid DotDensity style definition.");
        }
    }

    public Object clone() {
        try {
            DotDensityStyle sty = (DotDensityStyle)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    void applyToShape(Graphics2D g, Shape shp, Field[] values, StyleModifiers stymods) {
        double cnt = values[0].getDouble();
        int pointnumber = (int)cnt;
        if (pointnumber <= 0) {
            return;
        }
        DotDensityStyle dotDensityStyle = this;
        if (pointnumber > dotDensityStyle.bean.getMaxDots()) {
            log.warning("count value is too big for Dot-Density style.");
            DotDensityStyle dotDensityStyle2 = this;
            log.warning("changing count to maxium allowed number (" + dotDensityStyle2.bean.getMaxDots() + ").");
            DotDensityStyle dotDensityStyle3 = this;
            pointnumber = dotDensityStyle3.bean.getMaxDots() - 1;
        }
        DotDistributor dotDistributor = new DotDistributor(shp, pointnumber);
        dotDistributor.checkDots();
        JSDOGeometry dots = dotDistributor.getDots();
        this.drawMarkers(g, dots, stymods);
    }

    public void drawMarkers(Graphics2D g, JSDOGeometry dots, StyleModifiers stymods) {
        if (dots == null) {
            return;
        }
        double[] coords = dots.getOrdinatesArray();
        if (coords == null) {
            return;
        }
        int w = this.bean.getDotWidth();
        int h = this.bean.getDotHeight();
        if (stymods != null && stymods instanceof DotDensityStyleModifiers) {
            w = ((DotDensityStyleModifiers)stymods).getDotWidth();
            h = ((DotDensityStyleModifiers)stymods).getDotHeight();
        }
        if (this.markerStyle != null) {
            double oldW = this.markerStyle.getDoubleDesiredWidth();
            double oldH = this.markerStyle.getDoubleDesiredHeight();
            this.markerStyle.setDesiredWidth(w);
            this.markerStyle.setDesiredHeight(h);
            Rectangle2D.Float sr = new Rectangle2D.Float();
            for (int i = 0; i < coords.length; i += 2) {
                ((Rectangle2D)sr).setRect(coords[i] - (double)(w / 2), coords[i + 1] - (double)(h / 2), w, h);
                try {
                    this.markerStyle.apply(null, g, sr, null);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            this.markerStyle.setDesiredWidth(oldW);
            this.markerStyle.setDesiredHeight(oldH);
        } else {
            g.setColor(Color.black.brighter());
            for (int i = 0; i < coords.length; i += 2) {
                g.fillOval((int)(coords[i] - (double)(w / 2)), (int)(coords[i + 1] - (double)(h / 2)), w, h);
            }
        }
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        return 0;
    }

    public void resetMarkerStyleObject() {
        this.markerStyle = null;
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        String markerStyleName = this.bean.getMarkerStyleName();
        if (markerStyleName == null || this.markerStyle != null) {
            return true;
        }
        this.markerStyle = (StyleMarker)Util.getStyle(markerStyleName, sc, dynaStyles);
        return this.markerStyle != null;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        this.markerStyle = null;
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof DotDensityStyleModel)) {
            throw new IllegalArgumentException("Not a DotDensityStyleModel instance.");
        }
        this.bean = (DotDensityStyleModel)model;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("DotDensityStyle not applicable to points.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        this.applyToShape(g, rect, new Field[]{Field.createField("13", "double")}, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("cannot apply DotDensityStyle without attributes.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        if (gtype != 3 && gtype != 7) {
            log.warning("Cannot apply dot density style to non-polygon features.");
            return;
        }
        this.applyToShape(g, shp, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        Field[] realValues = this.pickValues(values, styleColumns);
        if (realValues != null) {
            values = realValues;
        }
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        Field[] realValues = this.pickValues(values, styleColumns);
        if (realValues != null) {
            values = realValues;
        }
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    private Field[] pickValues(Field[] values, String[] styleColumns) {
        if (values != null && styleColumns != null) {
            Field f = null;
            String valueCol = styleColumns[0];
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getName().equalsIgnoreCase(valueCol)) continue;
                f = values[i];
                break;
            }
            if (f != null) {
                values = new Field[]{f};
                return values;
            }
            return null;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.bean.getDotSize().isPixelUnit()) {
            return null;
        }
        DotDensityStyleModifiers dotmods = new DotDensityStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            if (this.bean.getDotSize().isPixelUnit()) {
                dotmods.setDotWidth(this.bean.getDotWidth());
                dotmods.setDotHeight(this.bean.getDotHeight());
            }
        } else {
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            double pixelY = queW.getHeight() / devW.getHeight();
            double pixel = Math.max(pixelX, pixelY);
            Double convFactor = null;
            if (this.bean.getDotUnit() != null) {
                convFactor = SRS.getDistanceConversionFactor(this.bean.getDotUnit());
            }
            if (this.bean.getDotSize().isPixelUnit()) {
                dotmods.setDotWidth(this.bean.getDotWidth());
                dotmods.setDotHeight(this.bean.getDotHeight());
            } else if (convFactor != null) {
                double dotw = this.bean.getDoubleDotWidth() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, dotw);
                    dotmods.setDotWidth((int)(dgw / pixel + 0.5));
                } else {
                    dotmods.setDotWidth((int)(dotw / pixel + 0.5));
                }
                double doth = this.bean.getDoubleDotHeight() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, doth);
                    dotmods.setDotHeight((int)(dgw / pixel + 0.5));
                } else {
                    dotmods.setDotHeight((int)(doth / pixel + 0.5));
                }
            }
        }
        return dotmods;
    }
}

