/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.HeatMapStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.HeatMapStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HeatMapStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    HeatMapStyleModel bean;

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        return 250;
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        this.bean = (HeatMapStyleModel)model;
    }

    public HeatMapStyle(StyleModel model) {
        this.setModel(model);
    }

    public HeatMapStyle(Document doc) throws StyleException {
        this.bean = new HeatMapStyleModel();
        try {
            int iv;
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            elem = XMLDOMParser.getSubElement(elem, "HeatMapStyle");
            Node csElem = XMLDOMParser.getSubElement(elem, "color_stops");
            String v = XMLDOMParser.getAttribute(csElem, "num_steps");
            try {
                iv = Integer.parseInt(v);
                this.bean.setNumSteps(iv);
            }
            catch (Exception ex) {
                // empty catch block
            }
            v = XMLDOMParser.getAttribute(csElem, "alpha");
            try {
                iv = Integer.parseInt(v);
                this.bean.setAlpha(iv);
            }
            catch (Exception ex) {
                // empty catch block
            }
            v = XMLDOMParser.getElementValue(csElem);
            Color[] cstops = HeatMapStyleModel.stringToColorStops(v);
            if (cstops.length < 2) {
                log.severe("Must have at least two color stops.");
                throw new IllegalArgumentException("Invalid number of color stops.");
            }
            for (int i = 0; i < cstops.length; ++i) {
                if (cstops[i] != null) continue;
                throw new IllegalArgumentException("Invalid color in color stops.");
            }
            this.bean.setColorStops(cstops);
            Node node = XMLDOMParser.getSubElement(elem, "spot_light_radius");
            v = XMLDOMParser.getElementValue(node);
            SizeDefinition slrsize = SizeDefinition.parse(v);
            if (slrsize == null) {
                throw new StyleException("Invalid spot light radius size in HeatMapStyle definition.");
            }
            this.bean.setSpotLightRadiusSize(slrsize);
            node = XMLDOMParser.getSubElement(elem, "grid_sample_factor");
            v = XMLDOMParser.getElementValue(node);
            try {
                double dv = Double.parseDouble(v);
                this.bean.setGridSampleFactor(dv);
            }
            catch (Exception ex) {
                // empty catch block
            }
            node = XMLDOMParser.getSubElement(elem, "container_theme");
            v = XMLDOMParser.getElementValue(node);
            this.bean.setContainerThemeName(v);
            node = XMLDOMParser.getSubElement(elem, "method");
            if (node != null) {
                v = XMLDOMParser.getElementValue(node);
                if (HeatMapStyleModel.getMethodName(2).equals(v)) {
                    this.bean.setMethod(2);
                } else if (HeatMapStyleModel.getMethodName(3).equals(v)) {
                    this.bean.setMethod(3);
                } else if (HeatMapStyleModel.getMethodName(1).equals(v)) {
                    this.bean.setMethod(1);
                }
            }
            node = XMLDOMParser.getSubElement(elem, "enforce_global_range");
            this.bean.setGlobalCellValueRangeEnforced(false);
            if (node != null) {
                v = XMLDOMParser.getElementValue(node);
                if ("true".equalsIgnoreCase(v) || "yes".equalsIgnoreCase(v)) {
                    this.bean.setGlobalCellValueRangeEnforced(true);
                }
                if ((node = XMLDOMParser.getSubElement(elem, "max_records_in_raidus")) == null) {
                    throw new IllegalArgumentException("Missing element: max_records_in_raidus");
                }
                v = XMLDOMParser.getElementValue(node);
                this.bean.setMaxPointsInSpotlight(Double.parseDouble(v));
            }
        }
        catch (Exception ex) {
            throw new StyleException("Invalid HeatMapStyle definition.", ex);
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.isPixelUnit(this.bean.getSpotLightRadiusUnit())) {
            return null;
        }
        HeatMapStyleModifiers hmmods = new HeatMapStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            if (this.isPixelUnit(this.bean.getSpotLightRadiusUnit())) {
                hmmods.setSpotLightRadius((int)this.bean.getSpotLightRadius());
            }
        } else {
            double pixelY;
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            double pixel = pixelY = queW.getHeight() / devW.getHeight();
            Double convFactor = null;
            if (this.bean.getSpotLightRadiusUnit() != null) {
                convFactor = SRS.getDistanceConversionFactor(this.bean.getSpotLightRadiusUnit());
            }
            if (this.isPixelUnit(this.bean.getSpotLightRadiusUnit())) {
                hmmods.setSpotLightRadius((int)this.bean.getSpotLightRadius());
            } else if (convFactor != null) {
                double pierd = this.bean.getSpotLightRadius() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, pierd);
                    hmmods.setSpotLightRadius((int)(dgw / pixel + 0.5));
                } else {
                    hmmods.setSpotLightRadius((int)(pierd / pixel + 0.5));
                }
            }
        }
        return hmmods;
    }

    private boolean isPixelUnit(String unit) {
        return unit == null || unit.equalsIgnoreCase("px") || unit.equalsIgnoreCase("pt");
    }

    public Object clone() {
        try {
            HeatMapStyle sty = (HeatMapStyle)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        Color[] colors = null;
        try {
            colors = StyleUtils.createMultiStopGradient(this.bean.getColorStops(), this.bean.getNumSteps(), this.bean.getAlpha());
        }
        catch (Exception ex) {
            throw new StyleNotApplicableException("failed to create gradient", ex);
        }
        int barHeight = (int)rect.getHeight();
        BufferedImage img = new BufferedImage(colors.length, barHeight, 2);
        Graphics2D ig = (Graphics2D)img.getGraphics();
        for (int i = 0; i < colors.length; ++i) {
            ig.setColor(colors[i]);
            ig.fillRect(i, 0, 1, barHeight);
        }
        ig.dispose();
        g.drawImage(img, 0, 0, (int)(rect.getWidth() - 1.0), (int)(rect.getHeight() - 1.0), 0, 0, colors.length - 1, (int)(rect.getHeight() - 1.0), null);
        img.flush();
        img = null;
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
    }
}

