/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import oracle.sdovis.svg.SVGImageTranscoder;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGDomUtil {
    public static Document parseSVGFromReader(Reader svgReader) throws Exception {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        Document doc = f.createDocument(null, svgReader);
        return doc;
    }

    public static Document parseSVGFromString(String svgContents) throws Exception {
        StringReader sreader = new StringReader(svgContents);
        return SVGDomUtil.parseSVGFromReader(sreader);
    }

    public static Document parseSVGFromURL(String svgUrl) throws Exception {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        Document doc = f.createDocument(svgUrl);
        return doc;
    }

    public static double[] getSVGPreferredSize(Document svg) {
        NodeList svgNodes = svg.getElementsByTagName("svg");
        for (int i = 0; i < svgNodes.getLength(); ++i) {
            Node node = svgNodes.item(i);
            if (!"svg".equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap attrs = node.getAttributes();
            String w = null;
            String h = null;
            if (attrs.getNamedItem("width") != null) {
                w = attrs.getNamedItem("width").getNodeValue();
            }
            if (attrs.getNamedItem("height") != null) {
                h = attrs.getNamedItem("height").getNodeValue();
            }
            if (w == null || h == null) continue;
            try {
                int wlastdigit = -1;
                for (int j = 0; j < w.length(); ++j) {
                    if (Character.isDigit(w.charAt(j))) continue;
                    wlastdigit = j - 1;
                    break;
                }
                if (wlastdigit > -1) {
                    w = w.substring(0, wlastdigit + 1);
                }
                int hlastdigit = -1;
                for (int j = 0; j < h.length(); ++j) {
                    if (Character.isDigit(h.charAt(j))) continue;
                    hlastdigit = j - 1;
                    break;
                }
                if (hlastdigit > -1) {
                    h = h.substring(0, hlastdigit + 1);
                }
                double[] dimension = new double[]{Double.parseDouble(w), Double.parseDouble(h)};
                return dimension;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static BufferedImage renderSVGDocument(Document svgDoc, int width, int height) {
        SVGImageTranscoder t = new SVGImageTranscoder();
        t.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(width));
        t.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(height));
        TranscoderInput input = new TranscoderInput(svgDoc);
        try {
            t.transcode(input, null);
        }
        catch (TranscoderException e) {
            return null;
        }
        BufferedImage image = t.getRenderedImage();
        return image;
    }

    public static BufferedImage renderSVGDocument(Document svgDoc, BufferedImage destImage) {
        SVGImageTranscoder t = new SVGImageTranscoder(destImage);
        t.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(destImage.getWidth()));
        t.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(destImage.getHeight()));
        TranscoderInput input = new TranscoderInput(svgDoc);
        try {
            t.transcode(input, null);
        }
        catch (TranscoderException e) {
            e.printStackTrace();
            return null;
        }
        BufferedImage image = t.getRenderedImage();
        return image;
    }

    public static void renderSVGDocument(GraphicsNode rootNode, Graphics2D g2) {
        rootNode.paint(g2);
    }

    public static GraphicsNode getGraphicsRootNode(Document svgDoc) {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        ctx.setDynamicState(2);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode rootGN = builder.build(ctx, svgDoc);
        return rootGN;
    }

    public static void renderSVGDocument(Document svgDoc, Graphics2D g2) {
        GraphicsNode root = SVGDomUtil.getGraphicsRootNode(svgDoc);
        if (root != null) {
            root.paint(g2);
        }
    }
}

