/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.HMPointFeature;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class DynGeomThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent dynGeomSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "DynGeom", "Producer", "Time spent preparing data");
    protected Theme owner;
    private DynGeomThemeDefinition def;
    LocalThemeDataProducer features;
    String dbVersion = null;
    double viewResX = Double.MIN_VALUE;
    double viewResY = Double.MIN_VALUE;
    private Object[] bindingParameters = null;
    private PreparedStatement stmt = null;
    private boolean aborted = false;
    private double[] queryMBR = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private double[] queryMBR2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private long maxFeaturesToBePrepared = -1L;
    private long loadedFeaturesInAdjustedMBR = 0L;
    private static final int YIELD_COUNT = 20;

    private DynGeomThemeProducer() {
    }

    public DynGeomThemeProducer(Theme t) {
        this.owner = t;
        this.def = (DynGeomThemeDefinition)t.getDefinition();
    }

    public DynGeomThemeProducer(Theme t, Object[] bindingParams) {
        this.owner = t;
        this.def = (DynGeomThemeDefinition)t.getDefinition();
        this.bindingParameters = bindingParams;
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(idx);
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(window, name);
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(window);
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    public void setStyledFeatures(ArrayList sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    public Connection getDBConnection(VisContext vc) throws DataException {
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            if (conn == null) {
                vc.processDataError(null, log, "Cannot obtain connection for data source: " + this.def.getDataSourceName() + ". Max connection limit reached?");
                return null;
            }
        }
        catch (Exception ex) {
            vc.processDataError(ex, log, "Exception when obtaining connection for data source: " + this.def.getDataSourceName());
            return null;
        }
        return conn;
    }

    void gotoWorkspace(Connection conn) throws DataException {
        try {
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                    Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                    Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                } else {
                    Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                }
            }
        }
        catch (Exception e) {
            String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
            } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
            }
            log.log(Level.SEVERE, err, e);
            throw new DataException(err);
        }
    }

    private ArrayList loadFeaturesInAdjustedMBR(Rectangle2D queryWin, Connection conn, VisContext vc, boolean isOracleDB) throws DataException {
        ArrayList<StyledFeatureI> styledFeatureList = new ArrayList<StyledFeatureI>(1000);
        ResultSet rs = null;
        int cnt = 0;
        long t1 = System.currentTimeMillis();
        try {
            Rectangle2D qWindow;
            Proj proj = vc.getProjection();
            String query = this.rewriteQuery(conn, queryWin, vc, isOracleDB);
            if (query == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            log.finer("[DynGeomTheme] rewritten query:  " + query);
            this.stmt = conn.prepareStatement(query);
            if (this.bindingParameters != null) {
                for (int i = 0; i < this.bindingParameters.length; ++i) {
                    DynGeomThemeProducer.setBindingVariable(conn, this.stmt, this.bindingParameters[i], i + 1);
                }
            }
            this.stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + this.stmt.getFetchSize());
            long t3 = System.currentTimeMillis();
            rs = this.stmt.executeQuery();
            long t4 = System.currentTimeMillis();
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int keyCol = 0;
            int totalColCount = meta.getColumnCount();
            int xCol = 0;
            int yCol = 0;
            boolean applyRotation = false;
            boolean isAnnoTextLabel = false;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                // empty if block
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                String sqlType;
                String spatialCol = this.def.getSpatialColumn();
                if (spatialCol != null && spatialCol.length() > 0 && !spatialCol.equals("null")) {
                    if (meta.getColumnName(i + 1).equalsIgnoreCase(spatialCol)) {
                        geomCol = i + 1;
                    }
                } else if (!this.isXYjdbc()) {
                    sqlType = meta.getColumnTypeName(i + 1);
                    log.finest("sqlType=" + sqlType);
                    if (sqlType.indexOf("SDO_GEOMETRY") >= 0) {
                        geomCol = i + 1;
                    }
                }
                if (this.def.getLabelColumn() != null && meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) {
                    labelCol = i + 1;
                    sqlType = meta.getColumnTypeName(i + 1);
                    if (sqlType.indexOf("ST_ANNOTATION_TEXT") >= 0) {
                        isAnnoTextLabel = true;
                    }
                }
                if (this.def.getKeyColumn() != null && meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getKeyColumn())) {
                    keyCol = i + 1;
                }
                if (this.def.getPointXColumn() != null && meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getPointXColumn())) {
                    xCol = i + 1;
                }
                if (this.def.getPointYColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getPointYColumn())) continue;
                yCol = i + 1;
            }
            if (geomCol == 0) {
                if (xCol == 0 || yCol == 0) {
                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01029") + " [" + this.getTheme().getName() + "].");
                    ArrayList i = null;
                    return i;
                }
            } else if (this.isXYjdbc() && (xCol == 0 || yCol == 0)) {
                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01049") + " [" + this.getTheme().getName() + "].");
                ArrayList i = null;
                return i;
            }
            if (xCol == 0 || yCol == 0) {
                if (totalColCount > 2 || labelCol == 0 && totalColCount > 1) {
                    hasAttributes = true;
                }
            } else if (geomCol > 0) {
                if (totalColCount > 4 || labelCol == 0 && totalColCount > 3) {
                    hasAttributes = true;
                }
            } else if (totalColCount > 3 || labelCol == 0 && totalColCount > 2) {
                hasAttributes = true;
            }
            AnnotationTextMetadata atextMetadata = null;
            TextAttributesType txtAttributes = null;
            Style defaultLineStyle = StyleFactory.getDefaultStyle(2);
            if (isAnnoTextLabel) {
                atextMetadata = JDBCUtil.getAnnotationTextMetadata(conn, this.def.getLabelAnnoTextTable(), this.def.getLabelColumn());
                if (atextMetadata == null) {
                    vc.processDataError(null, log, "Unable to load annotation text metadata for table [" + this.def.getLabelAnnoTextTable() + "] and column [" + this.def.getLabelColumn() + "].");
                    ArrayList arrayList = null;
                    return arrayList;
                }
                txtAttributes = this.getMetadataTextAttributes(atextMetadata.getTextAtttributes());
                if (!Util.isFullExtent(queryWin.getMinX(), queryWin.getMinY(), queryWin.getMaxX(), queryWin.getMaxY()) && !Double.isNaN(atextMetadata.getMapBaseScale()) && atextMetadata.getMapBaseScale() > 0.0) {
                    double inmeter = atextMetadata.getMapBaseScale() * 0.0254 / vc.getDPI();
                    float fsize = txtAttributes.getTextStyle().getFontSize();
                    SizeDefinition sizeDef = new SizeDefinition(fsize *= (float)inmeter, "m");
                    double pixelSize = Util.convertToPixelSize(sizeDef, vc);
                    if (!Double.isNaN(pixelSize)) {
                        txtAttributes.getTextStyle().setFontSize((float)pixelSize);
                    }
                }
            }
            if (vc.getRotation() != 0.0 && !(vc.getRotation() < -360.0) && !(vc.getRotation() > 360.0)) {
                if (queryWin.getWidth() == Double.POSITIVE_INFINITY || queryWin.getHeight() == Double.POSITIVE_INFINITY) {
                    log.info("Rotation is currently ignored for full extent.");
                } else {
                    log.info("Map rotation: " + vc.getRotation());
                    applyRotation = true;
                }
            }
            log.finer("Retrieving geometries...");
            boolean simpleShapes = this.getTheme().getDecorator().isSimplifiedShapes();
            boolean fastUnpickle = this.getTheme().getDecorator().isFastUnpickle();
            boolean allowNakedPoints = this.getTheme().getDecorator().allowNakedPoints;
            int rsetPosition = -1;
            double xValue = 0.0;
            double yValue = 0.0;
            Rectangle2D rectangle2D = qWindow = vc.isTileRequest() ? queryWin : vc.getQueryWindow();
            while (!this.aborted && rs.next() && (this.maxFeaturesToBePrepared <= 0L || this.loadedFeaturesInAdjustedMBR < this.maxFeaturesToBePrepared)) {
                JSDOGeometry geom = null;
                if (xCol == 0 || yCol == 0) {
                    geom = isOracleDB ? JDBCUtil.loadGeometry(rs, geomCol, fastUnpickle) : JDBCUtil.loadGeometryFromJavaDB(rs, geomCol);
                } else {
                    xValue = rs.getDouble(xCol);
                    yValue = rs.getDouble(yCol);
                    JGeometry geo = new JGeometry(xValue, yValue, this.def.getSrid());
                    if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && isOracleDB) {
                        try {
                            geo = Util.processSRIDConversion(this.owner.getDataSourceName(), geo, vc.getMasterSRID());
                            geom = JSDOGeometry.recast(geo);
                        }
                        catch (Exception e) {
                            geom = null;
                        }
                    } else {
                        geom = JSDOGeometry.recast(geo);
                    }
                }
                if (geom == null) continue;
                if (applyRotation) {
                    double yh;
                    double xl = queryWin.getMinX();
                    double yl = queryWin.getMinY();
                    double xh = queryWin.getMaxX();
                    JGeometry geomRot = Util.rotateGeometry(geom, (xl + xh) / 2.0, (yl + (yh = queryWin.getMaxY())) / 2.0, vc.getRotation());
                    if (geomRot == null || (geom = JSDOGeometry.recast(geomRot)) == null) continue;
                }
                if ((geom = vc.getSrs().shift(geom, qWindow)) == null) continue;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setShapeSimplified(simpleShapes);
                sf.setRenderingRules(this.def.getRenderingRules());
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                sf.setGeometry(geom);
                sf.setDataSource(this.def.getDataSourceName());
                sf.setThemeName(this.def.getName());
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    sf.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    sf.setFeatureStyleName(this.def.getFeatureStyleName());
                }
                if (labelCol > 0) {
                    if (!isAnnoTextLabel) {
                        sf.setLabel(rs.getString(labelCol));
                    } else {
                        AnnotationText atext = JDBCUtil.loadAnnotationText(rs, this.def.getLabelColumn());
                        if (atext != null) {
                            AnnotationTextElement[] elems = atext.getElements();
                            if (elems != null && elems.length > 0) {
                                String previousText = rs.getString(atextMetadata.getTextExpression());
                                if (previousText == null) {
                                    previousText = atextMetadata.getTextExpression();
                                }
                                for (int i = 0; i < elems.length; ++i) {
                                    String textValue = elems[i].getValue();
                                    if (textValue == null) {
                                        elems[i].setValue(previousText);
                                    } else {
                                        previousText = textValue;
                                    }
                                    if (elems[i].getAttributes() == null) {
                                        elems[i].setAttributes(txtAttributes);
                                    } else if (!Util.isFullExtent(queryWin.getMinX(), queryWin.getMinY(), queryWin.getMaxX(), queryWin.getMaxY()) && !Double.isNaN(atextMetadata.getMapBaseScale()) && atextMetadata.getMapBaseScale() > 0.0) {
                                        double inmeter = atextMetadata.getMapBaseScale() * 0.0254 / vc.getDPI();
                                        float fsize = elems[i].getAttributes().getTextStyle().getFontSize();
                                        SizeDefinition sizeDef = new SizeDefinition(fsize *= (float)inmeter, "m");
                                        double pixelSize = Util.convertToPixelSize(sizeDef, vc);
                                        if (!Double.isNaN(pixelSize)) {
                                            elems[i].getAttributes().getTextStyle().setFontSize((float)pixelSize);
                                        }
                                    }
                                    if (!applyRotation) continue;
                                    elems[i].setLocation(this.rotateGeometry(elems[i].getLocation(), vc));
                                    elems[i].setLeaderLine(this.rotateGeometry(elems[i].getLeaderLine(), vc));
                                }
                            }
                            sf.setAnnotationTextLabel(atext);
                        }
                        if (this.def.getLabelLeaderLineStyleName() != null) {
                            sf.setLabelLeaderLineStyleName(this.def.getLabelLeaderLineStyleName());
                        } else {
                            sf.setLabelLeaderLineStyle(defaultLineStyle);
                        }
                    }
                }
                sf.setLabelStyleName(this.def.getLabelStyleName());
                if (keyCol > 0) {
                    sf.setID(rs.getString(keyCol));
                }
                if (hasAttributes || this.def.identifiableColumns != null) {
                    this.fillAttributes(sf, meta, rs, geomCol, labelCol, sf.getLabel(), keyCol, sf.getID(), totalColCount, xCol, xValue, yCol, yValue);
                }
                sf.setAllowNakedPoints(allowNakedPoints);
                styledFeatureList.add(sf);
                ++this.loadedFeaturesInAdjustedMBR;
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            log.finer("Read all geometries.");
            long t2 = System.currentTimeMillis();
            log.info("[" + this.def.getName() + "] sql exec time: " + (t4 - t3) + "ms, total time loading " + cnt + " feature:" + (t2 - t1) + "ms");
            TopThemeQueries.add(t2 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), query, "features loaded = " + cnt);
            ArrayList<StyledFeatureI> arrayList = styledFeatureList;
            return arrayList;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("ORA-01013") < 0) {
                log.log(Level.SEVERE, "Error fetching data.", e);
                throw new DataException(e);
            }
            throw new DataException("Aborted by user.", e);
        }
        finally {
            if (this.getTheme().getDecorator().getWorkspaceName() != null && isOracleDB) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenD = 0L;
        try {
            tokenD = dynGeomSensor.start();
            this.aborted = false;
            this.def.isHeatMapTheme = ThemeUtils.isHeatMapTheme(this.def, vc);
            ArrayList styledFeatureList = null;
            Connection conn = this.getDBConnection(vc);
            if (conn == null) {
                int n = 0;
                return n;
            }
            boolean isOracleDB = true;
            try {
                try {
                    if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                        isOracleDB = false;
                    }
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
                if (this.getTheme().getDecorator().getWorkspaceName() != null && isOracleDB) {
                    this.gotoWorkspace(conn);
                }
                double[] inmbr = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
                boolean fullext = MapMaker.isSpecial(queryWin);
                if (fullext) {
                    inmbr[0] = Double.NEGATIVE_INFINITY;
                    inmbr[1] = Double.NEGATIVE_INFINITY;
                    inmbr[2] = Double.POSITIVE_INFINITY;
                    inmbr[3] = Double.POSITIVE_INFINITY;
                } else {
                    inmbr[0] = queryWin.getMinX();
                    inmbr[1] = queryWin.getMinY();
                    inmbr[2] = queryWin.getMaxX();
                    inmbr[3] = queryWin.getMaxY();
                }
                double[] inmbrValid = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
                double[] inmbrValid2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
                boolean hasQueryWin2 = SRS.splitQueryMBR(inmbr, inmbrValid, inmbrValid2, vc.getMasterSRID());
                if (vc.getWrapAround() && !SRS.isWrapAroundSupported(vc.getMasterSRID())) {
                    vc.setWrapAround(false);
                }
                log.finest("Original query box is ajusted to: (" + inmbrValid[0] + "," + inmbrValid[1] + " " + inmbrValid[2] + "," + inmbrValid[3] + ")");
                this.setRequestMBR(inmbrValid);
                if (hasQueryWin2) {
                    this.setRequestMBR2(inmbrValid2);
                    log.finest("Query box2 is set to: (" + inmbrValid2[0] + "," + inmbrValid2[1] + " " + inmbrValid2[2] + "," + inmbrValid2[3] + ")");
                }
                Rectangle2D.Double rectTmp = new Rectangle2D.Double(inmbrValid[0], inmbrValid[1], inmbrValid[2] - inmbrValid[0], inmbrValid[3] - inmbrValid[1]);
                log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
                this.loadedFeaturesInAdjustedMBR = 0L;
                styledFeatureList = this.loadFeaturesInAdjustedMBR(rectTmp, conn, vc, isOracleDB);
                this.loadedFeaturesInAdjustedMBR = styledFeatureList.size();
                if (hasQueryWin2) {
                    ArrayList styledFeatureList2 = null;
                    rectTmp = new Rectangle2D.Double(inmbrValid2[0], inmbrValid2[1], inmbrValid2[2] - inmbrValid2[0], inmbrValid2[3] - inmbrValid2[1]);
                    styledFeatureList2 = this.loadFeaturesInAdjustedMBR(rectTmp, conn, vc, isOracleDB);
                    for (int k = 0; k < styledFeatureList2.size(); ++k) {
                        styledFeatureList.add(styledFeatureList2.get(k));
                    }
                    styledFeatureList2 = null;
                }
            }
            catch (DataException se) {
                throw se;
            }
            finally {
                try {
                    if (conn != null) {
                        DSUtil.closeDBConnection(conn, this.owner.getDataSourceName());
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
            }
            if (this.aborted) {
                styledFeatureList.clear();
            }
            if (styledFeatureList.size() <= 0) {
                int n = 0;
                return n;
            }
            this.setStyledFeatures(styledFeatureList);
            int n = styledFeatureList.size();
            return n;
        }
        finally {
            dynGeomSensor.stop(tokenD);
        }
    }

    private JGeometry rotateGeometry(JGeometry geom, VisContext vc) {
        if (geom == null || vc == null) {
            return geom;
        }
        Rectangle2D queryWin = vc.getQueryWindow();
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        return Util.rotateGeometry(geom, (xl + xh) / 2.0, (yl + yh) / 2.0, vc.getRotation());
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.features != null) {
            this.features.postPreparation(vc);
        }
    }

    String getFeatureStyleName() {
        return this.def.getFeatureStyleName();
    }

    String getLabelStyleName() {
        return this.def.getLabelStyleName();
    }

    protected void fillAttributes(StyledFeatureI sf, ResultSetMetaData meta, ResultSet rs, int geomCol, int labelCol, String label, int keyCol, String key, int totalCol, int xCol, double xValue, int yCol, double yValue) throws SQLException, IOException {
        int nAttrs;
        int n = nAttrs = labelCol <= 0 ? totalCol - 1 : totalCol - 2;
        if (xCol > 0 && yCol > 0) {
            nAttrs = geomCol <= 0 ? (labelCol <= 0 ? totalCol - 2 : totalCol - 3) : (labelCol <= 0 ? totalCol - 3 : totalCol - 4);
        }
        Vector<Field> v = new Vector<Field>();
        for (int i = 1; i < totalCol + 1; ++i) {
            if (i == geomCol || i == labelCol || i == keyCol || i == xCol || i == yCol) continue;
            Field attr = null;
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            attr = Util.getFieldFromResultSet(sqlType, rs, i);
            attr.setName(name);
            v.add(attr);
        }
        Field[] iAttrs = this.def.getIdentifiableColumns();
        if (iAttrs == null) {
            sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
        } else {
            Field[] myIAttrs = new Field[iAttrs.length];
            block1: for (int i = 0; i < iAttrs.length; ++i) {
                Field a = iAttrs[i];
                String name = a.getName();
                if (name.equalsIgnoreCase(this.def.getLabelColumn())) {
                    Field ca = new Field(label).setName(name);
                    ca.setDisplayName(a.getDisplayName());
                    myIAttrs[i] = ca;
                    continue;
                }
                if (name.equalsIgnoreCase(this.def.getKeyColumn())) {
                    Field ca = new Field(key).setName(name);
                    ca.setDisplayName(a.getDisplayName());
                    myIAttrs[i] = ca;
                    continue;
                }
                if (name.equalsIgnoreCase(this.def.getPointXColumn())) {
                    Field ca = new Field(xValue).setName(name);
                    ca.setDisplayName(a.getDisplayName());
                    myIAttrs[i] = ca;
                    continue;
                }
                if (name.equalsIgnoreCase(this.def.getPointYColumn())) {
                    Field ca = new Field(yValue).setName(name);
                    ca.setDisplayName(a.getDisplayName());
                    myIAttrs[i] = ca;
                    continue;
                }
                for (int c = 0; c < v.size(); ++c) {
                    Field ca = (Field)v.get(c);
                    if (!name.equalsIgnoreCase(ca.getName())) continue;
                    ca.setDisplayName(a.getDisplayName());
                    myIAttrs[i] = ca;
                    if (this.columnDefinedInRenderingRules(a.getName())) continue block1;
                    v.remove(c);
                    continue block1;
                }
            }
            sf.setIdentifiableAttributes(myIAttrs);
            if (v.size() > 0) {
                sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
            }
        }
    }

    private boolean columnDefinedInRenderingRules(String col) {
        RenderingRule[] rules = this.def.getRenderingRules();
        if (rules == null) {
            return false;
        }
        for (int i = 0; i < rules.length; ++i) {
            String[] substycols;
            String[] stycols = rules[i].getStyleColumns();
            if (stycols != null && stycols.length > 0) {
                for (int j = 0; j < stycols.length; ++j) {
                    if (!col.equalsIgnoreCase(stycols[j])) continue;
                    return true;
                }
            }
            if ((substycols = rules[i].getSubStyleColumns()) == null || substycols.length <= 0) continue;
            for (int j = 0; j < substycols.length; ++j) {
                if (!col.equalsIgnoreCase(substycols[j])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String rewriteQuery(Connection conn, Rectangle2D queryWin, VisContext vc, boolean isOracleDB) {
        String myQuery;
        double[] rmbr;
        boolean workaround;
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        boolean transformSRid = false;
        int mySrid = this.def.getSrid();
        SRS srs = null;
        boolean isGeodetic = false;
        String unit = null;
        SRSCache sc = DSManager.getSRSCache(this.owner.getDataSourceName());
        srs = sc.get(mySrid);
        if (srs != null) {
            isGeodetic = srs.isGeodetic();
            unit = srs.getUnit();
        } else if (this.def.getSrid() > 0) {
            log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
        }
        double xi = xl;
        double xf = xh;
        double yi = yl;
        double yf = yh;
        double masterScale = vc.getCurrentScale();
        this.getTheme().setShowLabels(true);
        if (isOracleDB && vc.getMasterSRID() > 0 && mySrid > 0 && mySrid != vc.getMasterSRID()) {
            if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double[] inmbr = new double[]{xl, yl, xh, yh};
                double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), mySrid, conn);
                if (outmbr == null) {
                    log.severe("Conversion of SRIDs returned null.");
                    return null;
                }
                xl = outmbr[0];
                yl = outmbr[1];
                xh = outmbr[2];
                yh = outmbr[3];
                transformSRid = true;
                log.finest("Transform srid set to true after converting mbr.");
            } else {
                transformSRid = true;
                log.finest("Transform srid set to true because of finite master scale.");
            }
            log.finest("Visual context master srid: " + vc.getMasterSRID());
        }
        if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
            double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
            log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
            double scale = masterScale * factor;
            if (this.getTheme().getScaleType() == "RATIO") {
                double centery;
                double centerx;
                if (vc.getMasterSRID() > 0 && mySrid > 0 && mySrid != vc.getMasterSRID()) {
                    srs = sc.get(vc.getMasterSRID());
                    centerx = (xi + xf) / 2.0;
                    centery = (yi + yf) / 2.0;
                    factor = 1.0;
                } else {
                    centerx = (xl + xh) / 2.0;
                    centery = (yl + yh) / 2.0;
                }
                if (vc.isTileRequest() && srs.isGeodetic()) {
                    centerx = 0.0;
                    centery = 0.0;
                }
                if (srs == null) {
                    log.severe("Theme must have SRS when using ratio scale mode.");
                    return null;
                }
                scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                log.finer("Ratio scale to compare: " + scale);
            }
            if (!this.getTheme().withinRenderScaleLimits(scale)) {
                log.finer("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return null;
            }
            if (!this.getTheme().withinLabelScaleLimits(scale)) {
                log.finer("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                this.getTheme().setShowLabels(false);
            }
        }
        boolean bl = workaround = isGeodetic && xh - xl > 2.0 && xh - xl < 120.0;
        if (workaround) {
            xl = Math.floor(xl);
            log.finest("jtvpxfmfxed: xl=" + xl);
        }
        log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
        if (vc.getRotation() != 0.0 && !this.def.isPassthrough() && queryWin.getWidth() != Double.POSITIVE_INFINITY && queryWin.getHeight() != Double.POSITIVE_INFINITY && (rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation())) != null) {
            xl = Math.min(rmbr[0], xl);
            yl = Math.min(rmbr[1], yl);
            xh = Math.max(rmbr[2], xh);
            yh = Math.max(rmbr[3], yh);
            log.finest("Rotation angle: " + vc.getRotation());
            log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
        }
        if (this.passThruWithFilterParams((myQuery = this.def.getQuery()).toUpperCase())) {
            return this.substituteFilterParams(myQuery, xl, yl, xh, yh);
        }
        if (!isOracleDB || this.def.isPassthrough() || queryWin.getWidth() == Double.POSITIVE_INFINITY || queryWin.getHeight() == Double.POSITIVE_INFINITY) {
            if (transformSRid && !this.isXYjdbc()) {
                String changequery = "select ";
                String attrquery = "SELECT * FROM ( " + myQuery + " ) WHERE rownum < 1";
                ResultSet rs = null;
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement(attrquery);
                    if (this.bindingParameters != null) {
                        for (int i = 0; i < this.bindingParameters.length; ++i) {
                            DynGeomThemeProducer.setBindingVariable(conn, stmt, this.bindingParameters[i], i + 1);
                        }
                    }
                    rs = stmt.executeQuery();
                    ResultSetMetaData rsmeta = rs.getMetaData();
                    int colCnt = rsmeta.getColumnCount();
                    for (int i = 1; i <= colCnt; ++i) {
                        String colname;
                        if (i > 1) {
                            changequery = changequery + ", ";
                        }
                        changequery = (colname = rsmeta.getColumnName(i)).equalsIgnoreCase(this.def.getSpatialColumn()) ? changequery + "sdo_cs.transform(" + this.def.getSpatialColumn() + "," + vc.getMasterSRID() + ") " + this.def.getSpatialColumn() : changequery + colname;
                    }
                }
                catch (Exception ex) {
                    log.warning("Exception while retrieving attribute names: " + ex);
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
                changequery = changequery + " FROM ( " + myQuery + " )";
                log.finest("Query changed: " + changequery);
                return changequery;
            }
            return myQuery;
        }
        if (vc.getDeviceWindow() != null) {
            this.viewResX = vc.getDeviceWindow().getWidth();
            this.viewResY = vc.getDeviceWindow().getHeight();
            log.finer("View ResX: " + this.viewResX + " View resY: " + this.viewResY);
        }
        this.dbVersion = Util.getDBVersion(conn);
        log.finer("Database Version: " + this.dbVersion);
        String filter = this.getFilter(this.def.getSpatialColumn(), this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        if (transformSRid && !this.isXYjdbc()) {
            String changequery = "select ";
            String attrquery = "SELECT * FROM ( " + myQuery + " ) WHERE rownum < 1";
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement(attrquery);
                if (this.bindingParameters != null) {
                    for (int i = 0; i < this.bindingParameters.length; ++i) {
                        DynGeomThemeProducer.setBindingVariable(conn, stmt, this.bindingParameters[i], i + 1);
                    }
                }
                rs = stmt.executeQuery();
                ResultSetMetaData rsmeta = rs.getMetaData();
                int colCnt = rsmeta.getColumnCount();
                for (int i = 1; i <= colCnt; ++i) {
                    String colname;
                    if (i > 1) {
                        changequery = changequery + ", ";
                    }
                    changequery = (colname = rsmeta.getColumnName(i)).equalsIgnoreCase(this.def.getSpatialColumn()) ? changequery + "sdo_cs.transform(" + this.def.getSpatialColumn() + "," + vc.getMasterSRID() + ") " + this.def.getSpatialColumn() : changequery + colname;
                }
            }
            catch (Exception ex) {
                log.warning("Exception while retrieving column names:\n" + ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
            }
            changequery = changequery + " FROM ( " + myQuery + " ) WHERE " + filter;
            log.finest("[" + this.def.getName() + "] Query changed: " + changequery);
            return changequery;
        }
        if (!this.isXYjdbc()) {
            return "SELECT * FROM ( " + myQuery + " ) WHERE " + filter;
        }
        filter = "" + this.def.getPointXColumn() + " >= " + xl + " and " + this.def.getPointXColumn() + " <= " + xh + " and " + this.def.getPointYColumn() + " >= " + yl + " and " + this.def.getPointYColumn() + " <= " + yh;
        return "SELECT * FROM ( " + myQuery + " ) WHERE " + filter;
    }

    final String getFilter(String spatialColumn, int srid, double xl, double yl, double xh, double yh, boolean _is9i, boolean geodetic) {
        StringBuffer sb = new StringBuffer(256);
        String params = "'querytype=WINDOW'";
        if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && this.viewResX != Double.MIN_VALUE && (this.dbVersion.indexOf(" 10.2") > 0 || this.dbVersion.indexOf(" 10.1.0.3") > 0 || this.dbVersion.indexOf(" 10.1.0.4") > 0 || Util.is11gOrAfter(this.dbVersion))) {
            double resx = (xh - xl) / this.viewResX;
            double resy = (yh - yl) / this.viewResY;
            double res = Math.min(resx, resy) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
            if (geodetic) {
                double earthRadius = 6378137.0;
                res *= Math.PI * earthRadius / 180.0;
            }
            params = "'min_resolution=" + res + " querytype=WINDOW'";
        }
        if (_is9i && geodetic) {
            sb.append("MDSYS.SDO_FILTER(" + spatialColumn + ", ");
            sb.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            sb.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + "))" + ", " + srid + " ), " + params + ") = 'TRUE'");
            return sb.toString();
        }
        sb.append("MDSYS.SDO_FILTER(" + spatialColumn + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + ")), " + params + ") = 'TRUE'");
        return sb.toString();
    }

    final boolean passThruWithFilterParams(String query) {
        if (query.indexOf("SDO_ORDINATE_ARRAY") == -1) {
            return false;
        }
        int p1 = query.indexOf("?");
        if (p1 == -1) {
            return false;
        }
        try {
            int p4 = query.lastIndexOf("?");
            String box = query.substring(p1, p4 + 1);
            StringTokenizer st = new StringTokenizer(box, ", \n\t\r\f");
            if (!st.nextToken().equals("?")) {
                return false;
            }
            if (!st.nextToken().equals("?")) {
                return false;
            }
            if (!st.nextToken().equals("?")) {
                return false;
            }
            if (!st.nextToken().equals("?")) {
                return false;
            }
        }
        catch (Exception e) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01030"));
            return false;
        }
        return true;
    }

    final String substituteFilterParams(String query, double xl, double yl, double xh, double yh) {
        StringBuffer sb = new StringBuffer(query.length() + 50);
        int p1 = query.indexOf("?");
        if (p1 == -1) {
            return query;
        }
        int p4 = query.lastIndexOf("?");
        if (p4 == -1) {
            return query;
        }
        sb.append(query.substring(0, p1));
        sb.append("" + xl + ", " + yl + ", " + xh + ", " + yh);
        sb.append(query.substring(p4 + 1));
        return sb.toString();
    }

    @Override
    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    @Override
    public void abort() {
        this.aborted = true;
        try {
            if (this.stmt != null) {
                this.stmt.cancel();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
    }

    public static void setBindingVariable(Connection conn, PreparedStatement stmt, Object var, int idx) throws SQLException, IllegalArgumentException {
        if (var instanceof String) {
            stmt.setString(idx, (String)var);
        } else if (var instanceof Integer) {
            stmt.setInt(idx, (Integer)var);
        } else if (var instanceof Double) {
            stmt.setDouble(idx, (Double)var);
        } else if (var instanceof Float) {
            stmt.setFloat(idx, ((Float)var).floatValue());
        } else if (var instanceof Long) {
            stmt.setLong(idx, (Long)var);
        } else if (var instanceof Short) {
            stmt.setShort(idx, (Short)var);
        } else if (var instanceof Byte) {
            stmt.setByte(idx, (Byte)var);
        } else if (var instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)var);
        } else if (var instanceof byte[]) {
            stmt.setBytes(idx, (byte[])var);
        } else if (var instanceof Date) {
            stmt.setDate(idx, (Date)var);
        } else if (var instanceof Time) {
            stmt.setTime(idx, (Time)var);
        } else if (var instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)var);
        } else if (var instanceof ArrayParameter) {
            stmt.setArray(idx, (Array)JDBCUtil.createSQLArray((ArrayParameter)var, conn));
        } else if (var instanceof JGeometry) {
            JGeometry g = (JGeometry)var;
            int srid = g.getSRID();
            if (Util.isGeodetic(srid) && g != null && g.isCircle()) {
                g = Util.linearizeCircle(g);
            }
            STRUCT geom = null;
            Object[] descs = Util.createDBGeomDescriptors(conn);
            geom = JGeometry.store((JGeometry)g, (Connection)conn, (Object[])descs);
            stmt.setObject(idx, geom);
        } else {
            throw new IllegalArgumentException("Binding data type not supported:" + var.getClass().toString());
        }
    }

    public void setBindingParameters(Object[] bindingParams) {
        this.bindingParameters = bindingParams;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        if (this.def.isHeatMapTheme) {
            return new HMPointFeature();
        }
        return new StyledFeature();
    }

    public boolean isXYjdbc() {
        return this.def.getPointXColumn() != null && this.def.getPointXColumn().trim().length() >= 1 && this.def.getPointYColumn() != null && this.def.getPointYColumn().trim().length() >= 1;
    }

    private TextAttributesType getMetadataTextAttributes(String xmlAttributes) {
        if (xmlAttributes == null) {
            return null;
        }
        JAXBContext jc = null;
        Unmarshaller u = null;
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                u = jc.createUnmarshaller();
            }
            StringBuffer xmlStr = new StringBuffer(xmlAttributes);
            JAXBElement jaxbEl = (JAXBElement)u.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
            TextAttributesType txtattrs = (TextAttributesType)jaxbEl.getValue();
            return txtattrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRequestMBR(double[] mbr) {
        for (int k = 0; k < 4; ++k) {
            this.queryMBR[k] = mbr[k];
        }
    }

    public void setRequestMBR2(double[] mbr2) {
        for (int k = 0; k < 4; ++k) {
            this.queryMBR2[k] = mbr2[k];
        }
    }

    public double[] getRequestMBR() {
        return this.queryMBR;
    }

    public double[] getRequestMBR2() {
        return this.queryMBR2;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

