/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;

public class WMSMapThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent wmsMapSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "WMSMap", "Producer", "Time spent preparing data");
    protected Theme owner;
    private WMSMapThemeDefinition def;
    private Image wmsMap;
    double xl;
    double yl;
    double xh;
    double yh;
    boolean flag = false;
    private boolean isErrorImage = false;

    public WMSMapThemeProducer(Theme t) {
        this.owner = t;
        this.def = (WMSMapThemeDefinition)t.getDefinition();
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public int size() {
        return this.wmsMap == null ? 0 : 1;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenW = 0L;
        try {
            String urlString;
            String serverURLPrefix;
            String params;
            int sdosrid;
            boolean transformSRid;
            long t0;
            block60: {
                tokenW = wmsMapSensor.start();
                this.isErrorImage = false;
                this.flag = false;
                t0 = System.currentTimeMillis();
                transformSRid = false;
                this.xl = queryWin.getMinX();
                this.yl = queryWin.getMinY();
                this.xh = queryWin.getMaxX();
                this.yh = queryWin.getMaxY();
                int widht = (int)vc.getDeviceWindow().getWidth();
                int height = (int)vc.getDeviceWindow().getHeight();
                double xi = this.xl;
                double xf = this.xh;
                double yi = this.yl;
                double yf = this.yh;
                double masterScale = vc.getCurrentScale();
                String srsname = this.def.getSrs();
                sdosrid = this.def.getSrid();
                if (sdosrid <= 0 && vc.getMasterDataSourceName() != null && srsname != null) {
                    String sridS = null;
                    int index = srsname.indexOf(":");
                    if (index > -1) {
                        sridS = srsname.substring(index + 1, srsname.length());
                    }
                    int srid = 0;
                    try {
                        srid = Integer.parseInt(sridS);
                        if (srsname.toUpperCase().indexOf("EPSG:") > -1) {
                            String sdo_srid = EPSG2SDO.EPSGtoSDO(sridS);
                            if (sdo_srid != null) {
                                sdosrid = Integer.parseInt(sdo_srid);
                                log.info("EPSG:" + sridS + " is mapped to SDO:" + sdosrid);
                            } else {
                                sdosrid = Util.EPSGsrid_To_Oraclesrid(vc.getMasterDataSourceName(), srid);
                            }
                        } else if (srsname.toUpperCase().indexOf("CRS:") > -1) {
                            sdosrid = srid == 84 ? 8307 : (srid == 83 ? 8265 : (srid == 27 ? 8260 : 0));
                            log.info("CRS:" + sridS + " is mapped to SDO:" + sdosrid);
                        }
                    }
                    catch (Exception ex) {
                        sdosrid = 0;
                    }
                }
                SRSCache sc = DSManager.getSRSCache(vc.getMasterDataSourceName());
                SRS srs = null;
                if (sc != null) {
                    srs = sc.get(sdosrid);
                }
                if (vc.getMasterSRID() > 0 && sdosrid > 0 && sdosrid != vc.getMasterSRID() && vc.getMasterDataSourceName() != null) {
                    Connection conn = null;
                    try {
                        conn = DSUtil.getDBConnection(vc.getMasterDataSourceName(), vc);
                    }
                    catch (Exception e) {
                        log.info("Unable to get datasource connection to convert SRID");
                        int n = 0;
                        wmsMapSensor.stop(tokenW);
                        return n;
                    }
                    if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                        double[] inmbr = new double[]{this.xl, this.yl, this.xh, this.yh};
                        double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), sdosrid, conn);
                        if (outmbr == null) {
                            DSUtil.closeDBConnection(conn, vc.getMasterDataSourceName());
                            vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                            int n = 0;
                            return n;
                        }
                        this.xl = outmbr[0];
                        this.yl = outmbr[1];
                        this.xh = outmbr[2];
                        this.yh = outmbr[3];
                        transformSRid = true;
                    } else {
                        transformSRid = true;
                    }
                    DSUtil.closeDBConnection(conn, vc.getMasterDataSourceName());
                }
                if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                    double factor = Math.abs(this.yh - this.yl) / Math.abs(yf - yi);
                    log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
                    double scale = masterScale * factor;
                    if (this.getTheme().getScaleType() == "RATIO") {
                        double centery;
                        double centerx;
                        if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                            srs = sc.get(vc.getMasterSRID());
                            centerx = (xi + xf) / 2.0;
                            centery = (yi + yf) / 2.0;
                            factor = 1.0;
                        } else {
                            centerx = (this.xl + this.xh) / 2.0;
                            centery = (this.yl + this.yh) / 2.0;
                        }
                        if (vc.isTileRequest() && srs.isGeodetic()) {
                            centerx = 0.0;
                            centery = 0.0;
                        }
                        if (srs != null) {
                            scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                            log.finer("Ratio scale to compare: " + scale);
                        } else {
                            vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                            int n = 0;
                            return n;
                        }
                    }
                    if (!this.getTheme().withinRenderScaleLimits(scale)) {
                        log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                        int centerx = 0;
                        return centerx;
                    }
                }
                if (MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh) && vc.getRotation() != 0.0) {
                    log.warning("Rotation is currently ignored for full extent.");
                } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh)) {
                    if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                        log.warning("Rotation value must be in between -360 to 360 degrees. Ignored");
                    } else {
                        double[] rmbr = Util.rotateMBR(this.xl, this.yl, this.xh, this.yh, vc.getRotation());
                        if (rmbr != null) {
                            this.xl = Math.min(rmbr[0], this.xl);
                            this.yl = Math.min(rmbr[1], this.yl);
                            this.xh = Math.max(rmbr[2], this.xh);
                            this.yh = Math.max(rmbr[3], this.yh);
                            log.finest("Rotation angle: " + vc.getRotation());
                            log.finest("Search window for rotation: " + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                        } else {
                            log.info("Rotated MBR is null. Rotation ignored.");
                        }
                    }
                }
                params = this.constructURL(vc);
                serverURLPrefix = this.def.getServerUrlPrefix();
                try {
                    urlString = null;
                    if (serverURLPrefix != null) break block60;
                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01047") + " [" + this.owner.getName() + "]");
                    int n = 0;
                    return n;
                }
                catch (Exception ex) {
                    this.destroyImage();
                    vc.processDataError(ex, log, "Exception loading WMS map image");
                    int resp = 0;
                    wmsMapSensor.stop(tokenW);
                    return resp;
                }
            }
            if (serverURLPrefix.indexOf(63) > 0) {
                if (!serverURLPrefix.endsWith("&")) {
                    urlString = serverURLPrefix + "&" + params;
                    log.finest("WMS map url: " + serverURLPrefix + "&" + params);
                } else {
                    urlString = serverURLPrefix + params;
                    log.finest("WMS map url: " + serverURLPrefix + params);
                }
            } else {
                urlString = serverURLPrefix + "?" + params;
                log.finest("WMS map url: " + serverURLPrefix + "?" + params);
            }
            byte[] resp = null;
            long timeout = ((WMSMapTheme)this.owner).getDecorator().getRequestTimeout();
            if (timeout < 0L) {
                timeout = 0L;
            }
            WMSurlThread wmsThread = new WMSurlThread(urlString);
            wmsThread.start();
            wmsThread.checkTimeout(timeout);
            if (wmsThread.isCompleted()) {
                resp = wmsThread.getBinaryData();
                this.wmsMap = ImageUtils.blockingLoad(resp);
            } else {
                String timeoutMsg = "Unable to get WMS response for theme timeout=" + timeout + " miliseconds.";
                resp = timeoutMsg.getBytes();
                this.wmsMap = null;
            }
            if (this.wmsMap == null) {
                this.isErrorImage = true;
                log.severe("Failure accessing WMS theme image:\n" + new String(resp));
                this.initMapImage(vc, "Failure accessing WMS theme " + this.owner.getName());
                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01048"));
            } else {
                long t1 = System.currentTimeMillis();
                TopThemeQueries.add(t1 - t0, this.getTheme().getName(), this.getTheme().getDataSourceName(), serverURLPrefix, "WMS request.");
            }
            if (transformSRid) {
                Connection conn = null;
                try {
                    conn = DSUtil.getDBConnection(vc.getMasterDataSourceName(), vc);
                    double[] inmbr = new double[]{this.xl, this.yl, this.xh, this.yh};
                    double[] outmbr = Util.convertMBR(inmbr, sdosrid, vc.getMasterSRID(), conn);
                    if (outmbr != null) {
                        this.xl = outmbr[0];
                        this.yl = outmbr[1];
                        this.xh = outmbr[2];
                        this.yh = outmbr[3];
                    }
                }
                catch (Exception e) {
                }
                finally {
                    if (conn != null) {
                        DSUtil.closeDBConnection(conn, vc.getMasterDataSourceName());
                    }
                }
            }
            int n = 1;
            return n;
        }
        finally {
            wmsMapSensor.stop(tokenW);
        }
    }

    @Override
    public void postPreparation(VisContext vc) {
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        return null;
    }

    @Override
    public double[] getDataMBR() {
        return new double[]{this.xl, this.yl, this.xh, this.yh};
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        return null;
    }

    @Override
    public void destroy() {
        this.destroyImage();
    }

    @Override
    public void abort() {
    }

    private void destroyImage() {
        if (this.wmsMap != null) {
            ImageUtils.removeImageFromTracker(this.wmsMap);
            this.wmsMap.flush();
            this.wmsMap = null;
        }
    }

    public Image getWMSMap() {
        return this.wmsMap;
    }

    private void initMapImage(VisContext vc, String msg) {
        int w = (int)vc.getDeviceWindow().getWidth();
        int h = (int)vc.getDeviceWindow().getHeight();
        try {
            if (this.wmsMap == null || this.wmsMap.getWidth(null) != w || this.wmsMap.getHeight(null) != h) {
                this.destroyImage();
                this.wmsMap = new BufferedImage(w, h, 2);
            }
        }
        catch (OutOfMemoryError er) {
            log.severe("Out of memory allocating buffer image for wms-map theme " + this.def.getName());
            return;
        }
        Color c = new Color(255, 255, 255, 0);
        Graphics2D g2 = (Graphics2D)this.wmsMap.getGraphics();
        g2.fillRect(0, 0, this.wmsMap.getWidth(null), this.wmsMap.getHeight(null));
        g2.setFont(new Font("DialogInput", 1, 18));
        g2.setColor(Color.RED);
        g2.drawString(msg, this.wmsMap.getWidth(null) / 10, this.wmsMap.getHeight(null) / 10);
        g2.dispose();
    }

    private String constructURL(VisContext vc) {
        int i;
        String srsString;
        String theVersion;
        StringBuffer sb;
        block18: {
            sb = new StringBuffer(1024);
            theVersion = this.def.getWmtVersion();
            if ("1.0.0".equalsIgnoreCase(theVersion)) {
                sb.append("WMTVER=" + theVersion);
                sb.append("&REQUEST=Map");
            } else {
                sb.append("VERSION=" + theVersion);
                sb.append("&REQUEST=GetMap");
            }
            srsString = "SRS";
            if (theVersion != null && theVersion.equalsIgnoreCase("1.3.0")) {
                srsString = "CRS";
            }
            sb.append("&" + srsString + "=" + this.def.getSrs());
            if (theVersion != null && theVersion.equalsIgnoreCase("1.3.0") && this.def.getSrs().toUpperCase().indexOf("EPSG:") > -1) {
                int index = this.def.getSrs().indexOf(":");
                String sridS = this.def.getSrs().substring(index + 1, this.def.getSrs().length());
                int epsg = 0;
                try {
                    epsg = Integer.parseInt(sridS);
                    if (Util.reverseAxisOrder(vc.getMasterDataSourceName(), epsg)) {
                        sb.append("&BBOX=" + this.yl + "," + this.xl + "," + this.yh + "," + this.xh);
                        break block18;
                    }
                    sb.append("&BBOX=" + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                }
                catch (Exception ex) {
                    sb.append("&BBOX=" + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                }
            } else {
                sb.append("&BBOX=" + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
            }
        }
        sb.append("&WIDTH=" + (int)vc.getDeviceWindow().getWidth());
        sb.append("&HEIGHT=" + (int)vc.getDeviceWindow().getHeight());
        String format = this.def.getFormat();
        sb.append("&FORMAT=" + format.replace(' ', '+'));
        sb.append("&BGCOLOR=" + this.def.getBgColor());
        String tr = this.def.isTransparent() ? "TRUE" : "FALSE";
        sb.append("&TRANSPARENT=" + tr);
        log.finer("Added to URL. Version = " + theVersion + " " + srsString + " = " + this.def.getSrs() + " FORMAT = " + this.def.getFormat() + " BGCOLOR = " + this.def.getBgColor());
        if (this.def.getLayers() != null) {
            String[] layers = this.def.getLayers();
            String aLayer = null;
            sb.append("&LAYERS=");
            for (i = 0; i < layers.length - 1; ++i) {
                aLayer = layers[i].replace(' ', '+');
                sb.append(aLayer + ",");
            }
            aLayer = layers[layers.length - 1].replace(' ', '+');
            sb.append(aLayer);
        }
        String[] styles = this.def.getStyles();
        String aStyle = null;
        sb.append("&STYLES=");
        if (styles != null && styles.length > 0) {
            for (i = 0; i < styles.length - 1; ++i) {
                aStyle = styles[i].replace(' ', '+');
                sb.append(aStyle + ",");
            }
            aStyle = styles[styles.length - 1].replace(' ', '+');
            sb.append(aStyle);
        }
        sb.append("&EXCEPTIONS=" + this.def.getExceptions());
        if (this.def.getVsps() != null) {
            log.finer("Adding VSPs to URL");
            String[][] vsps = this.def.getVsps();
            for (int i2 = 0; i2 < vsps[0].length; ++i2) {
                String name = vsps[0][i2];
                String val = vsps[1][i2];
                sb.append("&" + name + "=" + val);
                log.finer("Appending &" + name + "=" + val);
            }
        } else {
            log.finer("No VendorSpecificParameters defined");
        }
        String s = sb.toString();
        if (((WMSMapTheme)this.owner).getUseURLEncoding()) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                return s;
            }
        }
        return s;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    public boolean isErrorImage() {
        return this.isErrorImage;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return -1L;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
    }

    public class WMSurlThread
    extends Thread {
        private String reqstr = null;
        private byte[] data = null;
        boolean isCompleted;

        public WMSurlThread(String reqstr_) {
            this.reqstr = reqstr_;
        }

        @Override
        public void run() {
            this.isCompleted = false;
            try {
                URL wu = new URL(this.reqstr);
                this.data = Util.readBinaryFromURL(wu);
                this.isCompleted = true;
            }
            catch (Exception ex) {
                log.warning("Exception in WMS getMap request: " + ex.getMessage());
            }
        }

        public byte[] getBinaryData() {
            return this.data;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public void checkTimeout(long timeout) {
            log.finest("WMS theme timeout value: " + timeout + " miliseconds");
            try {
                this.join(timeout);
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }
}

