/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;

public class HttpPostThread
extends Thread {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String serviceUrl = null;
    String postRequest = null;
    String contentType = null;
    String response = null;
    private boolean completed = false;
    private Exception exception = null;

    public HttpPostThread(String url, String xmlRequest, String contenttype) {
        this.serviceUrl = url;
        this.postRequest = xmlRequest;
        this.contentType = contenttype;
    }

    @Override
    public void run() {
        this.completed = false;
        this.exception = null;
        if (this.serviceUrl == null) {
            this.response = null;
            this.exception = new Exception("Service URL is null.");
            return;
        }
        if (this.postRequest == null) {
            this.response = null;
            this.exception = new Exception("POST xml request is null.");
            return;
        }
        try {
            HttpConnection hurl = new HttpConnection();
            if (this.contentType != null) {
                hurl.setContentTypeProperty(this.contentType);
            }
            hurl.connect(this.serviceUrl);
            hurl.sendXMLRequest("", this.postRequest);
            this.response = hurl.getXMLResponse();
        }
        catch (Exception e) {
            this.response = null;
            this.exception = e;
            return;
        }
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void checkTimeout(long timeout) {
        try {
            this.join(timeout);
        }
        catch (InterruptedException ie) {
            return;
        }
    }

    public String getResponse() {
        return this.response;
    }

    public Exception getException() {
        return this.exception;
    }
}

