/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.model.ConnectionSelector;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DefaultConnectionEditorLauncher
extends DatabaseConnectionEditorLauncher {
    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    protected DatabaseConnections getConnections() {
        return DatabaseConnectionStores.getInstance().getCurrentStore(this.getContext());
    }

    protected String getDefaultSubtype() {
        String[] stringArray;
        Properties properties;
        Object object = null;
        if (this.isAllowedSubType("oraJDBC")) {
            object = "oraJDBC";
        }
        if ((properties = this.getDefaultProperties()) != null && ModelUtil.hasLength((String)(stringArray = properties.getProperty("subtype"))) && this.isAllowedSubType((String)stringArray)) {
            object = stringArray;
        }
        if (object == null && (stringArray = this.getAllowedSubTypes()) != null && stringArray.length > 0) {
            object = stringArray[0];
        }
        return object == null ? null : "oraJDBC";
    }

    protected Traversable createPanel() {
        return new ConnectionEditorPanel();
    }

    protected Component getDefaultFocusComponent(Traversable traversable) {
        return ((ConnectionEditorPanel)traversable).getDefaultFocusComponent();
    }

    protected String getTitle(boolean bl) {
        return bl ? ConnBundle.get("DB_CONN_ED_TITLE") : ConnBundle.get("DB_CONN_CREATE_TITLE");
    }

    protected String getHeaderText(boolean bl) {
        return bl ? ConnBundle.get("DB_CONN_ED_HEADER_TEXT") : ConnBundle.get("DB_CONN_CREATE_HEADER_TEXT");
    }

    protected Icon getHeaderIcon(boolean bl) {
        return null;
    }

    protected void setupNamespace(Namespace namespace) {
    }

    private Properties newConnectionProperties() {
        Properties properties = new Properties();
        properties.put("subtype", this.getDefaultSubtype());
        Properties properties2 = this.getDefaultProperties();
        if (properties2 != null) {
            for (String string : properties2.stringPropertyNames()) {
                properties.setProperty(string, properties2.getProperty(string));
            }
        }
        return properties;
    }

    @Override
    public final ConnectionInfo launchEditor(DatabaseConnections databaseConnections, String string) {
        String string2;
        Traversable traversable = this.createPanel();
        Component component = DBMessageDialog.getDialogParent();
        Component component2 = this.getDefaultFocusComponent(traversable);
        if (databaseConnections == null) {
            databaseConnections = this.getConnections();
        }
        if (databaseConnections == null) {
            throw new IllegalStateException("No DatabaseConnections to create a connection in.");
        }
        Properties properties = null;
        DatabaseProvider databaseProvider = null;
        if (ModelUtil.hasLength((String)string)) {
            try {
                databaseProvider = databaseConnections.getReferenceable(string);
                properties = databaseProvider.getProperties();
            }
            catch (ConnectionException connectionException) {
                MessageDialog.error((Component)component, (Object)connectionException.getMessage(), (String)this.getTitle(true), null);
                return null;
            }
        }
        boolean bl = properties != null;
        String string3 = bl ? string : null;
        boolean bl2 = false;
        if (properties == null) {
            bl2 = true;
            properties = this.newConnectionProperties();
            if (!ModelUtil.hasLength((String)string)) {
                string = DBUtil.getUniqueName(databaseConnections.listConnections(), (String)this.getConnectionBaseName());
            }
        } else {
            string2 = properties.getProperty("subtype");
            boolean bl3 = false;
            if (string2 != null) {
                for (DatabaseConnectionHook.ConnectionType object2 : DatabaseConnectionHook.getHook().getConnectionTypes()) {
                    if (!string2.equals(object2.getSubtype())) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3) {
                properties = this.convertInvalidSubtype(string2, databaseProvider);
            } else if (!this.isAllowedSubType(string2)) {
                throw new IllegalStateException(string2 + " is not supported by this launcher.");
            }
        }
        string2 = new Namespace();
        string2.put(DatabaseConnections.class.getName(), (Object)databaseConnections);
        string2.put("ConnectionNameKey", (Object)string);
        string2.put("ConnectionOrigNameKey", (Object)string3);
        string2.put("NewObject", (Object)properties);
        string2.put(DatabaseConnectionEditorLauncher.class.getName(), (Object)this);
        string2.put(Context.class.getName(), (Object)this.getContext());
        this.setupNamespace((Namespace)string2);
        TDialogLauncher tDialogLauncher = new TDialogLauncher(component, this.getTitle(bl), traversable, (Namespace)string2);
        Icon icon = this.getHeaderIcon(bl);
        String string4 = this.getHeaderText(bl);
        DialogHeader dialogHeader = icon == null ? DefaultConnectionEditorLauncher.createDialogHeader(string4) : DefaultConnectionEditorLauncher.createDialogHeader(string4, icon);
        tDialogLauncher.setDialogHeader(dialogHeader);
        tDialogLauncher.setPackDialog(true);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(component2);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new CommitListener((Namespace)string2));
        jEWTDialog.setName(bl2 ? "CreateDatabaseConnectionDialog" : "EditDatabaseConnectionDialog");
        ConnectionInfo connectionInfo = null;
        if (tDialogLauncher.showDialog()) {
            ConnectionInfo connectionInfo2;
            String string5 = (String)string2.get("ConnectionNameKey");
            DatabaseConnections databaseConnections2 = (DatabaseConnections)string2.get(DatabaseConnections.class);
            try {
                databaseConnections2.saveConnections();
            }
            catch (ConnectionException connectionInfo22) {
                this.getLogger().warning("Couldn't save connection: " + connectionInfo22.getMessage());
            }
            connectionInfo = connectionInfo2 = new ConnectionInfo(databaseConnections2 == null ? null : databaseConnections2.getStoreName(), string5);
            if (!bl && this.getEnsureVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionSelector.selectConnection(connectionInfo2, DefaultConnectionEditorLauncher.this.getContext(), false);
                    }
                });
            }
        }
        return connectionInfo;
    }

    protected Properties convertInvalidSubtype(String string, DatabaseProvider databaseProvider) {
        if (!this.isAllowedSubType("thirdParty")) {
            throw new IllegalStateException("Unknown subtype" + string);
        }
        this.getLogger().severe(string + " is not recognized");
        Properties properties = new Properties();
        for (String string2 : new CustomConnectionCreator().listAllowedProperties()) {
            String string3 = databaseProvider.getProperty(string2);
            if (string3 == null) continue;
            properties.setProperty(string2, string3);
        }
        properties.setProperty("subtype", "thirdParty");
        try {
            properties.setProperty("customUrl", databaseProvider.getConnectionURL());
        }
        catch (SQLException sQLException) {
            this.getLogger().warning(sQLException.getMessage());
        }
        try {
            properties.setProperty("driver", databaseProvider.getDriverClassName());
        }
        catch (SQLException sQLException) {
            this.getLogger().warning(sQLException.getMessage());
        }
        return properties;
    }

    protected void doCommit(DatabaseConnections databaseConnections, String string, String string2, Properties properties, Namespace namespace) throws ConnectionException {
        if (string != null) {
            databaseConnections.updateConnection(string, string2, properties);
        } else {
            boolean bl = this.getEnsureVisible();
            if (bl) {
                ConnectionInfo connectionInfo = new ConnectionInfo(databaseConnections.getStoreName(), null);
                ConnectionSelector.selectConnection(connectionInfo, this.getContext(), false);
            }
            databaseConnections.addConnection(string2, properties);
        }
    }

    public static DialogHeader createDialogHeader(String string) {
        return DefaultConnectionEditorLauncher.createDialogHeader(string, OracleIcons.getIcon((String)"header/dbconn_lg_qualifier.png"));
    }

    private static DialogHeader createDialogHeader(String string, Icon icon) {
        return new DialogHeader(string, OracleIcons.toImage((Icon)icon));
    }

    private class CommitListener
    implements VetoableChangeListener {
        private Namespace data;

        private CommitListener(Namespace namespace) {
            this.data = namespace;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                String string = (String)this.data.get("ConnectionNameKey");
                Properties properties = (Properties)this.data.get("NewObject");
                DatabaseConnections databaseConnections = (DatabaseConnections)this.data.get(DatabaseConnections.class);
                String string2 = (String)this.data.get("ConnectionOrigNameKey");
                try {
                    DefaultConnectionEditorLauncher.this.doCommit(databaseConnections, string2, string, properties, this.data);
                }
                catch (ConnectionException connectionException) {
                    MessageDialog.error((Component)DBMessageDialog.getDialogParent(), (Object)connectionException.getMessage(), (String)DefaultConnectionEditorLauncher.this.getTitle(string2 != null), null);
                    throw new PropertyVetoException(connectionException.getMessage(), propertyChangeEvent);
                }
            }
        }
    }
}

