/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;

public class ConnectionPanelUI
extends AbstractConnectionPanelUI {
    private static final String LAST_CONNECTION_KEY = "ConnectionPanelUI.LAST_CONNECTION_KEY";
    private final String m_storeName;
    private DefaultComboBoxModel m_connectionsModel;
    private JComboBox m_connections;

    public ConnectionPanelUI(boolean bl) {
        this(false, bl);
    }

    public ConnectionPanelUI(boolean bl, boolean bl2) {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, bl2);
    }

    public ConnectionPanelUI(String[] stringArray, boolean bl) {
        this("IdeConnections", stringArray, bl);
    }

    public ConnectionPanelUI(String string, String[] stringArray, boolean bl) {
        super(stringArray, bl);
        this.m_storeName = string;
    }

    @Override
    protected String getComponentNamePrefix() {
        return "ConnectionPanelUI";
    }

    @Override
    protected JComboBox getPicker() {
        this.m_connectionsModel = new NonNullableComboBoxModel();
        return new JComboBox(this.m_connectionsModel);
    }

    public String getConnectionName() {
        String string = null;
        if (this.m_connectionsModel != null && ModelUtil.areEqual((Object)(string = (String)this.m_connectionsModel.getSelectedItem()), (Object)this.getNoConnectionString())) {
            string = null;
        }
        return string;
    }

    public boolean setConnectionName(String string) {
        boolean bl;
        this.initialise();
        boolean bl2 = bl = this.m_connectionsModel.getIndexOf(string) != -1;
        if (bl && ModelUtil.areDifferent((Object)this.m_connectionsModel.getSelectedItem(), (Object)string)) {
            this.m_connectionsModel.setSelectedItem(string);
        }
        return bl;
    }

    protected DatabaseConnections getConnections() {
        return DatabaseConnectionStores.getInstance().getStore(this.getStoreName());
    }

    protected String getStoreName() {
        return this.m_storeName;
    }

    protected Collection<String> listConnections() {
        DatabaseConnections databaseConnections = this.getConnections();
        return databaseConnections == null ? Collections.emptyList() : databaseConnections.listConnections(this.getSubTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetConnections() {
        this.initialise();
        String string = this.getConnectionName();
        int n = this.m_connectionsModel.getSize();
        Collection<String> collection = this.listConnections();
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        Collections.sort(arrayList);
        String string2 = this.getNoConnectionString();
        if (string2 != null) {
            arrayList.add(0, string2);
        }
        if (this.areDifferent(arrayList, this.m_connectionsModel)) {
            this.setListening(false);
            try {
                this.m_connectionsModel.removeAllElements();
                for (String string3 : arrayList) {
                    this.m_connectionsModel.addElement(string3);
                }
                if (!this.setConnectionName(string)) {
                    this.loadSettings();
                }
            }
            finally {
                this.setListening(true);
            }
            if (n == 0 || ModelUtil.hasLength((String)string) && !string.equals(this.getConnectionName())) {
                this.fireSelectionChanged();
            }
        } else if (arrayList.size() == 0) {
            this.fireSelectionChanged();
        }
        return this.m_connectionsModel.getSize();
    }

    private boolean areDifferent(Collection<String> collection, DefaultComboBoxModel defaultComboBoxModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            arrayList.add((String)defaultComboBoxModel.getElementAt(i));
        }
        Collections.sort(arrayList);
        return !arrayList.equals(collection);
    }

    @Override
    public final ConnectionInfo getConnectionInfo() {
        String string = this.getConnectionName();
        DatabaseConnections databaseConnections = this.getConnections();
        if (databaseConnections != null && ModelUtil.hasLength((String)string)) {
            return new ConnectionInfo(databaseConnections.getStoreName(), string);
        }
        return null;
    }

    @Override
    public final void setConnectionInfo(ConnectionInfo connectionInfo) {
        String string = connectionInfo.getStoreName();
        if (ModelUtil.areEqual((Object)string, (Object)this.getStoreName())) {
            this.setConnectionName(connectionInfo.getConnectionName());
        } else {
            DBLog.getLogger((Object)this).warning("Cannot set connection, store " + string + " is not supported by this picker.");
        }
    }

    protected String getSettingsKey() {
        return LAST_CONNECTION_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    public void loadSettings() {
        String string = this.getSettingsKey();
        if (string != null) {
            String string2 = this.getPropertyStorage().getProperties().getString(string);
            this.setConnectionName(string2);
        }
    }

    public void saveSettings() {
        String string;
        String string2 = this.getSettingsKey();
        if (string2 != null && ModelUtil.hasLength((String)(string = this.getConnectionName()))) {
            this.getPropertyStorage().getProperties().putString(string2, string);
        }
    }

    protected String runConnectionDialog(String string) {
        DatabaseConnectionEditorLauncher databaseConnectionEditorLauncher = this.createDatabaseConnectionEditorLauncher();
        ConnectionInfo connectionInfo = databaseConnectionEditorLauncher.launchEditor(this.getConnections(), string);
        return connectionInfo == null ? null : connectionInfo.getConnectionName();
    }

    protected DatabaseConnectionEditorLauncher createDatabaseConnectionEditorLauncher() {
        DatabaseConnectionEditorLauncher databaseConnectionEditorLauncher = DatabaseConnectionEditor.createLauncher();
        databaseConnectionEditorLauncher.setContext(this.getContext());
        databaseConnectionEditorLauncher.setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.NONE);
        databaseConnectionEditorLauncher.setAllowedSubTypes(this.getSubTypes());
        return databaseConnectionEditorLauncher;
    }

    @Override
    protected void launchConnectionDialog(boolean bl) {
        String string = this.runConnectionDialog(bl ? this.getConnectionName() : null);
        if (this.resetConnections() > 0 && ModelUtil.hasLength((String)string)) {
            this.clearLastShownInfo();
            String string2 = this.getConnectionName();
            if (bl && string.equals(string2)) {
                this.fireSelectionChanged();
            } else {
                this.setConnectionName(string);
            }
            this.checkConnection();
        }
    }

    @Deprecated
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Deprecated
    public JComboBox getConnCombo() {
        return null;
    }

    @Deprecated
    protected boolean getCanAddNull() {
        return false;
    }

    @Deprecated
    public void setCanAddNull(boolean bl) {
    }

    @Deprecated
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static String getConnection(String string, String string2, String string3, boolean bl) {
        ConnectionPanelUI connectionPanelUI = new ConnectionPanelUI(bl, true);
        connectionPanelUI.setConnectionPrompt(string2);
        ConnectionInfo connectionInfo = ConnectionPanelUI.getConnection(connectionPanelUI, string, new ConnectionInfo("IdeConnections", string3));
        return connectionInfo == null ? null : connectionInfo.getConnectionName();
    }
}

