/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ide.Context;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.panels.GlobalConnectionPanelUI;

public class GlobalDatabaseConnPanel
extends DefaultTraversablePanel {
    public static final String CHOSEN_CONNECTION_NAME = "CHOSEN_DB_CONN_NAME";
    public static final String CHOSEN_STORE_NAME = "CHOSEN_DB_STORE_NAME";
    private GlobalConnectionPanelUI m_connUI;
    private TraversableContext m_traversableContext;
    private boolean m_enforceValidChoice = true;
    private boolean m_canFinish = true;
    private boolean m_showDetails = true;

    public GlobalDatabaseConnPanel() {
        this.layoutComponents();
    }

    public GlobalDatabaseConnPanel(boolean bl) {
        this.m_showDetails = bl;
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.m_connUI = this.createConnectionUI();
        this.m_connUI.addComboListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectionInfo connectionInfo = GlobalDatabaseConnPanel.this.m_connUI.getConnectionInfo();
                GlobalDatabaseConnPanel.this.enableExit(connectionInfo != null && connectionInfo.isValid());
            }
        });
        this.add(this.m_connUI);
    }

    public final void setEnforceSelection(boolean bl) {
        this.m_enforceValidChoice = bl;
    }

    public final void setCanFinish(boolean bl) {
        this.m_canFinish = bl;
    }

    protected GlobalConnectionPanelUI createConnectionUI() {
        return new GlobalConnectionPanelUI(null, this.m_showDetails);
    }

    public final void onEntry(TraversableContext traversableContext) {
        this.m_traversableContext = traversableContext;
        this.initPanel(traversableContext);
    }

    protected GlobalConnectionPanelUI getConnUI() {
        return this.m_connUI;
    }

    protected void initPanel(TraversableContext traversableContext) {
        this.m_connUI.setContext((Context)traversableContext.find(Context.class));
        this.m_connUI.setConnectionInfo(this.getConnectionInfo(traversableContext));
        ConnectionInfo connectionInfo = this.m_connUI.getConnectionInfo();
        this.enableExit(connectionInfo != null && connectionInfo.isValid());
    }

    protected ConnectionInfo getConnectionInfo(TraversableContext traversableContext) {
        return ConnectionInfo.getConnectionInfo(traversableContext.getPropertyStorage());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    protected void enableExit(boolean bl) {
        if (this.m_traversableContext != null && this.m_enforceValidChoice) {
            DialogCallbacks dialogCallbacks;
            WizardCallbacks wizardCallbacks = this.m_traversableContext.getWizardCallbacks();
            if (wizardCallbacks != null) {
                wizardCallbacks.wizardEnableButtons(null, Boolean.valueOf(bl), this.m_canFinish ? null : Boolean.valueOf(false));
            }
            if ((dialogCallbacks = this.m_traversableContext.getDialogCallbacks()) != null) {
                dialogCallbacks.enableOKButton(bl);
            }
        }
    }
}

