/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.net.URL;
import java.util.Hashtable;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;

public class DefaultContextWrapper
implements DatabaseContextManager.ContextWrapper {
    private static final String INITIAL_CONTEXT_FACTORY = "oracle.adf.share.jndi.InitialContextFactoryImpl";
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";
    private static final String DB_RESCAT_EXT_ID = "oracle.jdeveloper.db.rescat";
    private static DefaultContextWrapper s_instance;
    private AdfJndiContext m_context;
    private final URL m_url;
    private final ReferenceWorker m_worker;

    public static DefaultContextWrapper getInstance() {
        if (s_instance == null) {
            DefaultContextWrapper defaultContextWrapper;
            Object object;
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            if (extensionRegistry.findMinimalExtension(DB_RESCAT_EXT_ID) != null) {
                DefaultContextWrapper.getLogger().severe("DefaultContextWrapper.getInstance() should not be called in FCP if rescat is available.");
            } else {
                object = ProductInformation.getProductID();
                boolean bl = extensionRegistry.isFullyLoaded((String)object);
                if (!bl) {
                    DefaultContextWrapper.getLogger().severe("Connections should not be initialised before " + (String)object + " is loaded.");
                }
            }
            object = extensionRegistry.getSystemDirectory("oracle.jdeveloper.db.connection");
            URL uRL = URLFactory.newURL((URL)object, (String)CONNECTIONS_FILE_NAME);
            if (!URLFileSystem.exists((URL)object)) {
                URLFileSystem.mkdirs((URL)uRL);
            }
            s_instance = defaultContextWrapper = new DefaultContextWrapper(uRL, DefaultContextWrapper.getSystemKey());
            DatabaseProviderHelper.setDefaultWorker((ReferenceWorker)defaultContextWrapper.getReferenceWorker());
        }
        return s_instance;
    }

    public DefaultContextWrapper(URL uRL, String string) {
        this(uRL, DefaultContextWrapper.createDefaultWorker(string));
    }

    DefaultContextWrapper(URL uRL, ReferenceWorker referenceWorker) {
        this.m_url = uRL;
        this.m_worker = referenceWorker;
    }

    @Override
    public Context getDatabaseContext() {
        if (this.m_context == null && this.m_url != null) {
            try {
                this.m_context = DefaultContextWrapper.newContext(this.m_url, this.m_worker);
            }
            catch (NamingException namingException) {
                String string = "Failed to create naming Context for db connections at url: " + this.m_url.toExternalForm();
                DefaultContextWrapper.getLogger().log(Level.FINE, string, namingException);
            }
        }
        return this.m_context;
    }

    @Override
    public void saveDatabaseContext() throws NamingException {
        if (this.m_context != null) {
            this.m_context.save();
        }
    }

    public ReferenceWorker getReferenceWorker() {
        return this.m_worker;
    }

    private static String generateNewKey() {
        return UUID.randomUUID().toString();
    }

    private static String getSystemKey() {
        String string;
        if (!Ide.isRunning() || ExtensionRegistry.getExtensionRegistry().findMinimalExtension(DB_RESCAT_EXT_ID) != null) {
            String string2 = System.getProperty("db.junit.system.id");
            if (string2 == null) {
                DefaultContextWrapper.getLogger().fine("No system key for FCP with rescat - a credential store is used.");
                string = null;
            } else {
                string = string2;
            }
        } else {
            HashStructure hashStructure = Preferences.getPreferences().getProperties();
            string = hashStructure.getString("db.system.id");
            if (string == null) {
                string = DefaultContextWrapper.generateNewKey();
                hashStructure.putString("db.system.id", string);
            }
        }
        return string;
    }

    private static ReferenceWorker createDefaultWorker(String string) {
        ReferenceWorker referenceWorker = ModelUtil.hasLength((String)string) ? ReferenceWorker.createDefaultWorker((String)string) : ReferenceWorker.createNullWorker();
        return referenceWorker;
    }

    private static AdfJndiContext newContext(URL uRL, ReferenceWorker referenceWorker) throws NamingException {
        long l = System.currentTimeMillis();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = uRL.getPath();
        hashtable.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        hashtable.put("java.naming.provider.url", string);
        if (referenceWorker != null) {
            hashtable.put(ReferenceWorker.KEY, (String)referenceWorker);
        }
        AdfInitialContext adfInitialContext = AdfInitialContext.newAdfInitialContext(hashtable, DefaultContextWrapper.class);
        DefaultContextWrapper.getLogger().log(Level.FINE, "Creating AdfJndiContext at {0} took {1}ms", new Object[]{string, System.currentTimeMillis() - l});
        return adfInitialContext;
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DefaultContextWrapper.class);
    }

    public static DefaultContextWrapper createLegacyWrapper(URL uRL) {
        return new DefaultContextWrapper(uRL, ReferenceWorker.createLegacyWorker());
    }

    public static DefaultContextWrapper createSystemWrapper(URL uRL) {
        return new DefaultContextWrapper(uRL, DefaultContextWrapper.getSystemKey());
    }
}

