/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import oracle.ide.migration.Migrator;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBMigrator
implements Migrator {
    protected static final String OLD_ONLINEDB_EXT = "oracle.onlinedb";
    protected static final String J2EE_EXT = "oracle.j2ee";
    private boolean m_selected;

    public String getDescription(int n) {
        return null;
    }

    public int[] getMigrationCategories() {
        return new int[69];
    }

    public boolean isSelected(int n) {
        return this.m_selected;
    }

    public void setSelected(int n, boolean bl) {
        this.m_selected = bl;
    }

    protected abstract String getExtensionID();

    protected File findExtensionFile(File file, String string) {
        return this.findExtensionFile(file, null, string);
    }

    protected File findExtensionFile(File file, String[] stringArray, String string) {
        File file2 = new File(file, string);
        if (file2.exists() && file2.canRead()) {
            return file2;
        }
        if (file.getName().startsWith(this.getExtensionID())) {
            file = file.getParentFile();
        }
        if ((file2 = this.searchForFile(file, this.getExtensionID(), string)) != null) {
            return file2;
        }
        if (ModelUtil.hasNonNullElement((Object[])stringArray)) {
            return this.findOldExtensionFile(file, stringArray, string);
        }
        return null;
    }

    protected File findOldExtensionFile(File file, String[] stringArray, String string) {
        if (file.getName().startsWith(this.getExtensionID())) {
            file = file.getParentFile();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = this.searchForFile(file, stringArray[i], string);
                if (file2 == null) continue;
                return file2;
            }
        }
        return null;
    }

    protected File searchForFile(File file, final String string, String string2) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.startsWith(string);
            }
        });
        if (fileArray != null) {
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return file2.getName().compareTo(file.getName());
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                File file2;
                if (!fileArray[i].isDirectory() || !(file2 = new File(fileArray[i], string2)).exists() || !file2.canRead()) continue;
                return file2;
            }
        }
        return null;
    }

    protected static final Logger getLogger() {
        return DBLog.getAndInitialiseLogger((String)"oracle.jdeveloper.db.migration");
    }
}

