/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.naming.Referenceable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdeveloper.db.migration.ConnectionsInfo;
import oracle.jdevimpl.db.migration.AbstractDBMigrator;

public class ConnectionMigrator
extends AbstractDBMigrator {
    private static final String CM_CONNECTIONS_FILE = "IDEConnections.xml";
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";
    private static URL s_migrationURL;
    private static boolean s_cmMigration;

    @Override
    protected String getExtensionID() {
        return "oracle.jdeveloper.db.connection";
    }

    public String[] migrate(File file, File file2) {
        String[] stringArray = new String[]{};
        File file3 = this.getConnectionsFile(file);
        if (file3 == null) {
            file3 = this.getOldConnectionsFile(file);
        }
        if (file3 != null) {
            URL uRL = URLFactory.newFileURL((File)file3);
            try {
                ConnectionsInfo connectionsInfo = ConnectionsInfo.getConnectionsInfo(uRL);
                if (!(connectionsInfo.isLegacyCMFormat() || !connectionsInfo.requiresPassphrase() && connectionsInfo.containsPasswords())) {
                    URL uRL2 = URLFactory.newURL((URL)URLFactory.newDirURL((File)file2), (String)CONNECTIONS_FILE_NAME);
                    try {
                        URLFileSystem.copy((URL)uRL, (URL)uRL2);
                    }
                    catch (IOException iOException) {
                        stringArray = new String[]{"Connection migration failed: " + iOException.getMessage()};
                    }
                } else if (s_migrationURL == null) {
                    s_migrationURL = uRL;
                    s_cmMigration = connectionsInfo.isLegacyCMFormat();
                } else {
                    ConnectionMigrator.getLogger().severe("Migration URL already exists, cannot replace!");
                }
            }
            catch (ConnectionException connectionException) {
                stringArray = new String[]{connectionException.getMessage()};
            }
        }
        return stringArray;
    }

    public boolean canMigrate(int n, File file) {
        return this.getConnectionsFile(file) != null || this.getOldConnectionsFile(file) != null;
    }

    private File getConnectionsFile(File file) {
        return this.findExtensionFile(file, CONNECTIONS_FILE_NAME);
    }

    private File getOldConnectionsFile(File file) {
        return this.findExtensionFile(file, new String[]{"oracle.onlinedb", "oracle.j2ee"}, CM_CONNECTIONS_FILE);
    }

    public static void finishMigration(DatabaseConnections databaseConnections) {
        if (s_migrationURL != null) {
            Object object;
            if (s_cmMigration) {
                object = new CMConnectionsReader(s_migrationURL.getFile(), true);
                Map<String, Referenceable> map = ((CMConnectionsReader)object).getMigratedConnections();
                for (Map.Entry<String, Referenceable> entry : map.entrySet()) {
                    String string = entry.getKey();
                    try {
                        databaseConnections.addConnection(string, ((DatabaseProvider)entry.getValue()).getProperties());
                    }
                    catch (ConnectionException connectionException) {
                        ConnectionMigrator.getLogger().severe("Migration of " + string + " failed: " + connectionException.getMessage());
                    }
                }
            } else {
                object = DatabaseConnections.getPrivateInstance(s_migrationURL, null);
                for (String string : ((DatabaseConnections)object).listConnections()) {
                    try {
                        Properties properties = ((DatabaseConnections)object).getProperties(string);
                        databaseConnections.addConnection(string, properties);
                    }
                    catch (ConnectionException connectionException) {
                        ConnectionMigrator.getLogger().severe("Migration of " + string + " failed: " + connectionException.getMessage());
                    }
                }
            }
            try {
                databaseConnections.saveConnections();
            }
            catch (ConnectionException connectionException) {
                ConnectionMigrator.getLogger().severe("Connection migration failed: " + connectionException.getMessage());
            }
        }
        s_migrationURL = null;
    }
}

