/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.WholeNumberField;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class ConnectionComponentCache {
    private final Map<String, JLabel> m_labels = new HashMap<String, JLabel>();
    private final Map<String, JTextComponent> m_components = new HashMap<String, JTextComponent>();
    private final DBUIResourceHelper m_resourceHelper;
    private final String m_subType;
    private final DatabaseConnectionHook.ConnectionType m_connType;
    private final String m_panelName;

    public ConnectionComponentCache(String string, String string2) {
        this.m_resourceHelper = new DBUIResourceHelper(string2);
        this.m_subType = string;
        this.m_panelName = string2;
        DatabaseConnectionHook.ConnectionType connectionType = null;
        for (DatabaseConnectionHook.ConnectionType connectionType2 : DatabaseConnectionHook.getHook().getConnectionTypes()) {
            if (!string.equals(connectionType2.getSubtype())) continue;
            connectionType = connectionType2;
            break;
        }
        if (connectionType == null) {
            throw new IllegalArgumentException(string + " is not a valid subtype");
        }
        this.m_connType = connectionType;
    }

    protected final void registerTextComponent(String string, JLabel jLabel, JTextComponent jTextComponent, String string2) {
        this.registerTextComponent(string, jLabel, jTextComponent, this.getPropertyLabelText(string), string2);
    }

    protected final void registerTextComponent(String string, JLabel jLabel, JTextComponent jTextComponent, String string2, String string3) {
        if (this.m_components.containsKey(string)) {
            throw new IllegalStateException("Cannot register a property more than once");
        }
        this.m_components.put(string, jTextComponent);
        if (jLabel != null) {
            this.getResourceHelper().resLabel(jLabel, (Component)jTextComponent, string2, string3);
            this.m_labels.put(string, jLabel);
        }
    }

    protected final String getPropertyLabelText(String string) {
        return this.m_connType.getPropertyLabelText(string);
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_resourceHelper;
    }

    protected final String getPanelName() {
        return this.m_panelName;
    }

    protected final DatabaseConnectionHook.ConnectionType getConnectionType() {
        return this.m_connType;
    }

    protected final ConnectionCreator getConnectionCreator() {
        return this.m_connType.getConnectionCreator();
    }

    protected final String getConnectionSubType() {
        return this.m_subType;
    }

    protected String getDefaultValue(String string) {
        String string2 = null;
        if ("hostname".equals(string)) {
            string2 = "localhost";
        }
        return string2;
    }

    protected void populateConnectionDetails(Properties properties) {
        for (Map.Entry<String, JTextComponent> entry : this.m_components.entrySet()) {
            String string = entry.getKey();
            entry.getValue().setText(properties.getProperty(string, this.getDefaultValue(string)));
        }
    }

    protected final void setEnabled(String string, boolean bl) {
        this.setEnabled(this.m_components.get(string), bl);
        this.setEnabled(this.m_labels.get(string), bl);
    }

    private void setEnabled(Component component, boolean bl) {
        if (component != null) {
            component.setEnabled(bl);
        }
    }

    protected final void setVisible(String string, boolean bl) {
        this.setVisible(this.m_components.get(string), bl);
        this.setVisible(this.m_labels.get(string), bl);
    }

    private void setVisible(Component component, boolean bl) {
        if (component != null) {
            component.setVisible(bl);
        }
    }

    protected void commitConnectionDetails(Properties properties) {
        for (Map.Entry<String, JTextComponent> entry : this.m_components.entrySet()) {
            String string = entry.getKey();
            String string2 = this.getTrimmedText(entry.getValue());
            this.setProperty(properties, string, string2);
        }
    }

    protected Collection<String> getRegisteredProperties() {
        return this.m_components.keySet();
    }

    protected final String getTrimmedText(JTextComponent jTextComponent) {
        Number number;
        String string = jTextComponent instanceof NumberTextField ? ((number = ((NumberTextField)jTextComponent).getNumber()) == null ? null : number.toString()) : this.trimIfNotNull(jTextComponent.getText());
        return string;
    }

    protected final String trimIfNotNull(String string) {
        if (string != null) {
            string = string.trim();
        }
        return ModelUtil.nullifyIfEmpty((String)string);
    }

    protected final void setProperty(Properties properties, String string, String string2) {
        if (ModelUtil.hasLength((String)string2)) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
    }

    protected static NumberTextField newPortField() {
        return new WholeNumberField(6);
    }
}

