/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.resource.ConnBundle;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class ConnectionEditorPanel
extends DefaultTraversablePanel {
    public static final String CONNECTION_NAME_KEY = "ConnectionNameKey";
    public static final String CONNECTION_ORIG_NAME_KEY = "ConnectionOrigNameKey";
    private JPanel m_headerPanel = new JPanel(new GridBagLayout());
    private JPanel m_customPanelContainer = new JPanel(new BorderLayout());
    private JLabel m_connNameLbl = new JLabel();
    private JLabel m_connTypeLbl = new JLabel();
    private JLabel m_usernameLbl = new JLabel();
    private JLabel m_passwordLbl = new JLabel();
    private JLabel m_roleLbl = new JLabel();
    private JTextField m_connNameFld = new JTextField();
    private DefaultComboBoxModel m_connTypeListModel = new NonNullableComboBoxModel();
    private JComboBox m_connTypeCmb = new JComboBox(this.m_connTypeListModel);
    private ItemListener m_connTypeListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ConnectionEditorPanel.this.commitConnectionType();
            ConnectionEditorPanel.this.updateUI(ConnectionEditorPanel.this.getSelectedConnectionType());
        }
    };
    private JTextField m_usernameFld = new JTextField();
    private JComboBox m_roleCmb = new JComboBox(new DefaultComboBoxModel());
    private JTextField m_roleFld = new JTextField();
    private List<String> m_preSetRoleList;
    private JPasswordField m_passwordPwd = new JPasswordField();
    private JCheckBox m_savePasswordChk = new JCheckBox();
    private Traversable m_customConnTypeSubPanel;
    private Properties m_connectionProps = null;
    private TraversableContext m_dataContext;
    private boolean m_errorOnEntry;
    private ReadOnlyScrollPane m_feedback = new ReadOnlyScrollPane();
    private JButton m_testBut = new JButton();
    private DatabaseConnections m_connectionsInstance;
    private List<DatabaseConnectionHook.ConnectionType> m_connectionTypes = DatabaseConnectionHook.getHook().getConnectionTypes();

    public ConnectionEditorPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "layout error", exception);
        }
    }

    private void layoutComponents() {
        ResourceUtils.resLabel((JLabel)this.m_connNameLbl, (Component)this.m_connNameFld, (String)ConnBundle.get("CONNECTION_NAME_LABEL"));
        ResourceUtils.resLabel((JLabel)this.m_connTypeLbl, (Component)this.m_connTypeCmb, (String)(ConnPropsBundle.get("subtype") + ":"));
        ResourceUtils.resLabel((JLabel)this.m_usernameLbl, (Component)this.m_usernameFld, (String)(ConnPropsBundle.get("user") + ":"));
        ResourceUtils.resLabel((JLabel)this.m_passwordLbl, (Component)this.m_passwordPwd, (String)(ConnPropsBundle.get("password") + ":"));
        ResourceUtils.resButton((AbstractButton)this.m_savePasswordChk, (String)ConnBundle.get("CONNECTION_SAVE_PASSWORD_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_testBut, (String)ConnBundle.get("CONNECTION_TEST_LABEL"));
        this.m_feedback.getAccessibleContext().setAccessibleName(ConnBundle.get("DB_CONN_TEST_RESULTS"));
        this.m_connNameFld.setName("ConnectionEditorPanel.ConnectionName");
        this.m_connTypeCmb.setName("ConnectionEditorPanel.ConnectionType");
        this.m_usernameFld.setName("ConnectionEditorPanel.Username");
        this.m_passwordPwd.setName("ConnectionEditorPanel.Password");
        this.m_roleCmb.setName("ConnectionEditorPanel.Role");
        this.m_roleFld.setName("ConnectionEditorPanel.Role");
        this.m_savePasswordChk.setName("ConnectionEditorPanel.SavePassword");
        this.m_testBut.setName("ConnectionEditorPanel.Test");
        this.m_feedback.getTextArea().setName("ConnectionEditorPanel.TestResults");
        this.populateTypeCombo(null);
        this.setLayout(new GridBagLayout());
        this.add(this.m_headerPanel, this.gbc(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0)));
        this.add(this.m_customPanelContainer, this.gbc(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(15, 0, 0, 0)));
        this.m_testBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionEditorPanel.this.testConnection();
            }
        });
        this.add(this.m_testBut, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0)));
        this.add((Component)this.m_feedback, this.gbc(0, 3, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0)));
        this.add(Box.createVerticalStrut(60), this.gbc(3, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0)));
        this.setHelpID("f1_dbconnection_html");
    }

    private void populateTypeCombo(String[] stringArray) {
        this.m_connTypeCmb.removeItemListener(this.m_connTypeListener);
        List<String> list = stringArray == null ? null : Arrays.asList(stringArray);
        this.m_connTypeListModel.removeAllElements();
        for (DatabaseConnectionHook.ConnectionType connectionType : this.m_connectionTypes) {
            if (list != null && !list.contains(connectionType.getSubtype())) continue;
            this.m_connTypeListModel.addElement(connectionType);
        }
        this.m_connTypeCmb.addItemListener(this.m_connTypeListener);
        if (stringArray != null && this.m_connTypeListModel.getSize() == 0) {
            this.populateTypeCombo(null);
        }
    }

    private DatabaseConnectionHook.ConnectionType getSelectedConnectionType() {
        return (DatabaseConnectionHook.ConnectionType)this.m_connTypeCmb.getSelectedItem();
    }

    private DatabaseConnectionHook.ConnectionType findConnectionType(String string) {
        DatabaseConnectionHook.ConnectionType connectionType = null;
        for (DatabaseConnectionHook.ConnectionType connectionType2 : this.m_connectionTypes) {
            if (!ModelUtil.areEqual((Object)string, (Object)connectionType2.getSubtype())) continue;
            connectionType = connectionType2;
            break;
        }
        return connectionType;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_connectionProps = (Properties)traversableContext.get("NewObject");
        this.m_connectionsInstance = (DatabaseConnections)traversableContext.get(DatabaseConnections.class);
        String string = (String)traversableContext.get(CONNECTION_NAME_KEY);
        DatabaseConnectionEditorLauncher databaseConnectionEditorLauncher = (DatabaseConnectionEditorLauncher)traversableContext.find(DatabaseConnectionEditorLauncher.class);
        this.populateTypeCombo(databaseConnectionEditorLauncher == null ? null : databaseConnectionEditorLauncher.getAllowedSubTypes());
        if (ModelUtil.hasLength((String)string)) {
            this.m_connNameFld.setText(string);
            boolean bl = true;
            if (traversableContext.get(CONNECTION_ORIG_NAME_KEY) != null) {
                bl = databaseConnectionEditorLauncher != null && databaseConnectionEditorLauncher.getAllowRename();
            }
            this.m_connNameFld.setEditable(bl);
            String string2 = (String)this.m_connectionProps.get("subtype");
            DatabaseConnectionHook.ConnectionType connectionType = this.findConnectionType(string2);
            this.m_connTypeCmb.removeItemListener(this.m_connTypeListener);
            this.m_connTypeCmb.setSelectedItem(connectionType);
            this.m_connTypeCmb.addItemListener(this.m_connTypeListener);
            this.m_dataContext = traversableContext;
            this.m_connNameFld.setEnabled(true);
            this.m_connTypeCmb.setEnabled(true);
        }
        this.initialiseUI();
        this.m_connNameFld.requestFocusInWindow();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit();
        if (!this.m_errorOnEntry) {
            this.m_customConnTypeSubPanel.onExit(this.m_dataContext);
        }
    }

    private void initialiseUI() {
        this.m_headerPanel.removeAll();
        this.m_customPanelContainer.removeAll();
        DatabaseConnectionHook.ConnectionType connectionType = this.getSelectedConnectionType();
        this.m_headerPanel.add((Component)this.m_connNameLbl, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connNameFld, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connTypeLbl, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connTypeCmb, this.gbc(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
        if (this.m_connectionProps != null) {
            this.addUserNamePasswordPanel(connectionType, false);
            this.addCustomPanel(connectionType);
        } else {
            this.m_connNameFld.setEnabled(false);
            this.m_connNameFld.setText("");
            this.m_connTypeCmb.setEnabled(false);
        }
        this.updateTestConnection(connectionType);
        this.validateAndPack();
    }

    private void addCustomPanel(DatabaseConnectionHook.ConnectionType connectionType) {
        Serializable serializable;
        this.m_customConnTypeSubPanel = null;
        try {
            serializable = connectionType.getPanelClass();
            this.m_customConnTypeSubPanel = ((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Failed to instantiate panel", exception);
        }
        if (this.m_customConnTypeSubPanel != null) {
            serializable = new StringBuilder(" ");
            ((StringBuilder)serializable).append(ConnBundle.format("CONNECTION_TYPE_BORDER_TITLE", this.getSelectedConnectionType().getDisplayName()));
            ((StringBuilder)serializable).append(" ");
            MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(matteBorder, ((StringBuilder)serializable).toString());
            this.m_customPanelContainer.setBorder(titledBorder);
            this.m_customPanelContainer.add(Box.createHorizontalStrut(540), "North");
            this.m_customPanelContainer.add(this.m_customConnTypeSubPanel.getComponent(), "Center");
            try {
                this.m_customConnTypeSubPanel.onEntry(this.m_dataContext);
                this.m_errorOnEntry = false;
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Error entering connection panel.", exception);
                this.m_errorOnEntry = true;
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                JTextArea jTextArea = new JTextArea(stringWriter.getBuffer().toString());
                jTextArea.setEditable(false);
                this.m_customPanelContainer.add((Component)new JScrollPane(jTextArea), "Center");
            }
        }
    }

    private void validateAndPack() {
        this.validate();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)this));
        if (window != null) {
            window.pack();
        }
        this.repaint();
    }

    private void testConnection() {
        try {
            this.onExit(this.m_dataContext);
            this.m_feedback.setText(ConnBundle.get("CONNECTION_TEST_WORKING"), false);
            ConnectionTester connectionTester = new ConnectionTester(this.m_connNameFld.getText());
            connectionTester.testConnection(this.m_connectionsInstance, this.m_connectionProps);
        }
        catch (TraversalException traversalException) {
            this.m_feedback.setText(traversalException.getMessage(), true);
        }
    }

    private void commit() throws MissingDBConnValueException {
        Object object;
        ConnectionCreator connectionCreator;
        Collection collection;
        MissingDBConnValueException.check(this.m_connNameFld.getText(), this.m_connNameLbl);
        this.m_dataContext.put(CONNECTION_NAME_KEY, (Object)this.m_connNameFld.getText());
        DatabaseConnectionHook.ConnectionType connectionType = this.getSelectedConnectionType();
        String string = connectionType.getSubtype();
        if (ModelUtil.areDifferent((Object)string, (Object)this.m_connectionProps.getProperty("subtype"))) {
            this.commitConnectionType();
        }
        if ((collection = (connectionCreator = connectionType.getConnectionCreator()).listAllowedProperties()).contains("user")) {
            if (connectionCreator.listRequiredProperties().contains("user")) {
                MissingDBConnValueException.check(this.m_usernameFld.getText(), this.m_usernameLbl);
            }
            this.m_connectionProps.remove("user");
            this.m_connectionProps.put("user", this.m_usernameFld.getText());
        }
        if (collection.contains("role")) {
            this.m_connectionProps.remove("role");
            object = null;
            object = this.m_preSetRoleList == null ? (Object)this.m_roleFld.getText() : (this.m_roleCmb.isEditable() ? (Object)((String)this.m_roleCmb.getEditor().getItem()) : (Object)((String)this.m_roleCmb.getSelectedItem()));
            if (ModelUtil.hasLength((String)object)) {
                this.m_connectionProps.put("role", object);
            }
        }
        if (collection.contains("password")) {
            this.m_connectionProps.remove("password");
            object = this.m_passwordPwd.getPassword();
            if (object != null && ((char[])object).length > 0) {
                this.m_connectionProps.put("password", new String((char[])object));
            }
            this.m_connectionProps.remove("SavePassword");
            if (!this.m_savePasswordChk.isSelected()) {
                this.m_connectionProps.put("SavePassword", Boolean.FALSE.toString());
            }
        }
    }

    private void commitConnectionType() {
        String string = this.getSelectedConnectionType().getSubtype();
        String string2 = (String)this.m_connectionProps.get("user");
        String string3 = (String)this.m_connectionProps.get("password");
        this.m_connectionProps.clear();
        this.m_connectionProps.put("subtype", string);
        if (string2 != null) {
            this.m_connectionProps.put("user", string2);
        }
        if (string3 != null) {
            this.m_connectionProps.put("password", string3);
        }
    }

    private void addUserNamePasswordPanel(DatabaseConnectionHook.ConnectionType connectionType, boolean bl) {
        Object object;
        int n;
        Object object2;
        boolean bl2 = false;
        if (bl) {
            object2 = this.m_headerPanel.getComponents();
            n = this.m_headerPanel.getComponentCount();
            while (--n >= 0) {
                if (object2[n] == this.m_connNameFld || object2[n] == this.m_connNameLbl || object2[n] == this.m_connTypeCmb || object2[n] == this.m_connTypeLbl) continue;
                this.m_headerPanel.remove(n);
            }
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new GridBagLayout());
        n = 1;
        Collection collection = connectionType.getConnectionCreator().listAllowedProperties();
        if (collection.contains("user")) {
            this.m_usernameFld.setText((String)this.m_connectionProps.get("user"));
            this.m_headerPanel.add((Component)this.m_usernameLbl, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0)));
            ((Container)object2).add((Component)this.m_usernameFld, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
        }
        if (collection.contains("password")) {
            this.m_passwordPwd.setText((String)this.m_connectionProps.get("password"));
            this.m_headerPanel.add((Component)this.m_passwordLbl, this.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0)));
            ((Container)object2).add((Component)this.m_passwordPwd, this.gbc(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
            n = 2;
            object = new JPanel(new GridBagLayout());
            String string = (String)this.m_connectionProps.get("SavePassword");
            ((Container)object).add((Component)this.m_savePasswordChk, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
            bl2 = true;
            boolean bl3 = string == null ? true : Boolean.valueOf(string);
            this.m_savePasswordChk.setSelected(bl3);
            ((Container)object).add(Box.createHorizontalGlue(), this.gbc(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
            this.m_headerPanel.add((Component)object, this.gbc(2, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 24, 0, 5)));
        }
        this.m_headerPanel.add((Component)object2, this.gbc(1, 3, 1, n, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
        if (collection.contains("role")) {
            this.m_preSetRoleList = connectionType.getPresetRoles();
            object = (String)this.m_connectionProps.get("role");
            this.m_headerPanel.add((Component)this.m_roleLbl, this.gbc(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0)));
            GridBagConstraints gridBagConstraints = this.gbc(3, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 5));
            String string = ConnPropsBundle.get("role") + ":";
            if (this.m_preSetRoleList == null) {
                this.m_headerPanel.add((Component)this.m_roleFld, gridBagConstraints);
                ResourceUtils.resLabel((JLabel)this.m_roleLbl, (Component)this.m_roleFld, (String)string);
                this.m_roleFld.setText((String)object);
            } else {
                this.m_headerPanel.add((Component)this.m_roleCmb, gridBagConstraints);
                ResourceUtils.resLabel((JLabel)this.m_roleLbl, (Component)this.m_roleCmb, (String)string);
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.m_roleCmb.getModel();
                defaultComboBoxModel.removeAllElements();
                defaultComboBoxModel.addElement("");
                for (String string2 : this.m_preSetRoleList) {
                    defaultComboBoxModel.addElement(string2);
                }
                boolean bl4 = connectionType.allowAnyRole();
                this.m_roleCmb.setEditable(bl4);
                if (bl4) {
                    this.m_roleCmb.getEditor().setItem(object);
                } else {
                    this.m_roleCmb.setSelectedItem(object);
                }
            }
        }
    }

    private void updateTestConnection(DatabaseConnectionHook.ConnectionType connectionType) {
        boolean bl = connectionType.showTestConnection();
        this.m_testBut.setVisible(bl);
        this.m_feedback.setVisible(bl);
        this.m_feedback.setText("", false);
    }

    private void updateUI(DatabaseConnectionHook.ConnectionType connectionType) {
        this.updateTestConnection(connectionType);
        this.addUserNamePasswordPanel(connectionType, true);
        this.m_customPanelContainer.removeAll();
        this.addCustomPanel(connectionType);
        this.validateAndPack();
    }

    public Component getDefaultFocusComponent() {
        return this.m_connNameFld;
    }

    private class ConnectionTester
    extends ProgressRunnable {
        private DatabaseConnections m_connectionsInstance;
        private Properties m_connectionProperties;
        private String m_message = null;

        public ConnectionTester(String string) {
            this.setTitle(ConnBundle.get("TITLE_CONNECTING"));
            this.setMessage(ConnBundle.format("MESSAGE_CONNECTING", string));
        }

        protected Object doWork() throws ConnectionException {
            this.m_connectionsInstance.testConnection(this.m_connectionProperties, new DatabaseConnections.DatabaseConnectionTester(){

                @Override
                public void testConnection(Connection connection) throws ConnectionException {
                    String string;
                    DatabaseMetaData databaseMetaData;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(ConnBundle.get("CONNECTION_TEST_SUCCESS")).append("\n");
                    try {
                        databaseMetaData = connection.getMetaData();
                        string = databaseMetaData.getDatabaseProductName();
                        String string2 = databaseMetaData.getDatabaseProductVersion();
                        stringBuilder.append(ConnBundle.get("CONNECTION_TEST_CONNECTED")).append(" ");
                        if (!string2.contains(string)) {
                            stringBuilder.append(string).append(" ");
                        }
                        stringBuilder.append(string2);
                    }
                    catch (SQLException sQLException) {
                        stringBuilder.append(sQLException.getMessage());
                    }
                    stringBuilder.append("\n");
                    try {
                        databaseMetaData = DatabaseFactory.createStandaloneDatabase((String)ConnectionEditorPanel.this.m_connNameFld.getText(), (Connection)connection);
                        string = databaseMetaData.getDescriptor().getDatabaseName();
                        stringBuilder.append(ConnBundle.get("CONNECTION_TEST_RECOGN_AS")).append(" ").append(string);
                    }
                    catch (DBException dBException) {
                        stringBuilder.append(dBException.getMessage());
                    }
                    ConnectionTester.this.m_message = stringBuilder.toString();
                }
            });
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void testConnection(DatabaseConnections databaseConnections, Properties properties) {
            this.m_connectionsInstance = databaseConnections;
            this.m_connectionProperties = new Properties();
            this.m_connectionProperties.putAll((Map<?, ?>)properties);
            this.m_connectionProperties.setProperty("SavePassword", Boolean.TRUE.toString());
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException progressException) {
                Exception exception = (Exception)progressException.getCause();
                while (exception instanceof DBException) {
                    Throwable throwable = exception.getCause();
                    if (throwable == null || !(throwable instanceof Exception)) continue;
                    exception = (Exception)throwable;
                }
                this.m_message = exception.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionEditorPanel.this.m_feedback.setText(ConnectionTester.this.m_message, true);
                    }
                });
            }
            catch (Exception exception2) {
                this.m_message = exception2.getMessage();
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected void doCancel() {
            super.doCancel();
            this.m_message = ConnBundle.get("CONNECTION_TEST_CANCELLED");
        }
    }
}

