/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.panels.AbstractConnectionDetailsPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class OraclePanel
extends AbstractConnectionDetailsPanel {
    private final String[] ORA_DRIVER_TYPES = new String[]{"thin", "oci8"};
    private final JComboBox m_cmbDriver = new JComboBox();
    private final JTextField m_fldHost = new JTextField();
    private final NumberTextField m_fldPort = OraclePanel.newPortField();
    private final JTextField m_fldSid = new JTextField();
    private final JTextField m_fldServiceName = new JTextField();
    private final JRadioButton m_rdbSidSelector = new JRadioButton();
    private final JRadioButton m_rdbServiceNameSelector = new JRadioButton();
    private final ButtonGroup m_rbgSelectorGroup = new ButtonGroup();

    public OraclePanel() {
        super("oraJDBC", "OraclePanel");
    }

    @Override
    protected JPanel createDetailsPanel(DBUIResourceHelper dBUIResourceHelper) {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        jLabel4.setVisible(false);
        JLabel jLabel5 = new JLabel();
        jLabel5.setVisible(false);
        dBUIResourceHelper.resLabel(jLabel, (Component)this.m_cmbDriver, this.getPropertyLabelText("oraDriverType"), "Driver");
        this.registerTextComponent("hostname", jLabel2, this.m_fldHost, "Host");
        this.registerTextComponent("port", jLabel3, (JTextComponent)this.m_fldPort, "Port");
        dBUIResourceHelper.resLabel(jLabel4, (Component)this.m_fldSid, ConnBundle.get("OTP_SID_VALUE"), "SIDValue");
        dBUIResourceHelper.resLabel(jLabel5, (Component)this.m_fldServiceName, ConnBundle.get("OTP_SERVICENAME_VALUE"), "ServiceNameValue");
        this.m_rdbSidSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OraclePanel.this.enableControls();
                OraclePanel.this.m_fldSid.requestFocus();
            }
        });
        dBUIResourceHelper.resButton((AbstractButton)this.m_rdbSidSelector, this.getPropertyLabelText("sid"), "SID");
        this.m_rdbSidSelector.setSelected(true);
        dBUIResourceHelper.resButton((AbstractButton)this.m_rdbServiceNameSelector, this.getPropertyLabelText("serviceName"), "ServiceName");
        this.m_rdbServiceNameSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OraclePanel.this.enableControls();
                OraclePanel.this.m_fldServiceName.requestFocus();
            }
        });
        this.m_rbgSelectorGroup.add(this.m_rdbSidSelector);
        this.m_rbgSelectorGroup.add(this.m_rdbServiceNameSelector);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.ORA_DRIVER_TYPES[0]);
        defaultComboBoxModel.addElement(this.ORA_DRIVER_TYPES[1]);
        this.m_cmbDriver.setModel(defaultComboBoxModel);
        JPanel jPanel = new JPanel();
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel);
        dBUILayoutHelper.add((Component)jLabel, 2, 1);
        dBUILayoutHelper.add((Component)this.m_cmbDriver);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add((Component)jLabel2, 2, 1);
        dBUILayoutHelper.add((Component)this.m_fldHost);
        dBUILayoutHelper.add((Component)jLabel3);
        dBUILayoutHelper.add((Component)this.m_fldPort, 1, 1, false, false);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add((Component)this.m_rdbSidSelector);
        dBUILayoutHelper.add((Component)jLabel4);
        dBUILayoutHelper.add((Component)this.m_fldSid);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add((Component)this.m_rdbServiceNameSelector);
        dBUILayoutHelper.add((Component)jLabel5);
        dBUILayoutHelper.add((Component)this.m_fldServiceName);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
        this.enableControls();
        return jPanel;
    }

    @Override
    protected String getDefaultValue(String string) {
        String string2 = "port".equals(string) ? "1521" : super.getDefaultValue(string);
        return string2;
    }

    @Override
    protected void populateConnectionDetails(Properties properties) {
        super.populateConnectionDetails(properties);
        String string = properties.getProperty("sid");
        String string2 = properties.getProperty("serviceName");
        if (string2 != null && string == null) {
            this.m_rdbServiceNameSelector.setSelected(true);
        } else {
            this.m_rdbSidSelector.setSelected(true);
        }
        if (string == null && string2 == null) {
            string = "XE";
            string2 = "XE";
        }
        this.m_fldSid.setText(string);
        this.m_fldServiceName.setText(string2);
        String string3 = properties.getProperty("oraDriverType");
        if (string3 == null) {
            string3 = this.ORA_DRIVER_TYPES[0];
        }
        this.m_cmbDriver.setSelectedItem(string3);
        this.enableControls();
    }

    @Override
    protected void commitConnectionDetails(Properties properties, boolean bl) {
        super.commitConnectionDetails(properties, bl);
        properties.remove("oraDriverType");
        properties.remove("sid");
        properties.remove("serviceName");
        if (!bl) {
            int n = this.m_cmbDriver.getSelectedIndex();
            if (n < 0) {
                n = 0;
            }
            properties.setProperty("oraDriverType", this.ORA_DRIVER_TYPES[n]);
            if (this.m_rdbSidSelector.isSelected()) {
                this.setProperty(properties, "sid", this.getTrimmedText(this.m_fldSid));
            } else {
                this.setProperty(properties, "serviceName", this.getTrimmedText(this.m_fldServiceName));
            }
        }
    }

    @Override
    protected void validateConnectionDetails(Properties properties, boolean bl) throws TraversalException {
        super.validateConnectionDetails(properties, bl);
        if (!bl) {
            if (this.m_rdbSidSelector.isSelected()) {
                MissingDBConnValueException.check(properties.getProperty("sid"), this.m_rdbSidSelector);
            } else {
                MissingDBConnValueException.check(properties.getProperty("serviceName"), this.m_rdbServiceNameSelector);
            }
        }
    }

    private void enableControls() {
        if (this.m_rdbSidSelector.isSelected()) {
            this.m_fldSid.setEnabled(true);
            this.m_fldServiceName.setEnabled(false);
        } else {
            this.m_fldSid.setEnabled(false);
            this.m_fldServiceName.setEnabled(true);
        }
    }
}

