/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.dnd.JFCSupport;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.LWComponent;

class DnDUtils {
    private static Class _sJComponent;
    private static Class _sJPanel;
    private static Class _sJRootPaneContainer;
    private static final int _SOLARIS_OS = 1;
    private static final int _MAC_OS = 2;
    private static final int _WINDOWS_OS = 3;
    private static int _sOSVariant;

    DnDUtils() {
    }

    public static DropTarget getEWTDropTarget(Component component) {
        if (component != null) {
            if (component instanceof LWComponent) {
                return ((LWComponent)component).getEWTDropTarget();
            }
            if (_sJComponent != null && _sJComponent.isInstance(component)) {
                return JFCSupport.getEWTDropTarget((JComponent)component);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintImmediate(Component component, int n, int n2, int n3, int n4) {
        if (component instanceof ImmediatePainter) {
            ((ImmediatePainter)((Object)component)).paintImmediateUnclipped(n, n2, n3, n4);
        } else if (_sJComponent != null && _sJComponent.isInstance(component)) {
            try {
                JFCSupport.__paintImmediately(component, n, n2, n3, n4);
            }
            catch (Throwable throwable) {}
        } else if (_sJRootPaneContainer != null && _sJRootPaneContainer.isInstance(component)) {
            try {
                JFCSupport.__rootPaint(component, n, n2, n3, n4);
            }
            catch (Throwable throwable) {}
        } else {
            Graphics graphics = component.getGraphics();
            try {
                graphics.clipRect(n, n2, n3, n4);
                component.update(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public static void setEWTDropTarget(Component component, DropTarget dropTarget) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component instanceof LWComponent) {
            ((LWComponent)component).setEWTDropTarget(dropTarget);
        } else if (_sJComponent != null && _sJComponent.isInstance(component)) {
            JFCSupport.setEWTDropTarget((JComponent)component, dropTarget);
        } else {
            throw new IllegalArgumentException("Illegal component type");
        }
    }

    public static Component getTopmostParent(Component component, Point point) {
        Container container;
        int n = point.x;
        int n2 = point.y;
        while (!(component instanceof Window) && component != null && component.isLightweight() && (container = component.getParent()) != null) {
            Point point2 = component.getLocation();
            n += point2.x;
            n2 += point2.y;
            component = container;
        }
        point.x = n;
        point.y = n2;
        return component;
    }

    public static Component getTargetComponentOutside(Component component, Point point) {
        Component component2 = DnDUtils.getTopmostParent(component, point);
        return DnDUtils.getTargetComponent(component2, point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getTargetComponent(Component component, Point point) {
        Component component2 = null;
        if (component instanceof MouseGrabProvider) {
            component2 = ((MouseGrabProvider)((Object)component)).getProxyComponent();
        }
        int n = point.x;
        int n2 = point.y;
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = container.getTreeLock();
            synchronized (object) {
                int n3 = container.getComponentCount();
                for (int i = 0; i < n3; ++i) {
                    Object object2;
                    Component component3 = container.getComponent(i);
                    if (!component3.isVisible() || component3.getClass() == _sJPanel && (object2 = component3.getName()) != null && ((String)object2).indexOf("glass") != -1 || component3 == component2) continue;
                    object2 = component3.getLocation();
                    int n4 = n - ((Point)object2).x;
                    int n5 = n2 - ((Point)object2).y;
                    if (!component3.contains(n4, n5)) continue;
                    point.x = n4;
                    point.y = n5;
                    return DnDUtils.getTargetComponent(component3, point);
                }
            }
        }
        return component;
    }

    public static int getDefaultActions(int n) {
        int n2 = 3;
        switch (DnDUtils._getOS()) {
            case 1: 
            case 3: {
                if ((n & 2) == 0) break;
                n2 = 1;
                break;
            }
            case 2: {
                if ((n & 8) == 0) break;
                n2 = 1;
            }
        }
        return n2;
    }

    private static int _getOS() {
        int n = _sOSVariant;
        if (n == 0) {
            n = 3;
            String string = null;
            try {
                string = System.getProperty("os.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null) {
                if (string.startsWith("Solaris")) {
                    n = 1;
                } else if (string.startsWith("Mac")) {
                    n = 2;
                }
            }
            _sOSVariant = n;
        }
        return n;
    }

    static {
        try {
            _sJComponent = Class.forName("javax.swing.JComponent");
            _sJPanel = Class.forName("javax.swing.JPanel");
            _sJRootPaneContainer = Class.forName("javax.swing.RootPaneContainer");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

