/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.InputEventUtils;

public class TextFieldInputHandler
extends CellInputHandler {
    boolean _dirty;
    private static TextFieldInputHandler _sInputHandler;
    private LWTextField _textField;
    private boolean _textInitedOnKeyTyped;

    public final LWTextField getLWTextField() {
        return (LWTextField)this.getEditControl(null, -1, -1);
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        Cell cell = grid.getFocusCell();
        if (cell.column == n && cell.row == n2 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
        LWTextField lWTextField = this.getLWTextField();
        if (lWTextField.isEditable()) {
            if (keyEvent.getKeyChar() == '\b') {
                lWTextField.setText("");
                this._dirty = true;
            } else {
                lWTextField.setText(String.valueOf(keyEvent.getKeyChar()));
                lWTextField.select(1, 1);
                this._dirty = true;
            }
            this._textInitedOnKeyTyped = true;
        }
        keyEvent.consume();
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._textField == null) {
            this._textField = new LWTextField(){

                protected void processFocusEvent(FocusEvent focusEvent) {
                    super.processFocusEvent(focusEvent);
                    if (TextFieldInputHandler.this._textInitedOnKeyTyped) {
                        this.select(1, 1);
                    }
                    TextFieldInputHandler.this._textInitedOnKeyTyped = false;
                }
            };
            this._textField.addTextListener(new Dirty());
            this._textField.setBorderPainter(new FixedBorderPainter(0, 2, 0, 0));
        }
        return this._textField;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        if (!this._textInitedOnKeyTyped) {
            LWTextField lWTextField = this.getLWTextField();
            lWTextField.setText((String)object);
            if (object != null) {
                lWTextField.selectAll();
            }
            this._dirty = false;
        }
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        LWTextField lWTextField = this.getLWTextField();
        String string = lWTextField.getText();
        return string;
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = TextFieldInputHandler.createTextFieldInputHandler();
        }
        return _sInputHandler;
    }

    public static TextFieldInputHandler createTextFieldInputHandler() {
        return new TextFieldInputHandler();
    }

    protected TextFieldInputHandler() {
    }

    private class Dirty
    implements TextListener {
        private Dirty() {
        }

        public void textValueChanged(TextEvent textEvent) {
            TextFieldInputHandler.this._dirty = true;
        }
    }
}

