/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;

public class GradientPainter
extends AbstractPainter {
    private Color _startColor;
    private Color _endColor;
    private boolean _vertical;
    private boolean _twoWay;
    private Image _gradient;

    public GradientPainter(Color color, Color color2) {
        this._startColor = color;
        this._endColor = color2;
    }

    public boolean isVertical() {
        return this._vertical;
    }

    public synchronized void setVertical(boolean bl) {
        if (this._vertical != bl) {
            this._vertical = bl;
            this._gradient = null;
        }
    }

    public boolean isTwoWay() {
        return this._twoWay;
    }

    public void setTwoWay(boolean bl) {
        this._twoWay = bl;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        int n;
        int n2 = this._startColor.getRed() - this._endColor.getRed();
        int n3 = this._startColor.getGreen() - this._endColor.getGreen();
        int n4 = this._startColor.getBlue() - this._endColor.getBlue();
        if (n2 < 0) {
            n2 *= -1;
        }
        if (n3 < 0) {
            n3 *= -1;
        }
        if (n4 < 0) {
            n4 *= -1;
        }
        if (n3 > (n = n2)) {
            n = n3;
        }
        if (n4 > n) {
            n = n4;
        }
        n >>= 8;
        if (this.isTwoWay()) {
            n += n;
        }
        return new Dimension(n, n);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Image image = this._getGradient();
        ImageObserver imageObserver = paintContext.getImageObserver();
        if (this.isTwoWay()) {
            int n5 = image.getWidth(imageObserver);
            int n6 = image.getHeight(imageObserver);
            if (this.isVertical()) {
                int n7 = n3 / 2;
                graphics.drawImage(image, n, n2, n7, n4, imageObserver);
                graphics.drawImage(image, n3, n2, n7, n4, n, n2, n5, n6, imageObserver);
            } else {
                int n8 = n4 / 2;
                graphics.drawImage(image, n, n2, n3, n8, imageObserver);
                graphics.drawImage(image, n, n4, n3, n8, n, n2, n5, n6, imageObserver);
            }
        } else {
            graphics.drawImage(image, n, n2, n3, n4, imageObserver);
        }
    }

    public boolean isTransparent(PaintContext paintContext) {
        return false;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image _getGradient() {
        Image image = this._gradient;
        if (image != null) {
            return image;
        }
        GradientPainter gradientPainter = this;
        synchronized (gradientPainter) {
            if (image != null) {
                return image;
            }
            int n = this._startColor.getRed();
            int n2 = this._startColor.getBlue();
            int n3 = this._startColor.getGreen();
            int n4 = this._endColor.getRed();
            int n5 = this._endColor.getBlue();
            int n6 = this._endColor.getGreen();
            int n7 = Math.max(Math.abs(n - n4), Math.max(Math.abs(n2 - n5), Math.abs(n3 - n6)));
            if (n7 == 0) {
                n7 = 1;
            }
            byte[] byArray = new byte[n7 + 1];
            byte[] byArray2 = new byte[n7 + 1];
            byte[] byArray3 = new byte[n7 + 1];
            n4 -= n;
            n5 -= n2;
            n6 -= n3;
            for (int i = 0; i <= n7; ++i) {
                byArray[i] = (byte)(n + n4 * i / n7);
                byArray2[i] = (byte)(n2 + n5 * i / n7);
                byArray3[i] = (byte)(n3 + n6 * i / n7);
            }
            byte[] byArray4 = new byte[n7 + 1];
            for (int i = 0; i <= n7; ++i) {
                byArray4[i] = (byte)i;
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, n7 + 1, byArray, byArray3, byArray2);
            MemoryImageSource memoryImageSource = this.isVertical() ? new MemoryImageSource(n7 + 1, 1, (ColorModel)indexColorModel, byArray4, 0, n7 + 1) : new MemoryImageSource(1, n7 + 1, (ColorModel)indexColorModel, byArray4, 0, 1);
            this._gradient = image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
            return image;
        }
    }
}

