/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Dimension;
import oracle.ewt.painter.Painter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarPainterItem;

public class ToolBarSeparator
extends ToolBarPainterItem {
    private boolean _useVisibleSeparator;

    public ToolBarSeparator() {
    }

    public ToolBarSeparator(boolean bl) {
        this._useVisibleSeparator = bl;
    }

    public void setSize(int n) {
        ToolBar toolBar = this.getParent();
        int n2 = n;
        int n3 = n;
        if (toolBar != null) {
            Dimension dimension = toolBar.getInnerSize();
            if (toolBar.isHorizontal()) {
                n3 = dimension.height;
            } else {
                n2 = dimension.width;
            }
        }
        super.setSize(n2, n3);
    }

    public int getSeparatorSize() {
        return this._getMaxSize();
    }

    public Dimension getMinimumSize() {
        ToolBar toolBar = this.getParent();
        Dimension dimension = super.getMinimumSize();
        if (toolBar != null) {
            Dimension dimension2 = toolBar.getInnerSize();
            if (toolBar.isHorizontal()) {
                dimension.height = dimension2.height;
            } else {
                dimension.width = dimension2.width;
            }
            return dimension;
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected Painter getPainter() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            return toolBar.getToolBarUI().getSeparatorPainter(toolBar, this._useVisibleSeparator);
        }
        return null;
    }

    private int _getMaxSize() {
        Dimension dimension = this.getSize();
        if (dimension.width > dimension.height) {
            return dimension.width;
        }
        return dimension.height;
    }
}

