/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;

public abstract class AbstractHover
implements Hover {
    private final List<HoverListener> listeners = new CopyOnWriteArrayList<HoverListener>();
    private final HoverFlavor flavor;

    public AbstractHover(HoverFlavor flavor) {
        this.flavor = flavor;
    }

    @Override
    public void showHover() {
        HoverEvent he = new HoverEvent(this, HoverEvent.Type.WILL_SHOW);
        for (HoverListener l : this.listeners) {
            l.hoverChange(he);
        }
    }

    @Override
    public void hideHover() {
        HoverEvent he = new HoverEvent(this, HoverEvent.Type.HIDDEN);
        for (HoverListener l : this.listeners) {
            l.hoverChange(he);
        }
    }

    @Override
    public HoverFlavor getFlavor() {
        return this.flavor;
    }

    @Override
    public void addHoverListener(HoverListener hoverListener) {
        if (!this.listeners.contains(hoverListener)) {
            this.listeners.add(hoverListener);
        }
    }

    @Override
    public void removeHoverListener(HoverListener hoverListener) {
        this.listeners.remove(hoverListener);
    }

    @Override
    public boolean shouldHideHover(KeyEvent event) {
        return true;
    }

    protected void fireHoverEvent(HoverEvent hoverEvent) {
        for (HoverListener l : this.listeners) {
            l.hoverChange(hoverEvent);
        }
    }
}

