/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;

public abstract class DBTypeDisplayRegistryEntry {
    private Map<String, TypeEntry> m_typeEntries;

    protected final TypeEntry getEntry(String string) {
        this.checkInit();
        return this.m_typeEntries.get(string);
    }

    public void registerType(String string, String string2, String string3, String string4, Icon icon, Icon icon2) {
        this.m_typeEntries.put(string, new TypeEntry(string2, string3, string4, icon, icon2));
    }

    public void registerType(String string, String string2, String string3, String string4, String string5) {
        this.registerType(string, string2, string3, string4, null, string5);
    }

    public void registerType(String string, String string2, String string3, String string4, String string5, String string6) {
        this.m_typeEntries.put(string, new TypeEntry(string2, string3, string4, string5, string6));
    }

    private void checkInit() {
        if (this.m_typeEntries == null) {
            this.m_typeEntries = new HashMap<String, TypeEntry>();
            this.populateEntries();
        }
    }

    protected abstract void populateEntries();

    public String getDisplayName(String string) {
        TypeEntry typeEntry = this.getEntry(string);
        String string2 = null;
        if (typeEntry != null) {
            string2 = typeEntry.getDisplayName();
        }
        return string2;
    }

    public String getSingularDisplayName(String string) {
        TypeEntry typeEntry = this.getEntry(string);
        String string2 = null;
        if (typeEntry != null) {
            string2 = typeEntry.getSingularDisplayName();
        }
        return string2;
    }

    public Icon getNodeIcon(String string) {
        TypeEntry typeEntry = this.getEntry(string);
        return typeEntry == null ? null : typeEntry.getNodeIcon();
    }

    public Icon getFolderIcon(String string) {
        TypeEntry typeEntry = this.getEntry(string);
        return typeEntry == null ? null : typeEntry.getFolderIcon();
    }

    public String getNewMenuItemText(String string) {
        TypeEntry typeEntry = this.getEntry(string);
        return typeEntry == null ? null : typeEntry.getNewMenuItemText();
    }

    private static class TypeEntry {
        private final String m_displayName;
        private final String m_singularDisplayName;
        private final String m_newMenuText;
        private Icon m_folderIcon;
        private String m_folderIconKey;
        private Icon m_nodeIcon;
        private String m_nodeIconKey;

        protected TypeEntry(String string, String string2, String string3, Icon icon, Icon icon2) {
            this.m_displayName = string;
            this.m_singularDisplayName = string2;
            this.m_folderIcon = icon;
            this.m_nodeIcon = icon2;
            this.m_newMenuText = string3;
        }

        protected TypeEntry(String string, String string2, String string3, String string4, String string5) {
            this.m_displayName = string;
            this.m_singularDisplayName = string2;
            this.m_folderIconKey = string4;
            this.m_nodeIconKey = string5;
            this.m_newMenuText = string3;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getSingularDisplayName() {
            return this.m_singularDisplayName;
        }

        public String getNewMenuItemText() {
            return this.m_newMenuText;
        }

        private Icon getFromOracleIcons(String string, Icon icon, String string2) {
            if (string != null) {
                try {
                    return OracleIcons.getIcon((String)string);
                }
                catch (OracleIcons.IconNotFoundException iconNotFoundException) {
                    DBLog.getLogger((Object)this).log(Level.WARNING, "{0} {1} not found in OracleIcons", new Object[]{string2, string});
                }
            }
            return icon;
        }

        public Icon getFolderIcon() {
            return this.getFromOracleIcons(this.m_folderIconKey, this.m_folderIcon, "Folder Icon");
        }

        public Icon getNodeIcon() {
            return this.getFromOracleIcons(this.m_nodeIconKey, this.m_nodeIcon, "Node Icon");
        }
    }
}

