/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;

public final class DBURLFactory {
    private static List<Helper> s_helpers;

    private DBURLFactory() {
    }

    @Deprecated
    public static void registerHelper(Helper helper) {
        DBURLFactory.registerTemporaryHelper(helper);
    }

    public static synchronized void registerTemporaryHelper(Helper helper) {
        if (s_helpers == null) {
            s_helpers = new ArrayList<Helper>();
        }
        s_helpers.add(0, helper);
    }

    public static synchronized void removeHelper(Helper helper) {
        if (s_helpers != null) {
            s_helpers.remove(helper);
            if (s_helpers.isEmpty()) {
                s_helpers = null;
            }
        }
    }

    private static Iterable<Helper> getHelpers(String string) {
        DatabaseExtensionHook databaseExtensionHook = DatabaseExtensionHook.getHook();
        Collection<Helper> collection = null;
        if (databaseExtensionHook == null) {
            collection = s_helpers;
        } else {
            collection = databaseExtensionHook.getURLFactoryHelpers(string);
            if (s_helpers != null) {
                collection.addAll(s_helpers);
            }
        }
        return collection == null ? Collections.emptyList() : collection;
    }

    public static URL getURL(DBObjectProvider dBObjectProvider, SystemObject systemObject) {
        URL uRL = null;
        if (dBObjectProvider != null && systemObject != null && systemObject.getName() != null) {
            for (Helper helper : DBURLFactory.getHelpers(dBObjectProvider.getProviderType())) {
                try {
                    if (!(helper instanceof URLHelper ? (uRL = ((URLHelper)helper).createURL(dBObjectProvider, systemObject)) != null : systemObject instanceof SchemaObject && (uRL = helper.createURL(dBObjectProvider, (SchemaObject)systemObject, null)) != null)) continue;
                    break;
                }
                catch (Exception exception) {
                    DBURLFactory.logHelperFailure(helper, exception);
                }
            }
        }
        return uRL;
    }

    public static URL getURL(DBObjectProvider dBObjectProvider) {
        URL uRL = null;
        for (Helper helper : DBURLFactory.getHelpers(dBObjectProvider.getProviderType())) {
            try {
                if (!(helper instanceof URLHelper) || (uRL = ((URLHelper)helper).createProviderURL(dBObjectProvider)) == null) continue;
                break;
            }
            catch (Exception exception) {
                DBURLFactory.logHelperFailure(helper, exception);
            }
        }
        return uRL;
    }

    public static URL getURL(DBObjectProviderID dBObjectProviderID) {
        URL uRL = null;
        for (Helper helper : DBURLFactory.getHelpers(dBObjectProviderID.getType())) {
            try {
                if (!(helper instanceof URLHelper) || (uRL = ((URLHelper)helper).createProviderURL(dBObjectProviderID)) == null) continue;
                break;
            }
            catch (Exception exception) {
                DBURLFactory.logHelperFailure(helper, exception);
            }
        }
        return uRL;
    }

    private static void logHelperFailure(Helper helper, Exception exception) {
        DBLog.getLogger(DBURLFactory.class).log(DBLog.getExceptionLogLevel(), helper.getClass() + " failure: " + exception.getMessage(), exception);
    }

    @Deprecated
    public static URL getURL(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, String string) {
        return DBURLFactory.getURL(dBObjectProvider, (SystemObject)schemaObject);
    }

    public static abstract class URLHelper
    implements Helper {
        public abstract URL createURL(DBObjectProvider var1, SystemObject var2);

        public URL createProviderURL(DBObjectProvider dBObjectProvider) {
            return dBObjectProvider == null ? null : this.createProviderURL(new DBObjectProviderID(dBObjectProvider));
        }

        public abstract URL createProviderURL(DBObjectProviderID var1);

        @Override
        @Deprecated
        public final boolean canCreateURL(DBObjectProvider dBObjectProvider) {
            return true;
        }

        @Override
        @Deprecated
        public final URL createURL(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, String string) {
            return this.createURL(dBObjectProvider, (SystemObject)schemaObject);
        }
    }

    @Deprecated
    public static interface Helper {
        public boolean canCreateURL(DBObjectProvider var1);

        public URL createURL(DBObjectProvider var1, SchemaObject var2, String var3);
    }
}

