/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public final class DBObjectChooser
extends JPanel
implements ListCellRenderer {
    private static WeakReference<Database> s_lastDBRef;
    private final List<Tuple<ChangeListener, Boolean>> m_listeners = new CopyOnWriteArrayList<Tuple<ChangeListener, Boolean>>();
    private final Map<DBObjectID, List<DBObjectID>> m_contextToIDListMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, DBObjectID> m_textToIDMap = Collections.synchronizedMap(new HashMap());
    private final Set<DBObjectID> m_extraIDs = Collections.synchronizedSet(new DBObjectIDSet(true));
    private final DBObjectProviderPicker.PickerConfiguration m_pickerConfig = new DBObjectProviderPicker.PickerConfiguration();
    private final DBUIResourceHelper m_helper = new DBUIResourceHelper("ComboChooserDelegate");
    private final DBObjectProviderListener m_proListener = new ProviderListener();
    private String[] m_types;
    private Table m_expandFKOwner;
    private DBObjectProvider m_destProv;
    private DBObjectProvider m_srcProv;
    private Boolean m_showIcon;
    private String m_nullText;
    private DBObjectChooser m_child;
    private DBObjectChooser m_parent;
    private DBObjectID m_contextID;
    private DBObjectID m_id;
    private Boolean m_enabled;
    private Boolean m_editable;
    private boolean m_childObjects = false;
    private boolean m_schemaObjects = false;
    private boolean m_nonSchemaSystemObjects = false;
    private boolean m_typeSupported = true;
    private boolean m_onlyReferenceIdNeeded = false;
    private boolean m_listening = true;
    private boolean m_isTextTyped = false;
    private DBObjectFilter m_filter = null;
    private CustomJComboBox m_cmb;
    private JButton m_butt;
    private ActionListener m_listener = null;
    private boolean m_subsetLoaded = false;
    private boolean m_showDBLinkButton = false;
    private DBObjectID m_databaseLinkID = null;
    private boolean m_isDatabaseLinkChooser = false;
    private JButton m_addButton;
    private JButton m_editButton;
    private boolean m_showEditButton = false;
    private boolean m_showAddButton = false;
    private NewObjectProcessor m_addObjectProcessor;
    private DBObjectCriteria<SystemObject> m_criteria;
    private DBObjectLister m_lister;
    private DBObjectCriteria<SystemObject> m_listCriteria;

    public DBObjectChooser(String ... stringArray) {
        this((DBObjectChooser)null, stringArray);
    }

    public DBObjectChooser(DBObjectChooser dBObjectChooser, String ... stringArray) {
        this(dBObjectChooser, (DBObjectLister)null, (DBObjectCriteria<SystemObject>)null, stringArray);
    }

    public DBObjectChooser(DBObjectChooser dBObjectChooser, DBObjectLister dBObjectLister, DBObjectCriteria<SystemObject> dBObjectCriteria, String ... stringArray) {
        for (String string : stringArray) {
            Class clazz = Metadata.getInstance().getObjectClass(string);
            if (Index.class == clazz) {
                this.m_childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clazz)) {
                this.m_schemaObjects = true;
                continue;
            }
            if (ChildDBObject.class.isAssignableFrom(clazz)) {
                this.m_childObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clazz)) continue;
            this.m_nonSchemaSystemObjects = true;
        }
        if ((this.m_childObjects ? 1 : 0) + (this.m_schemaObjects ? 1 : 0) + (this.m_nonSchemaSystemObjects ? 1 : 0) != 1) {
            throw new IllegalArgumentException("Incompatible list of types");
        }
        if (dBObjectLister != null || dBObjectCriteria != null) {
            if (dBObjectLister == null || dBObjectCriteria == null) {
                throw new IllegalArgumentException("both lister and criteria must be null or not null");
            }
            this.m_lister = dBObjectLister;
            this.m_listCriteria = dBObjectCriteria;
        }
        this.m_parent = dBObjectChooser;
        if (this.m_parent != null) {
            this.m_parent.m_child = this;
        }
        this.m_types = stringArray;
        this.setLayout(new GridBagLayout());
    }

    public final void setShowIcon(boolean bl) {
        this.m_showIcon = bl;
    }

    public final void setNullText(String string) {
        this.m_nullText = string;
    }

    public DBObjectCriteria<SystemObject> getDBObjectCriteria() {
        return this.m_criteria;
    }

    public final void addIDToList(DBObjectID dBObjectID) {
        this.m_extraIDs.add(dBObjectID);
    }

    public void setShowDBLinkButton(boolean bl) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowDBLinkButton() before setProvider()");
        }
        if (bl && (this.m_types.length != 1 || !this.m_types[0].equals("SCHEMA"))) {
            throw new IllegalStateException("DB Link button only allowed for Schema choser");
        }
        this.m_showDBLinkButton = bl;
    }

    public void setExpandFKInRenderer(boolean bl, Table table) {
        this.m_expandFKOwner = table;
    }

    public void setShowAddButton(boolean bl) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowAddButton() before setProvider()");
        }
        this.m_showAddButton = bl;
    }

    public void setAddButtonProcessor(NewObjectProcessor newObjectProcessor) {
        this.m_addObjectProcessor = newObjectProcessor;
    }

    public void setShowEditButton(boolean bl) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowEditButton() before setProvider()");
        }
        this.m_showEditButton = bl;
    }

    public final void setProvider(DBObjectProvider dBObjectProvider) {
        if (this.m_child != null) {
            this.m_child.setProvider(dBObjectProvider);
        }
        this.m_destProv = dBObjectProvider;
        this.setSourceProvider(dBObjectProvider);
        if (this.m_cmb == null) {
            if (this.m_showIcon == null) {
                this.m_showIcon = this.m_types.length > 1;
            }
            this.initialiseUI();
            this.buildMaintainID();
            this.setDelegateName();
            this.setEnabled(this.isEnabled());
            if (this.m_editable != null) {
                this.m_cmb.setEditable(this.m_editable);
            }
        }
    }

    public final void enableProviderListener(boolean bl) {
        if (this.m_destProv == null) {
            throw new IllegalStateException("Cannot call enableProviderListener() before setProvider()");
        }
        if (this.m_srcProv == null) {
            return;
        }
        this.m_srcProv.removeProviderListener(this.m_proListener);
        if (bl) {
            this.m_srcProv.addProviderListener(this.m_proListener);
        }
    }

    public final void resetCaches() {
        this.m_textToIDMap.clear();
        this.m_contextToIDListMap.clear();
        if (this.m_cmb != null) {
            this.m_cmb.reset();
        }
    }

    public final void cancel() {
        if (this.m_cmb != null) {
            this.m_cmb.cancel();
        }
    }

    public final void setActive(boolean bl, boolean bl2, boolean bl3) {
        if (this.m_cmb != null) {
            if (bl) {
                if (bl3) {
                    this.resetCaches();
                }
            } else {
                this.cancel();
            }
            if (bl2) {
                this.enableProviderListener(bl);
            }
        }
    }

    public final void setContextDBObjectID(DBObjectID dBObjectID) {
        this.m_contextID = dBObjectID;
        if (this.m_cmb != null) {
            this.contextChanged();
        }
    }

    public final DBObjectID getDBObjectID() {
        Object object;
        DBObjectID dBObjectID = this.m_id;
        if (this.m_cmb != null && this.m_cmb.isEditable() && this.m_cmb.getEditor() != null && (object = this.m_cmb.getEditor().getItem()) instanceof String) {
            dBObjectID = this.getIDFromString((String)object);
        }
        return this.fixProvider(dBObjectID);
    }

    public final void setDBObjectID(DBObjectID dBObjectID) {
        this.updateID(dBObjectID);
        if (this.m_cmb != null) {
            this.showID();
        }
    }

    public final DBObject getDBObject() {
        DBObject dBObject = null;
        DBObjectID dBObjectID = this.getDBObjectID();
        if (dBObjectID != null) {
            try {
                dBObject = dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return dBObject;
    }

    public final void setDBObject(DBObject dBObject) {
        DBObjectID dBObjectID = null;
        if (dBObject != null && (dBObjectID = dBObject.getID()) == null) {
            dBObjectID = TemporaryObjectID.createID((DBObject)dBObject);
        }
        this.setDBObjectID(dBObjectID);
    }

    @Override
    public final void setName(String string) {
        super.setName(string);
        this.setDelegateName();
    }

    private void setDelegateName() {
        if (this.m_cmb != null) {
            this.m_cmb.setName(this.getName() + "-delegate");
        }
    }

    public String getDelegateName() {
        return this.m_cmb == null ? null : this.m_cmb.getName();
    }

    @Override
    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setEnabledImpl(this.m_cmb, bl);
        this.setEnabledImpl(this.m_butt, bl);
        this.setEnabledImpl(this.m_addButton, bl);
        this.enableEditButton();
    }

    private void setEnabledImpl(Component component, boolean bl) {
        if (component != null) {
            component.setEnabled(bl);
        }
    }

    @Override
    public final boolean isEnabled() {
        if (this.m_cmb != null) {
            return this.m_cmb.isEnabled();
        }
        return this.m_enabled == null ? true : this.m_enabled;
    }

    public final void setEditable(boolean bl) {
        this.m_editable = bl;
        if (this.m_cmb != null) {
            this.m_cmb.setEditable(bl);
        }
    }

    public final boolean isEditable() {
        if (this.m_cmb != null) {
            return this.m_cmb.isEditable();
        }
        return this.m_editable == null ? false : this.m_editable;
    }

    public void setOnlyReferenceIDNeeded(boolean bl) {
        this.m_onlyReferenceIdNeeded = bl;
    }

    public DBObject getOrCreateDBObject() {
        DBObject dBObject = this.getDBObject();
        DBObjectID dBObjectID = this.getDBObjectID();
        if (dBObject == null && dBObjectID instanceof BaseObjectID && dBObjectID.getType().equals("SCHEMA")) {
            dBObject = new Schema(((BaseObjectID)dBObjectID).getName());
        }
        return dBObject;
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.addChangeListener(changeListener, false);
    }

    public final void addChangeListener(ChangeListener changeListener, boolean bl) {
        if (changeListener != null) {
            this.removeChangeListener(changeListener);
            Tuple tuple = new Tuple((Object)changeListener, (Object)bl);
            this.m_listeners.add((Tuple<ChangeListener, Boolean>)tuple);
        }
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            for (Tuple<ChangeListener, Boolean> tuple : this.m_listeners) {
                if (tuple.getFirst() != changeListener) continue;
                this.m_listeners.remove(tuple);
                break;
            }
        }
    }

    public final String[] getTypes() {
        return this.m_types;
    }

    final boolean getShowIcon() {
        return this.m_showIcon == null ? false : this.m_showIcon;
    }

    public void setFilter(DBObjectFilter dBObjectFilter) {
        if (this.m_filter != dBObjectFilter) {
            this.m_filter = dBObjectFilter;
            this.resetCaches();
        }
    }

    public DBObjectFilter getFilter() {
        return this.m_filter;
    }

    private DBObjectChooser getParentChooser() {
        return this.m_parent;
    }

    private DBObjectChooser getChildChooser() {
        return this.m_child;
    }

    private void updateID(DBObjectID dBObjectID) {
        if (dBObjectID != null && !dBObjectID.equals(this.m_id, false) || dBObjectID == null && this.m_id != null) {
            this.m_id = dBObjectID;
            if (this.m_child != null) {
                this.m_child.setContextDBObjectID(dBObjectID);
            }
            for (Tuple<ChangeListener, Boolean> tuple : this.m_listeners) {
                ((ChangeListener)tuple.getFirst()).chooserChanged(this, this.m_id);
            }
            this.markTextTyped(false);
        }
        this.enableEditButton();
    }

    private boolean supportsObjectType(String string) {
        boolean bl = false;
        Class clazz = Metadata.getInstance().getObjectClass(string);
        if (SystemObject.class.isAssignableFrom(clazz)) {
            bl = this.getProvider().supportsObjectType(string);
        }
        if (!bl && ChildDBObject.class.isAssignableFrom(clazz)) {
            for (String string2 : Metadata.getInstance().getOwnerTypes(string)) {
                if (!this.supportsObjectType(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final DBObjectProvider getProvider() {
        return this.m_destProv;
    }

    private void setSourceProvider(DBObjectProvider dBObjectProvider) {
        this.m_srcProv = dBObjectProvider;
        this.resetCaches();
        if (!this.m_childObjects) {
            this.m_criteria = DBObjectCriteria.createTypeCriteria((String[])this.getTypes());
            if ("SCHEMA".equals(this.getTypes()[0]) && dBObjectProvider instanceof Database) {
                this.m_criteria.setUserOnly(true);
            } else {
                this.m_criteria.setUserOnly(false);
            }
        }
        if (this.getChildChooser() != null) {
            this.getChildChooser().setSourceProvider(dBObjectProvider);
        }
    }

    private final DBObjectProvider getSourceProvider() {
        return this.m_srcProv;
    }

    private final String getStringFromID(DBObjectID dBObjectID) {
        String string = null;
        if (dBObjectID != null) {
            string = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
            if (ModelUtil.hasLength((String)string) && this.internaliseNames() && (!"SCHEMA".equals(dBObjectID.getType()) || !string.equals(this.m_destProv.getDescriptor().getPublicSchemaName()))) {
                string = this.m_destProv.getExternalName(string);
            }
            if (dBObjectID instanceof BaseObjectID && ((BaseObjectID)dBObjectID).getDatabaseName() != null) {
                string = string + "@" + ((BaseObjectID)dBObjectID).getDatabaseName();
            }
        }
        return string == null ? "" : string;
    }

    private Collection<SystemObject> listObjects() throws DBException {
        CancelledException.checkInterrupt();
        if (this.m_lister == null) {
            return this.getSourceProvider().listObjects(this.m_criteria);
        }
        ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
        for (DBObjectLister.ObjectInfo objectInfo : this.m_lister.listObjects(this.m_listCriteria)) {
            SchemaObject schemaObject = this.getSourceProvider().getObject(objectInfo.getType(), objectInfo.getSchema(), objectInfo.getName());
            arrayList.add((SystemObject)schemaObject);
        }
        return arrayList;
    }

    private final DBObjectID getIDFromString(String string) {
        DBObjectID dBObjectID = null;
        if (string != null && string.length() > 0) {
            if (this.internaliseNames()) {
                string = this.m_destProv.getInternalName(string);
            }
            if ((this.isTextTyped() || this.m_textToIDMap.isEmpty()) && !this.m_onlyReferenceIdNeeded) {
                this.populateIDMap(this.m_contextID, false);
            }
            if ((dBObjectID = this.m_textToIDMap.get(string)) == null) {
                String string2 = this.m_types.length == 1 ? this.m_types[0] : "UNSPECIFIED_TYPE";
                dBObjectID = new ReferenceID(string2, null, string, null, null);
                String string3 = null;
                DBObjectID dBObjectID2 = this.m_contextID;
                Class clazz = Metadata.getInstance().getObjectClass(this.m_types[0]);
                if (clazz != null && SchemaObject.class.isAssignableFrom(clazz)) {
                    string3 = this.getStringFromID(dBObjectID2);
                    dBObjectID2 = null;
                }
                ((ReferenceID)dBObjectID).setParent(dBObjectID2);
                ((ReferenceID)dBObjectID).setSchemaName(string3);
                if (this.m_id instanceof ReferenceID) {
                    ((ReferenceID)dBObjectID).setChildObjectNames(((ReferenceID)this.m_id).getChildObjectNames());
                }
            }
        }
        return dBObjectID;
    }

    private boolean internaliseNames() {
        return !this.getTypes()[0].equals("XML SCHEMA") && !this.getTypes()[0].equals("XMLSchemaElement");
    }

    private void setTypeSupported(boolean bl) {
        this.m_typeSupported = bl;
        if (this.getChildChooser() != null && !bl) {
            this.getChildChooser().setTypeSupported(false);
            this.getChildChooser().setEditable(true);
            this.getChildChooser().setSourceProvider(null);
        }
    }

    private boolean isTypeSupported() {
        if (this.getChildChooser() != null && !this.getChildChooser().isTypeSupported()) {
            return false;
        }
        return this.m_typeSupported;
    }

    private final void initialiseUI() {
        if (!(this.getProvider() instanceof Database)) {
            if ("TABLESPACE".equals(this.getTypes()[0])) {
                this.m_editable = true;
            }
            boolean bl = false;
            for (String string : this.getTypes()) {
                if (!this.supportsObjectType(string)) continue;
                bl = true;
                break;
            }
            this.setTypeSupported(bl);
        }
        if (!this.isTypeSupported()) {
            this.m_editable = true;
        }
        if (this.m_editable == null) {
            this.m_editable = false;
        }
        this.m_cmb = new CustomJComboBox();
        this.m_cmb.setEditable(this.m_editable);
        this.add((Component)this.m_cmb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_cmb.setRenderer(this);
        this.m_cmb.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
        if (this.getParentChooser() == null && !this.isTypeSupported()) {
            this.m_butt = new JButton();
            this.m_butt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DBObjectChooser.this.showDBPickerDialog();
                }
            });
            this.m_butt.setIcon(OracleIcons.getIcon((String)"database.png"));
            IconicButtonUI.install((AbstractButton)this.m_butt);
            this.m_butt.setToolTipText(UIBundle.get("CHOOSER_SELECT_CONNECTION_HTML"));
            String string = this.getSelectConnectionText();
            if (ModelUtil.hasLength((String)string)) {
                this.m_butt.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            }
            JLabel jLabel = new JLabel();
            this.m_helper.resLabel(jLabel, this.m_butt, string, "hiddenLabel");
            jLabel.setVisible(false);
            this.add((Component)jLabel, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_butt, new GridBagConstraints(100, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_pickerConfig.setContext(Context.newIdeContext());
            this.m_pickerConfig.setProviderTypes("db");
            this.m_pickerConfig.setShowDetails(true);
            this.m_pickerConfig.setAllowNull(true);
            Database database = null;
            WeakReference<Database> weakReference = s_lastDBRef;
            if (weakReference != null) {
                database = (Database)weakReference.get();
            }
            if (database == null && this.getSourceProvider() instanceof Database) {
                database = (Database)this.getSourceProvider();
            }
            this.m_pickerConfig.setDefaultProviderID(database == null ? null : new DBObjectProviderID((DBObjectProvider)database));
            if (database != null) {
                this.setSourceProvider((DBObjectProvider)database);
            }
        } else if (this.m_showDBLinkButton && this.getProvider().supportsObjectType("DATABASE LINK") && this.getParentChooser() == null) {
            this.m_butt = new JButton();
            this.m_butt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DBObjectChooser.this.showDBLinkDialog();
                }
            });
            this.m_butt.setIcon(OracleIcons.getIcon((String)"link.png"));
            IconicButtonUI.install((AbstractButton)this.m_butt);
            this.m_butt.setToolTipText(UIBundle.get("CHOOSER_SELECT_DBLINK_HTML"));
            if (ModelUtil.hasLength((String)UIBundle.get("CHOOSER_SELECT_DBLINK"))) {
                this.m_butt.setMnemonic(StringUtils.getMnemonicKeyCode((String)UIBundle.get("CHOOSER_SELECT_DBLINK")));
            }
            JLabel jLabel = new JLabel();
            this.m_helper.resLabel(jLabel, this.m_butt, UIBundle.get("CHOOSER_SELECT_DBLINK"), "hiddenLabel");
            jLabel.setVisible(false);
            this.add((Component)jLabel, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_butt, new GridBagConstraints(100, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        if (this.m_showAddButton && this.isTypeSupported()) {
            final String string = this.m_types[0];
            this.m_addButton = new JButton();
            this.add((Component)this.m_addButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_helper.setName(this.m_addButton, "AddButton");
            this.m_addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
            this.m_addButton.setToolTipText(UIBundle.format("IDPANEL_ADD_BUTTON_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(string)));
            IconicButtonUI.install((AbstractButton)this.m_addButton);
            this.m_addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DBObjectProvider dBObjectProvider = DBObjectChooser.this.getProvider();
                    Class clazz = Metadata.getInstance().getObjectClass(string);
                    SystemObject systemObject = (SystemObject)dBObjectProvider.getObjectFactory().newObject(clazz);
                    if (DBObjectChooser.this.m_addObjectProcessor != null) {
                        DBObjectChooser.this.m_addObjectProcessor.initialise(systemObject);
                    }
                    DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig(dBObjectProvider, (DBObject)systemObject);
                    dBEditorConfig.setCommitToProvider(false);
                    DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(dBEditorConfig);
                    boolean bl = true;
                    while (bl) {
                        bl = false;
                        dBEditorFactory.launchDialog(dBEditorConfig);
                        if (dBEditorConfig.getResult() != DBEditorConfig.Result.SUCCESS) continue;
                        ProviderOperator providerOperator = new ProviderOperator(dBObjectProvider);
                        providerOperator.createObjects(new SystemObject[]{systemObject});
                        DBObjectChooser.this.setDBObject((DBObject)systemObject);
                    }
                }
            });
        }
        if (this.m_showEditButton && this.isTypeSupported()) {
            this.m_editButton = new JButton();
            this.add((Component)this.m_editButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_helper.setName(this.m_editButton, "EditButton");
            this.m_editButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
            IconicButtonUI.install((AbstractButton)this.m_editButton);
            this.m_editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    DBObject dBObject;
                    DBObjectID dBObjectID = DBObjectChooser.this.getDBObjectID();
                    DBEditorConfig dBEditorConfig = null;
                    Object object2 = dBObjectID instanceof TemporaryObjectID ? ((dBObject = (object = (TemporaryObjectID)dBObjectID).getOriginalObject()) != null ? dBObject.getID() : null) : dBObjectID;
                    if (object2 != null && object2 instanceof BaseObjectID) {
                        try {
                            dBEditorConfig = DBEditorConfig.newEditConfig((BaseObjectID)object2, false);
                        }
                        catch (DBException dBException) {
                            DBLog.getLogger((Object)this).warning(dBException.getMessage());
                        }
                        if (dBEditorConfig != null && (object = DBEditorFactoryRegistry.getEditFactory(dBEditorConfig)) != null) {
                            object.launchDialog(dBEditorConfig);
                        }
                    }
                }
            });
        }
    }

    private void enableEditButton() {
        if (this.m_editButton != null) {
            boolean bl;
            String string = null;
            boolean bl2 = bl = this.isEnabled() && this.m_id instanceof TemporaryObjectID || this.m_id instanceof BaseObjectID && !(this.m_id instanceof ReferenceID);
            if (bl) {
                String string2 = null;
                String string3 = null;
                if (this.m_id instanceof TemporaryObjectID) {
                    TemporaryObjectID temporaryObjectID = (TemporaryObjectID)this.m_id;
                    DBObject dBObject = temporaryObjectID.getOriginalObject();
                    if (dBObject != null) {
                        string3 = dBObject.getName();
                        string2 = dBObject.getType();
                    }
                } else {
                    BaseObjectID baseObjectID = (BaseObjectID)this.m_id;
                    string2 = baseObjectID.getType();
                    string3 = baseObjectID.getName();
                }
                string = UIBundle.format("IDPANEL_EDIT_BUTTON_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(string2), string3);
            }
            this.m_editButton.setToolTipText(string);
            this.m_editButton.setEnabled(bl);
        }
    }

    private String getSelectConnectionText() {
        return UIBundle.get("CHOOSER_SELECT_CONNECTION");
    }

    private void showDBPickerDialog() {
        String string;
        DBObjectProvider dBObjectProvider = DBObjectProviderPicker.chooseProvider(this.m_pickerConfig, this, StringUtils.stripMnemonic((String)this.getSelectConnectionText()), null, "f1_odbchooserconn_html");
        this.resetCaches();
        if (dBObjectProvider instanceof Database) {
            this.setSourceProvider(dBObjectProvider);
            s_lastDBRef = new WeakReference<Database>((Database)dBObjectProvider);
        } else {
            this.setSourceProvider(this.m_destProv);
            s_lastDBRef = null;
        }
        if (this.m_nonSchemaSystemObjects) {
            try {
                this.setDBObject((DBObject)this.m_srcProv.getDefaultSchema());
            }
            catch (DBException dBException) {}
        } else if (this.m_schemaObjects && this.m_parent == null && this.m_contextID != null && (string = DBUtil.getDBObjectName((DBObjectID)this.m_contextID)) != null && "SCHEMA".equals(this.m_contextID.getType())) {
            DBObjectID dBObjectID = null;
            try {
                Schema schema = this.m_srcProv.getSchema(string);
                if (schema != null) {
                    dBObjectID = schema.getID();
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dBObjectID == null) {
                dBObjectID = TemporaryObjectID.createID((DBObject)new Schema(string));
            }
            this.setContextDBObjectID(dBObjectID);
        }
    }

    private void showDBLinkDialog() {
        Schema schema;
        try {
            schema = this.m_destProv.getDefaultSchema();
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)this).warning(dBException.getMessage());
            return;
        }
        DefaultTraversablePanel defaultTraversablePanel = new DefaultTraversablePanel();
        defaultTraversablePanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel();
        final DBObjectChooser dBObjectChooser = new DBObjectChooser("DATABASE LINK");
        dBObjectChooser.m_isDatabaseLinkChooser = true;
        dBObjectChooser.setNullText(UIBundle.get("CHOOSER_NO_DATABASE_LINK"));
        dBObjectChooser.setProvider(this.m_destProv);
        dBObjectChooser.setContextDBObjectID(schema.getID());
        dBObjectChooser.setDBObjectID(this.m_databaseLinkID);
        this.m_helper.resLabel(jLabel, dBObjectChooser, UIBundle.get("CHOOSER_SELECT_DBLINK_LABEL"), "dblinkChooser");
        defaultTraversablePanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 8, 0), 0, 0));
        defaultTraversablePanel.add((Component)dBObjectChooser, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 8, 8, 0), 0, 0));
        defaultTraversablePanel.setHelpID("f1_dbselectdblink_html");
        Namespace namespace = new Namespace();
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)this, UIBundle.get("CHOOSER_SELECT_DBLINK_TITLE"), (Traversable)defaultTraversablePanel, namespace);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setContent((Component)defaultTraversablePanel);
        jEWTDialog.setResizable(true);
        jEWTDialog.setName("ChooserDBLinkDialog");
        jEWTDialog.setButtonMask(7);
        jEWTDialog.setPreferredSize(new Dimension(360, 120));
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                    DatabaseLink databaseLink = (DatabaseLink)dBObjectChooser.getDBObject();
                    String string = databaseLink == null ? null : databaseLink.getName();
                    DBObjectChooser.this.m_databaseLinkID = databaseLink == null ? null : databaseLink.getID();
                    DBObjectChooser.this.setContextDBObjectID(DBObjectChooser.this.m_databaseLinkID);
                    if (databaseLink == null) {
                        DBObjectChooser.this.setDBObject((DBObject)schema);
                    } else if (DBObjectChooser.this.m_destProv instanceof AbstractDBObjectProvider) {
                        NameBasedID nameBasedID;
                        String string2 = ((AbstractDBObjectProvider)DBObjectChooser.this.m_destProv).getDefaultSchemaName(databaseLink);
                        if (ModelUtil.hasLength((String)string2)) {
                            nameBasedID = new NameBasedID("SCHEMA", null, string2);
                            nameBasedID.setDatabaseName(string);
                            nameBasedID.setProvider(DBObjectChooser.this.m_destProv);
                        } else {
                            nameBasedID = null;
                        }
                        DBObjectChooser.this.setDBObjectID((DBObjectID)nameBasedID);
                    } else {
                        DBObjectChooser.this.setDBObjectID(null);
                    }
                    DBObjectChooser.this.m_criteria.setDatabaseName(string);
                }
            }
        };
        jEWTDialog.addVetoableChangeListener(vetoableChangeListener);
        boolean bl = tDialogLauncher.showDialog();
    }

    private boolean isInContext(DBObjectID dBObjectID) {
        boolean bl = true;
        if (this.m_contextID != null) {
            DBObject dBObject;
            DBObject dBObject2;
            bl = "SCHEMA".equals(this.m_contextID.getType()) ? ModelUtil.areEqual((Object)DBUtil.getDBObjectName((DBObjectID)this.m_contextID), (Object)DBUtil.getSchemaName((DBObjectID)dBObjectID)) : (dBObjectID instanceof TemporaryObjectID ? (this.m_contextID instanceof TemporaryObjectID ? (dBObject2 = ((TemporaryObjectID)this.m_contextID).getDBObject()) == (dBObject = ((TemporaryObjectID)dBObjectID).getDBObject()).getParent() : false) : !this.m_contextID.equals(dBObjectID) && DBUtil.isSameOrChildOf((DBObjectID)dBObjectID, (DBObjectID)this.m_contextID, (boolean)true));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIDMap(DBObjectID dBObjectID, boolean bl) {
        String string;
        List<DBObjectID> list = this.m_contextToIDListMap.get(dBObjectID);
        if (list == null) {
            try {
                boolean bl2 = !bl && this.subsetAvailable(dBObjectID);
                list = this.getEntries(dBObjectID, bl2);
                for (DBObjectID dBObjectID2 : this.m_extraIDs) {
                    DBObjectID dBObjectID3;
                    if (!this.isInContext(dBObjectID2)) continue;
                    if (dBObjectID2 instanceof TemporaryObjectID && list.contains(dBObjectID3 = TemporaryObjectID.findOriginalID((TemporaryObjectID)(string = (TemporaryObjectID)dBObjectID2)))) {
                        list.remove(dBObjectID3);
                    }
                    list.add(dBObjectID2);
                }
                if (!Thread.currentThread().isInterrupted() && !bl2) {
                    this.m_contextToIDListMap.put(dBObjectID, list);
                }
            }
            catch (CancelledException cancelledException) {
            }
            catch (DBException dBException) {
                DBLog.getLogger(DBObjectChooser.class).log(Level.WARNING, UIBundle.format("CHOOSER_LOAD_ENTRIES_ERROR", dBException.getMessage()));
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            Map<String, DBObjectID> map = this.m_textToIDMap;
            synchronized (map) {
                this.m_textToIDMap.clear();
                if (list != null) {
                    for (DBObjectID dBObjectID2 : list) {
                        string = this.getStringFromID(dBObjectID2);
                        if (!ModelUtil.hasLength((String)string)) continue;
                        this.m_textToIDMap.put(string, dBObjectID2);
                    }
                }
            }
        }
    }

    private boolean subsetAvailable(DBObjectID dBObjectID) {
        String string;
        String[] stringArray;
        boolean bl = false;
        DBObjectProvider dBObjectProvider = this.getSourceProvider();
        if (dBObjectID != null && this.m_schemaObjects && dBObjectProvider instanceof Database && (stringArray = this.getTypes()).length == 1 && "TYPE".equals(stringArray[0]) && ModelUtil.hasLength((String)(string = this.getStringFromID(dBObjectID)))) {
            DBObjectCriteria dBObjectCriteria = DBObjectCriteria.createCriteria((String)"TYPE", (String)string, null);
            Collection collection = dBObjectProvider.getDescriptor().listBuiltInObjects(dBObjectCriteria);
            bl = collection != null && !collection.isEmpty();
        }
        return bl;
    }

    private String getLoadFullListText() {
        return UIBundle.get("CHOOSER_LOAD_FULL_LIST");
    }

    private void buildMaintainID() {
        if (this.m_listener == null) {
            this.m_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DBObjectChooser.this.m_listening) {
                        String string = DBObjectChooser.this.getLoadFullListText();
                        boolean bl = false;
                        if (DBObjectChooser.this.m_editable != null && DBObjectChooser.this.m_editable.booleanValue()) {
                            Object object = DBObjectChooser.this.m_cmb.getEditor().getItem();
                            if (DBObjectChooser.this.m_subsetLoaded && string.equals(object)) {
                                DBObjectChooser.this.m_cmb.updateComboModel(true);
                            } else if (object instanceof String) {
                                DBObjectID dBObjectID;
                                DBObjectID dBObjectID2 = DBObjectChooser.this.getIDFromString((String)object);
                                if (!DBObjectChooser.this.m_cmb.isModelLoaded() && !DBObjectChooser.this.m_onlyReferenceIdNeeded) {
                                    DBObjectChooser.this.m_cmb.updateComboModel(false);
                                }
                                if (dBObjectID2 instanceof ReferenceID && (dBObjectID = (DBObjectID)DBObjectChooser.this.m_textToIDMap.get(((ReferenceID)dBObjectID2).getName())) != null) {
                                    dBObjectID2 = dBObjectID;
                                }
                                DBObjectChooser.this.setDBObjectID(dBObjectID2);
                                bl = true;
                            }
                        } else {
                            Object object = DBObjectChooser.this.m_cmb.getSelectedItem();
                            if (DBObjectChooser.this.m_subsetLoaded && string.equals(object)) {
                                DBObjectChooser.this.m_cmb.updateComboModel(true);
                            } else if (object instanceof String) {
                                DBObjectID dBObjectID = (DBObjectID)DBObjectChooser.this.m_textToIDMap.get(object);
                                DBObjectChooser.this.updateID(dBObjectID);
                                bl = true;
                            }
                        }
                        if (!bl) {
                            DBObjectChooser.this.updateID(null);
                        }
                    }
                }
            };
            this.m_cmb.addActionListener(this.m_listener);
        }
    }

    private void showID() {
        DBObjectID dBObjectID = this.fixProvider(this.m_id);
        String string = null;
        if (dBObjectID != null) {
            String string2 = this.getStringFromID(dBObjectID);
            if (ModelUtil.hasLength((String)string2)) {
                string = string2;
            }
        } else if (this.m_editable != null && this.m_editable.booleanValue()) {
            this.m_cmb.getEditor().setItem(string);
            return;
        }
        this.m_cmb.removeActionListener(this.m_listener);
        if (this.m_textToIDMap.containsKey(string)) {
            this.m_cmb.setSelectedItem(string);
        } else {
            int n = -1;
            this.m_textToIDMap.clear();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            if (dBObjectID != null) {
                defaultComboBoxModel.addElement(string);
                this.m_textToIDMap.put(string, dBObjectID);
                n = 0;
            }
            this.m_cmb.setModel(defaultComboBoxModel, false);
            this.m_cmb.setSelectedIndex(n);
        }
        if (this.m_cmb.isEditable()) {
            this.m_cmb.getEditor().setItem(string);
        }
        this.m_cmb.addActionListener(this.m_listener);
    }

    private void contextChanged() {
        DBObjectID dBObjectID = null;
        if (this.m_editable != null && this.m_editable.booleanValue()) {
            String string = (String)this.m_cmb.getEditor().getItem();
            dBObjectID = this.getIDFromString(string);
        } else {
            this.m_textToIDMap.clear();
            this.m_cmb.setModel(new DefaultComboBoxModel(), false);
        }
        this.m_cmb.reset();
        this.setDBObjectID(dBObjectID);
    }

    private void markTextTyped(boolean bl) {
        this.m_isTextTyped = bl;
    }

    private boolean isTextTyped() {
        return this.m_isTextTyped;
    }

    private void ensureChildContextUpToDate() {
        if (this.isTextTyped()) {
            DBObjectID dBObjectID;
            DBObjectID dBObjectID2 = this.getDBObjectID();
            if (dBObjectID2 instanceof ReferenceID && (dBObjectID = this.m_textToIDMap.get(((ReferenceID)dBObjectID2).getName())) != null) {
                dBObjectID2 = dBObjectID;
            }
            this.setDBObjectID(dBObjectID2);
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)this.m_cmb.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (object instanceof String) {
            if (this.getLoadFullListText().equals(object)) {
                jLabel.setBorder(new BevelBorder(1));
            } else if (this.m_showDBLinkButton && ((String)object).startsWith("...@")) {
                jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon("DATABASE LINK"));
            } else if (this.m_srcProv instanceof Database && !(this.m_destProv instanceof Database) && this.m_types[0].equals("SCHEMA")) {
                jLabel.setIcon(OracleIcons.getIcon((String)"database.png"));
            } else if (this.getShowIcon()) {
                String string;
                String string2 = (String)object;
                DBObjectID dBObjectID = this.m_textToIDMap.get(string2);
                if (dBObjectID != null && (string = dBObjectID.getType()) != null) {
                    jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon(string));
                }
            } else if (this.m_expandFKOwner != null) {
                String string;
                DBObjectID dBObjectID;
                Constraint constraint;
                String string3 = (String)object;
                DBObjectID dBObjectID2 = this.m_textToIDMap.get(string3);
                if (dBObjectID2 == null) {
                    dBObjectID2 = this.getDBObjectID();
                }
                if (dBObjectID2 != null && (constraint = this.m_expandFKOwner.getConstraint(string3)) != null && constraint instanceof FKConstraint && (dBObjectID = ((FKConstraint)constraint).getReferenceID()) != null && (string = DBUtil.getFullyQualifiedName((DBObjectID)dBObjectID)) != null) {
                    jLabel.setText(jLabel.getText() + " -> " + string);
                }
            }
        }
        return jLabel;
    }

    private List<DBObjectID> getEntries(DBObjectID dBObjectID, boolean bl) throws DBException {
        ArrayList<DBObjectID> arrayList;
        block17: {
            DBObject dBObject;
            DBObjectFilter dBObjectFilter;
            block19: {
                DBObjectID dBObjectID2;
                Object object3;
                Object object2;
                block20: {
                    block18: {
                        arrayList = new ArrayList<DBObjectID>();
                        if (this.getSourceProvider() == null) break block17;
                        dBObjectFilter = this.getFilter();
                        if (!this.m_nonSchemaSystemObjects) break block18;
                        if (this.m_showDBLinkButton && this.m_id instanceof BaseObjectID) {
                            this.m_criteria.setDatabaseName(((BaseObjectID)this.m_id).getDatabaseName());
                        }
                        for (SystemObject systemObject : this.listObjects()) {
                            CancelledException.checkInterrupt();
                            if (systemObject == null || dBObjectFilter != null && !dBObjectFilter.accept((DBObject)systemObject)) continue;
                            DBObjectID dBObjectID3 = systemObject.getID();
                            if (dBObjectID3 == null) {
                                dBObjectID3 = TemporaryObjectID.createID((DBObject)systemObject);
                            }
                            arrayList.add(dBObjectID3);
                        }
                        break block17;
                    }
                    if (!this.m_schemaObjects) break block19;
                    if (!bl || !this.subsetAvailable(dBObjectID)) break block20;
                    if (dBObjectID == null || !"SCHEMA".equals(dBObjectID.getType())) break block17;
                    this.m_criteria.setSchemaName(this.getStringFromID(dBObjectID));
                    DBObjectSet dBObjectSet = new DBObjectSet();
                    Collection collection = this.getSourceProvider().getDescriptor().listBuiltInObjects(this.m_criteria);
                    for (SystemObject systemObject : collection) {
                        CancelledException.checkInterrupt();
                        dBObjectSet.add(systemObject);
                    }
                    for (SystemObject systemObject : dBObjectSet) {
                        arrayList.add(systemObject.getID());
                    }
                    break block17;
                }
                String string = null;
                String string2 = null;
                if (dBObjectID instanceof TemporaryObjectID) {
                    object2 = dBObjectID.resolveID();
                    if (object2 instanceof Schema) {
                        string2 = object2.getName();
                    }
                } else if (dBObjectID instanceof BaseObjectID && "SCHEMA".equals((object2 = (BaseObjectID)dBObjectID).getType())) {
                    string = object2.getDatabaseName();
                    string2 = DBUtil.getDBObjectName((DBObjectID)object2);
                }
                this.m_criteria.setDatabaseName(string);
                this.m_criteria.setSchemaName(string2);
                for (Object object3 : this.listObjects()) {
                    CancelledException.checkInterrupt();
                    if (dBObjectFilter != null && !dBObjectFilter.accept((DBObject)object3)) continue;
                    dBObjectID2 = object3.getID();
                    if (dBObjectID2 == null) {
                        dBObjectID2 = TemporaryObjectID.createID((DBObject)object3);
                    }
                    arrayList.add(dBObjectID2);
                }
                if (!this.m_isDatabaseLinkChooser) break block17;
                CancelledException.checkInterrupt();
                object2 = this.getSourceProvider();
                object3 = object2.getDescriptor().getPublicSchemaName();
                if (object3 != null) {
                    dBObjectID2 = DBObjectCriteria.createCriteria((String)"DATABASE LINK", (String)object3, null);
                    for (SystemObject systemObject : object2.listObjects((DBObjectCriteria)dBObjectID2)) {
                        CancelledException.checkInterrupt();
                        if (dBObjectFilter != null && !dBObjectFilter.accept((DBObject)systemObject)) continue;
                        DBObjectID dBObjectID4 = systemObject.getID();
                        if (dBObjectID4 == null) {
                            dBObjectID4 = TemporaryObjectID.createID((DBObject)systemObject);
                        }
                        arrayList.add(dBObjectID4);
                    }
                }
                break block17;
            }
            if (this.m_childObjects && dBObjectID != null && (dBObject = dBObjectID.resolveID()) != null) {
                for (String string : this.getTypes()) {
                    CancelledException.checkInterrupt();
                    for (DBObject dBObject2 : dBObject.getOwnedObjects(new String[]{string})) {
                        CancelledException.checkInterrupt();
                        if (dBObjectFilter != null && !dBObjectFilter.accept(dBObject2)) continue;
                        arrayList.add(dBObject2.getID());
                    }
                }
            }
        }
        return arrayList;
    }

    private DBObjectID fixProvider(DBObjectID dBObjectID) {
        if (this.getProvider() != this.getSourceProvider() && (dBObjectID instanceof NameBasedID || dBObjectID instanceof IdentifierBasedID)) {
            BaseObjectID baseObjectID = (BaseObjectID)dBObjectID;
            ReferenceID referenceID = new ReferenceID(baseObjectID.getType(), baseObjectID.getSchemaName(), baseObjectID.getName());
            referenceID.setParent(this.fixProvider(baseObjectID.getParent()));
            referenceID.setProvider(this.getProvider());
            return referenceID;
        }
        return dBObjectID;
    }

    public Component getEditorComponent() {
        if (this.m_cmb != null) {
            return this.m_cmb.getEditor().getEditorComponent();
        }
        return null;
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmb;
    }

    public static abstract class NewObjectProcessor {
        public abstract void initialise(SystemObject var1);
    }

    private class ProviderListener
    extends DBObjectProviderListener {
        private ProviderListener() {
        }

        private void resetCachesIfApplicable(Collection<? extends DBObject> collection) {
            for (DBObject dBObject : collection) {
                if (!Arrays.asList(DBObjectChooser.this.getTypes()).contains(dBObject.getType())) continue;
                DBObjectChooser.this.resetCaches();
                break;
            }
        }

        public void objectUpdated(DBObjectChange dBObjectChange) {
            if (DBObjectChooser.this.m_childObjects && dBObjectChange.getDBObject().getID().equals(DBObjectChooser.this.m_contextID, false)) {
                this.resetCachesIfApplicable(dBObjectChange.getOwnedObjectsAdded());
                this.resetCachesIfApplicable(dBObjectChange.getOwnedObjectsRemoved());
            } else {
                this.resetCachesIfApplicable(Collections.singletonList(dBObjectChange.getDBObject()));
            }
        }

        public void systemObjectsAdded(DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) {
            this.resetCachesIfApplicable(collection);
        }

        public void schemaObjectsRemoved(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
            this.resetCachesIfApplicable(collection);
        }

        public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
            this.resetCachesIfApplicable(collection);
        }

        public void systemObjectsRemoved(DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) {
            this.resetCachesIfApplicable(collection);
        }
    }

    private class CustomJComboBox
    extends AbstractLazyCombo {
        private boolean m_forceFull;

        private CustomJComboBox() {
        }

        @Override
        protected String getLoadMessage() {
            return "AbstractComboBasedChooser.updateComboModel.DONE";
        }

        @Override
        public String getNullText() {
            return DBObjectChooser.this.m_nullText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<String> getModelEntries() {
            boolean bl;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = DBObjectChooser.this.getStringFromID(DBObjectChooser.this.getDBObjectID());
            DBObjectID dBObjectID = DBObjectChooser.this.m_contextID;
            DBObjectChooser.this.populateIDMap(dBObjectID, this.m_forceFull);
            Collection collection = DBObjectChooser.this.m_textToIDMap.values();
            if (collection != null) {
                String string2 = null;
                Map map = DBObjectChooser.this.m_textToIDMap;
                synchronized (map) {
                    for (DBObjectID dBObjectID2 : collection) {
                        if (dBObjectID2 == null && string2 == null) {
                            string2 = this.getNullText();
                            continue;
                        }
                        String string3 = DBObjectChooser.this.getStringFromID(dBObjectID2);
                        if (!ModelUtil.hasLength((String)string3)) continue;
                        arrayList.add(string3);
                    }
                }
                Collections.sort(arrayList);
                if (string2 != null) {
                    arrayList.add(0, string2);
                }
                DBObjectChooser.this.m_textToIDMap.put(string, DBObjectChooser.this.getDBObjectID());
            }
            boolean bl2 = bl = !this.m_forceFull && DBObjectChooser.this.subsetAvailable(dBObjectID);
            if (bl) {
                DBObjectChooser.this.m_subsetLoaded = true;
                arrayList.add(DBObjectChooser.this.getLoadFullListText());
            }
            return arrayList;
        }

        @Override
        protected void doBeforeClearingModel() {
            DBObjectChooser.this.m_listening = false;
        }

        @Override
        protected void doAfterClearingModel() {
            DBObjectChooser.this.m_listening = true;
        }

        @Override
        protected void doBeforeLoading() {
            if (DBObjectChooser.this.m_parent != null) {
                DBObjectChooser.this.m_parent.ensureChildContextUpToDate();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.m_forceFull = false;
        }

        private void updateComboModel(boolean bl) {
            this.reset();
            this.m_forceFull = bl;
            this.loadModel();
            if (bl) {
                this.removeItem(DBObjectChooser.this.getLoadFullListText());
            }
        }

        @Override
        protected JTextField createEditorTextField() {
            return new CustomChooserTextField();
        }

        private class CustomChooserTextField
        extends AbstractLazyCombo.CustomJTextField {
            public CustomChooserTextField() {
                super(CustomJComboBox.this);
                this.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        CustomChooserTextField.this.notifyListeners();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        CustomChooserTextField.this.notifyListeners();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                });
                this.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        DBObjectChooser.this.markTextTyped(true);
                    }
                });
            }

            private void notifyListeners() {
                DBObjectID dBObjectID = null;
                for (Tuple tuple : DBObjectChooser.this.m_listeners) {
                    if (!((Boolean)tuple.getSecond()).booleanValue()) continue;
                    if (dBObjectID == null) {
                        dBObjectID = DBObjectChooser.this.getIDFromString(this.getText());
                    }
                    ((ChangeListener)tuple.getFirst()).chooserChanged(DBObjectChooser.this, dBObjectID);
                }
            }

            @Override
            protected String getBaseName() {
                return DBObjectChooser.this.getName();
            }
        }
    }

    public static interface ChangeListener {
        public void chooserChanged(DBObjectChooser var1, DBObjectID var2);
    }
}

