/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;

public class SchemaObjectComboBox
extends JComboBox
implements ListCellRenderer {
    private DBObjectProvider m_pro = null;
    private DefaultListCellRenderer m_delegate = new DefaultListCellRenderer();
    private boolean m_showNull = false;
    private boolean m_showIcon = false;

    public SchemaObjectComboBox() {
        this.setRenderer(this);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, String ... stringArray) {
        this.init(dBObjectProvider, schema, false, stringArray);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, boolean bl, String ... stringArray) {
        Object object;
        this.m_pro = dBObjectProvider;
        this.m_showNull = bl;
        this.m_showIcon = stringArray.length > 1;
        this.removeAllItems();
        if (bl) {
            object = null;
            if (stringArray.length == 1) {
                object = stringArray[0];
            }
            SchemaObjectDescriptor object2 = new SchemaObjectDescriptor(" ", (String)object, null);
            this.addItem(object2);
        }
        object = new SchemaObject[]{};
        try {
            object = dBObjectProvider.listObjects(stringArray, schema);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        Arrays.sort(object, DBUtil.getNameComparator());
        for (SchemaObject schemaObject : object) {
            SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor((SystemObject)schemaObject);
            this.addItem(schemaObjectDescriptor);
        }
    }

    public void initWithOneItem(SchemaObject schemaObject) {
        this.removeAllItems();
        SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor((SystemObject)schemaObject);
        this.addItem(schemaObjectDescriptor);
        this.setSelectedItem(schemaObjectDescriptor);
    }

    public SchemaObject getSchemaObject() {
        if (this.m_showNull && this.getSelectedIndex() == 0) {
            return null;
        }
        SchemaObject schemaObject = null;
        SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)super.getSelectedItem();
        if (schemaObjectDescriptor != null) {
            try {
                schemaObject = (SchemaObject)schemaObjectDescriptor.findObject(this.m_pro);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        if (schemaObject == null && this.m_showNull) {
            this.setSelectedIndex(0);
            return;
        }
        String string = null == schemaObject ? "" : schemaObject.getName();
        String string2 = null == schemaObject ? "" : schemaObject.getType();
        ComboBoxModel comboBoxModel = this.getModel();
        boolean bl = false;
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            String string3;
            SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)comboBoxModel.getElementAt(i);
            String string4 = null == schemaObjectDescriptor ? "" : schemaObjectDescriptor.getName();
            String string5 = string3 = null == schemaObjectDescriptor ? "" : schemaObjectDescriptor.getType();
            if (!string4.equals(string) || !string3.equals(string2)) continue;
            bl = true;
            break;
        }
        SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor((SystemObject)schemaObject);
        if (bl) {
            this.removeItem(schemaObjectDescriptor);
        }
        this.addItem(schemaObjectDescriptor);
        this.setSelectedItem(schemaObjectDescriptor);
    }

    public void setShowIcon(boolean bl) {
        this.m_showIcon = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)object;
        String string = schemaObjectDescriptor == null ? null : schemaObjectDescriptor.getName();
        JLabel jLabel = (JLabel)this.m_delegate.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        if (this.m_showIcon && schemaObjectDescriptor != null) {
            jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon(schemaObjectDescriptor.getType()));
        }
        return jLabel;
    }

    public void addItem(Object object) {
        super.addItem(object);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        super.setModel(comboBoxModel);
    }
}

