/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.execute;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.util.ModelUtil;
import org.openide.util.RequestProcessor;

public final class DBRequestProcessor {
    private final Lock m_scheduleLock;
    private final Map<String, DBTimerTask> m_schedule = new HashMap<String, DBTimerTask>();
    private final Collection<DBRunnable> m_executing = new IdentitySet();
    private final ExecutorService m_executor;
    private final boolean m_privateExecutor;
    private final DBObjectNode m_node;

    DBRequestProcessor(ExecutorService executorService, DBObjectNode dBObjectNode, Lock lock) {
        this.m_node = dBObjectNode;
        this.m_privateExecutor = executorService == null;
        this.m_scheduleLock = lock;
        this.m_executor = this.m_privateExecutor ? new RequestProcessor(this.getThreadName("_Processor"), 1, true) : executorService;
    }

    private String getThreadName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append('_').append(this.m_node.getShortLabel()).append('#').append(System.identityHashCode(this)).append(string);
        return stringBuilder.toString();
    }

    private Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    private void logRequest(String string) {
        this.getLogger().fine(this.m_node.getShortLabel() + ": " + string);
    }

    void shutdown() {
        this.logRequest("Shutting down processor");
        if (this.m_privateExecutor) {
            this.m_scheduleLock.lock();
            try {
                this.m_executor.shutdownNow();
            }
            finally {
                this.m_scheduleLock.unlock();
            }
        }
    }

    public Future<?> execute(DBRunnable dBRunnable) {
        this.m_scheduleLock.lock();
        try {
            Future<?> future = this.executeImpl(dBRunnable);
            return future;
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    private Future<?> executeImpl(DBRunnable dBRunnable) {
        Future<?> future = null;
        if (!this.m_executor.isShutdown()) {
            this.logRequest("Executing " + dBRunnable.getName());
            this.m_executing.add(dBRunnable);
            future = this.m_executor.submit(dBRunnable);
        }
        return future;
    }

    private String qualifySchedulerKey(String string) {
        return string + '_' + this.m_node.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(String string, DBRunnable dBRunnable, int n) {
        this.logRequest("Scheduling " + string + " with delay " + n);
        String string2 = this.qualifySchedulerKey(string);
        DBTimerTask dBTimerTask = new DBTimerTask(string2, dBRunnable);
        this.m_scheduleLock.lock();
        try {
            TimerTask timerTask = this.m_schedule.put(string2, dBTimerTask);
            if (timerTask != null) {
                timerTask.cancel();
            }
            DBRequestProcessorFactory.getInstance().getTimer().schedule((TimerTask)dBTimerTask, n);
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String string) {
        this.logRequest("Cancelling " + string);
        this.m_scheduleLock.lock();
        try {
            String string2 = this.qualifySchedulerKey(string);
            TimerTask timerTask = this.m_schedule.remove(string2);
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(DBRunnable dBRunnable) {
        this.m_scheduleLock.lock();
        try {
            DBTimerTask dBTimerTask;
            this.m_executing.remove(dBRunnable);
            String string = dBRunnable.m_scheduleKey;
            if (string != null && (dBTimerTask = this.m_schedule.get(string)).m_run == dBRunnable) {
                this.m_schedule.remove(string);
            }
            if (this.m_schedule.isEmpty() && this.m_executing.isEmpty()) {
                DBRequestProcessorFactory.getInstance().notifyProcessorEmpty(this.m_node, this);
            }
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    public abstract class DBRunnable
    implements Runnable {
        private final DBObjectProvider m_pro;
        private final String m_name;
        private String m_scheduleKey;
        private Future<?> m_future;

        public DBRunnable(DBObjectProvider dBObjectProvider, String string) {
            if (!ModelUtil.hasLength((String)string)) {
                throw new IllegalArgumentException("must specify a translated name");
            }
            this.m_pro = dBObjectProvider;
            this.m_name = string;
        }

        public final DBObjectProvider getProvider() {
            return this.m_pro;
        }

        public String getName() {
            return this.m_name;
        }

        protected Logger getLogger() {
            return DBLog.getLogger((Object)this);
        }

        protected abstract void doWork() throws DBException, InterruptedException;

        protected void cancelWork() {
        }

        @Override
        public final void run() {
            if (!(this.m_pro instanceof Database) || ((Database)this.m_pro).isConnectionAlive()) {
                try {
                    this.logProgress(" started.");
                    this.doWork();
                    this.logProgress(" completed successfully.");
                }
                catch (CancelledException cancelledException) {
                    this.logProgress(" was cancelled.");
                }
                catch (DBException dBException) {
                    this.getLogger().warning(this.getName() + " : " + dBException.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    this.logProgress(" was interrupted.");
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    this.getLogger().log(Level.SEVERE, "Unexpected error executing task.", exception);
                }
                finally {
                    this.logProgress(" finished.");
                    this.m_future = null;
                    DBRequestProcessor.this.finished(this);
                }
            }
        }

        private void cancel() {
            Future<?> future = this.m_future;
            if (future != null && future.cancel(true)) {
                this.cancelWork();
            }
        }

        private void logProgress(String string) {
            this.getLogger().finest(this.getName() + string);
        }
    }

    private class DBTimerTask
    extends TimerTask {
        private final String m_key;
        private final DBRunnable m_run;

        DBTimerTask(String string, DBRunnable dBRunnable) {
            this.m_key = string;
            this.m_run = dBRunnable;
        }

        @Override
        public void run() {
            DBRequestProcessor.this.m_scheduleLock.lock();
            try {
                TimerTask timerTask = (TimerTask)DBRequestProcessor.this.m_schedule.get(this.m_key);
                if (timerTask == this) {
                    this.m_run.m_scheduleKey = this.m_key;
                    this.m_run.m_future = DBRequestProcessor.this.executeImpl(this.m_run);
                }
            }
            catch (Exception exception) {
                this.m_run.getLogger().log(Level.SEVERE, "task execution failed", exception);
            }
            finally {
                DBRequestProcessor.this.m_scheduleLock.unlock();
            }
        }

        @Override
        public boolean cancel() {
            boolean bl = super.cancel();
            this.m_run.cancel();
            return bl;
        }
    }
}

