/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.db.insight.model.InsightDataProvider;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.icons.OracleIcons;

public class FunctionProvider
extends InsightDataProvider {
    private static final String[] SCHEMA_OBJECT_TYPES = new String[]{"PACKAGE", "FUNCTION"};
    private Collection<BuiltInFunction> m_funcDefs;
    private final Icon m_funcIcon = OracleIcons.getIcon((String)"function.png");
    private String m_desc;

    @Override
    public void addItems(DBObject dBObject) throws CancelledException {
        if (this.isTargetClass(DBObject.class, false)) {
            Object object;
            if (dBObject instanceof Package) {
                for (Schema schema : ((Package)dBObject).getSubPrograms()) {
                    CancelledException.checkInterrupt();
                    if (schema.getReturnTypeReference() == null) continue;
                    this.addDBObject((DBObject)schema);
                }
            } else if (dBObject instanceof Schema) {
                object = (Schema)dBObject;
                for (SchemaObject schemaObject : this.getMatchingSchemaItems((Schema)object, SCHEMA_OBJECT_TYPES)) {
                    CancelledException.checkInterrupt();
                    this.addDBObject((DBObject)schemaObject);
                }
            }
            if (this.isTopLevel(dBObject)) {
                if (this.m_funcDefs == null) {
                    this.m_funcDefs = this.getProvider().getDescriptor().listBuiltInFunctions();
                    object = new StringBuilder(this.m_DBInsightProvider.getLanguage());
                    ((StringBuilder)object).append(" ");
                    ((StringBuilder)object).append(UIBundle.get("FUNCTION_TYPE"));
                    this.m_desc = ((StringBuilder)object).toString();
                }
                for (BuiltInFunction builtInFunction : this.m_funcDefs) {
                    CancelledException.checkInterrupt();
                    this.addExpression(this.m_desc, this.m_funcIcon, builtInFunction.getSignature(false));
                }
            }
        }
    }
}

