/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectNode
extends Node
implements DBObjectNode {
    private DBObjectID m_id;

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    public DBObject getDBObject() {
        DBObject dBObject = null;
        if (this.m_id != null) {
            try {
                dBObject = this.m_id.resolveID();
                if (dBObject != null && ModelUtil.areDifferent((Object)dBObject.getName(), (Object)this.getObjectName())) {
                    dBObject = null;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (dBObject == null && (dBObject = BaseDBObjectNode.findDBObject(this)) != null) {
            this.m_id = dBObject.getID();
        }
        return dBObject;
    }

    @Override
    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    @Override
    public void init(DBObject dBObject, DBObjectProvider dBObjectProvider) {
    }

    static DBObject findDBObject(DBObjectNode dBObjectNode) {
        SystemObject systemObject = null;
        try {
            DBObjectProvider dBObjectProvider = dBObjectNode.getProvider();
            if (dBObjectProvider != null) {
                Schema schema = DBObjectNodeUtil.getSchema(dBObjectNode, true);
                String string = DBObjectNodeUtil.normalizeType(dBObjectNode);
                String string2 = dBObjectNode.getObjectName();
                if (dBObjectProvider.supportsObjectType(string)) {
                    DBObjectCriteria dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria((String)string, (Schema)schema, (String)string2);
                    systemObject = dBObjectProvider.getObject(dBObjectCriteria);
                }
            }
        }
        catch (DBException dBException) {
            DBLog.getLogger(BaseDBObjectNode.class).log(Level.WARNING, "Could not retrieve object for node {0}: {1}", new Object[]{dBObjectNode.getURL(), dBException.getMessage()});
        }
        return systemObject;
    }

    static DBObjectProvider findProvider(DBObjectNode dBObjectNode) {
        try {
            return DBObjectProviderFactory.findOrCreateProvider((String)dBObjectNode.getProviderType(), (Object)dBObjectNode.getProviderIdentifier());
        }
        catch (DBException dBException) {
            DBLog.getLogger(BaseDBObjectNode.class).log(Level.WARNING, "Could not retrieve provider for node {0}: {1}", new Object[]{dBObjectNode.getURL(), dBException.getMessage()});
            return null;
        }
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(DBObjectNodeUtil.normalizeType(this));
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String string = this.getObjectName();
        if (ModelUtil.hasLength((String)string)) {
            return string;
        }
        return super.getShortLabel();
    }
}

