/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.panels.sql.FromObjectsPanel;
import oracle.ideimpl.db.panels.sql.GroupByPanel;
import oracle.ideimpl.db.panels.sql.HavingPanel;
import oracle.ideimpl.db.panels.sql.HierarchicalQueryPanel;
import oracle.ideimpl.db.panels.sql.OrderByPanel;
import oracle.ideimpl.db.panels.sql.QueryPanel;
import oracle.ideimpl.db.panels.sql.QuickPickObjectsPanel;
import oracle.ideimpl.db.panels.sql.SelectObjectsPanel;
import oracle.ideimpl.db.panels.sql.WhereObjectPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.WhereObject;

public final class SQLQueryEditDialog
implements Comparator {
    public static final String HELP_PICKER = "f1_odbviobjpick_html";
    public static final String HELP_SELECT_INFO = "f1_odbviselect_html";
    public static final String HELP_FROM_INFO = "f1_odbvifrom_html";
    public static final String HELP_WHERE_INFO = "f1_odbviwhere_html";
    public static final String HELP_GROUPBY_INFO = "f1_odbvigroup_html";
    public static final String HELP_HAVING_INFO = "f1_odbvihaving_html";
    public static final String HELP_ORDERBY_INFO = "f1_odbviorderby_html";
    public static final String HELP_CONNECTBY_INFO = "f1_odbvconnectby_html";
    public static final String HELP_QUERY_INFO = "f1_odbvisql_html";
    private static final String[] QUERY_HELP_IDS = new String[]{"f1_odbviobjpick_html", "f1_odbvifrom_html", "f1_odbviselect_html", "f1_odbviwhere_html", "f1_odbvigroup_html", "f1_odbvihaving_html", "f1_odbvconnectby_html", "f1_odbviorderby_html", "f1_odbvisql_html"};
    private final List<Navigable> m_navs;
    private final boolean m_noOrderBy;
    private Step[] m_steps;
    private Collection<String> m_bindVars;

    public SQLQueryEditDialog() {
        this(false);
    }

    public SQLQueryEditDialog(boolean bl) {
        this.m_noOrderBy = bl;
        this.m_navs = new ArrayList<Navigable>();
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_PICKER"), QuickPickObjectsPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_FROM_INFO"), FromObjectsPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_SELECT_INFO"), SelectObjectsPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_WHERE_INFO"), WhereObjectPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_GROUPBY_INFO"), GroupByPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_HAVING_INFO"), HavingPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_HIER_QUERY_INFO"), HierarchicalQueryPanel.class));
        if (!this.m_noOrderBy) {
            this.m_navs.add(new Navigable(UIBundle.get("VIEW_ORDERBY_INFO"), OrderByPanel.class));
        }
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_QUERY_INFO"), QueryPanel.class));
        this.setHelpIDs(this.m_navs);
    }

    public Navigable[] getNavigables() {
        return this.m_navs.toArray(new Navigable[this.m_navs.size()]);
    }

    private void setHelpIDs(List<Navigable> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setHelpID(QUERY_HELP_IDS[i]);
        }
    }

    public void setBindVariables(Collection<String> collection) {
        this.m_bindVars = collection;
    }

    public Navigable getMasterNavigable() {
        Navigable navigable = new Navigable(UIBundle.get("QUERY_DISPLAY_INFO"), QueryPanel.class);
        navigable.setHelpID(HELP_QUERY_INFO);
        navigable.setChildComparator((Comparator)this);
        for (int i = 0; i < this.m_navs.size() - 1; ++i) {
            navigable.addChildNavigable(this.m_navs.get(i));
        }
        return navigable;
    }

    public Step[] getSteps() {
        if (this.m_steps == null) {
            this.m_steps = new Step[this.m_navs.size()];
            for (int i = 0; i < this.m_steps.length; ++i) {
                Navigable navigable = this.m_navs.get(i);
                this.m_steps[i] = new Step(navigable.getShortLabel(), navigable.getTraversableClass(), QUERY_HELP_IDS[i++]);
            }
        }
        return this.m_steps;
    }

    public String editQuery(String string, DBObjectProvider dBObjectProvider, Schema schema) {
        SQLQuery sQLQuery = new SQLQuery(string);
        this.editQueryImpl(sQLQuery, null, dBObjectProvider, schema);
        return sQLQuery.toString();
    }

    public SQLQuery editQuery(SQLQuery sQLQuery, DBObjectProvider dBObjectProvider, Schema schema) {
        return this.editQuery(sQLQuery, null, dBObjectProvider, schema);
    }

    public SQLQuery editQuery(SQLQuery sQLQuery, SQLFragment sQLFragment, DBObjectProvider dBObjectProvider, Schema schema) {
        return this.editQueryImpl(sQLQuery, sQLFragment, dBObjectProvider, schema);
    }

    public Namespace createNamespace(SQLQuery sQLQuery, DBObjectProvider dBObjectProvider, Schema schema) {
        Namespace namespace = new Namespace();
        namespace.put("oracle.javatools.db.DBObjectProvider", (Object)dBObjectProvider);
        namespace.put("oracle.javatools.db.Schema", (Object)schema);
        namespace.put("NewObject", (Object)sQLQuery);
        DBEditorConfig dBEditorConfig = SQLQueryEditDialog.newDefaultEditorConfig(dBObjectProvider, sQLQuery);
        dBEditorConfig.setSchema(schema);
        namespace.put(DBEditorConfig.class.getName(), (Object)dBEditorConfig);
        if (this.m_bindVars != null) {
            namespace.put("bindVariables", this.m_bindVars);
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLQuery editQueryImpl(SQLQuery sQLQuery, SQLFragment sQLFragment, DBObjectProvider dBObjectProvider, Schema schema) {
        Object object;
        if (sQLQuery == null) {
            return null;
        }
        SQLQuery sQLQuery2 = new SQLQuery();
        sQLQuery.copyTo((Object)sQLQuery2);
        Namespace namespace = this.createNamespace(sQLQuery2, dBObjectProvider, schema);
        final MDDPanel mDDPanel = new MDDPanel(this.getMasterNavigable());
        mDDPanel.setName("SQLQueryEditDialog.MDD");
        Traversable traversable = new Traversable(){

            public Component getComponent() {
                return mDDPanel;
            }

            public Object getExitTransition() {
                return null;
            }

            public String getHelpID() {
                return null;
            }

            public void onExit(TraversableContext traversableContext) throws TraversalException {
                mDDPanel.onExit(traversableContext);
            }

            public void onEntry(TraversableContext traversableContext) {
                mDDPanel.onEntry(traversableContext);
                mDDPanel.expandTree1ToDepth(2);
            }
        };
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("EDIT_QUERY"), traversable, namespace);
        if (sQLFragment != null && (object = SQLQueryEditDialog.getStartPage(sQLFragment, false)) != null) {
            mDDPanel.setTree1SelectionPath(object);
        }
        tDialogLauncher.initDialog().setName("SQLQueryEditDialog");
        object = "SQLQueryEditDialog." + System.nanoTime();
        SQLQuery sQLQuery3 = null;
        try {
            DBUtil.suspendTimestampChecking((DBObjectProvider)dBObjectProvider, (String)object);
            if (tDialogLauncher.showDialog()) {
                SQLQuery sQLQuery4 = (SQLQuery)((DBEditorConfig)namespace.get(DBEditorConfig.class)).getChildObject();
                sQLQuery4.copyTo((Object)sQLQuery);
                sQLQuery3 = sQLQuery;
            }
        }
        finally {
            tDialogLauncher.dispose();
            DBUtil.resumeTimestampChecking((DBObjectProvider)dBObjectProvider, (String)object);
        }
        return sQLQuery3;
    }

    public int compare(Object object, Object object2) {
        return 0;
    }

    public static final DBEditorConfig newDefaultEditorConfig(DBObjectProvider dBObjectProvider, SQLQuery sQLQuery) {
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEmptyConfig(dBObjectProvider);
        dBEditorConfig.setChildObject((DBObject)sQLQuery);
        dBEditorConfig.setSchema(DBUtil.getSchema((DBObject)sQLQuery));
        return dBEditorConfig;
    }

    public static final String[] getStartPage(SQLFragment sQLFragment, boolean bl) {
        String string = null;
        if (sQLFragment instanceof SelectObject) {
            string = UIBundle.get("VIEW_SELECT_INFO");
        } else if (sQLFragment instanceof FromObject) {
            string = UIBundle.get("VIEW_FROM_INFO");
        } else if (sQLFragment instanceof WhereObject) {
            string = UIBundle.get("VIEW_WHERE_INFO");
        } else if (sQLFragment instanceof GroupByObject) {
            string = UIBundle.get("VIEW_GROUPBY_INFO");
        } else if (sQLFragment instanceof OrderByObject) {
            string = UIBundle.get("VIEW_ORDERBY_INFO");
        } else if (sQLFragment instanceof HierarchicalQueryObject) {
            string = UIBundle.get("VIEW_HIER_QUERY_INFO");
        }
        if (string != null) {
            if (bl) {
                return new String[]{UIBundle.get("QUERY_DISPLAY_INFO"), string};
            }
            return new String[]{string};
        }
        return null;
    }

    public static boolean isAvailable(DBObjectProvider dBObjectProvider) {
        DatabaseDescriptor databaseDescriptor = dBObjectProvider.getDescriptor();
        SQLQueryBuilderFactory sQLQueryBuilderFactory = databaseDescriptor.getSQLQueryBuilderFactory();
        return sQLQueryBuilderFactory != null;
    }
}

