/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.MnemonicBuilder;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.util.Pair;

public class DBUIMnemonicBuilder {
    private static final String IGNORE_KEY = "DBUIMnemonicBuilder.IGNORE_KEY";
    private static final String s_validCharacters;
    private final JPanel m_panel;
    private final List<Container> m_roots;
    private final List<Component> m_compList;
    private final List<String> m_labels;
    private final List<String> m_options;
    private final boolean m_skipLabels;
    private String m_availableCharacters;

    public DBUIMnemonicBuilder(JPanel jPanel) {
        this(jPanel, jPanel);
    }

    public DBUIMnemonicBuilder(JPanel jPanel, JPanel jPanel2) {
        Container container;
        this.m_panel = jPanel;
        this.m_compList = new ArrayList<Component>();
        this.m_roots = new ArrayList<Container>();
        this.m_labels = new ArrayList<String>();
        this.m_options = new ArrayList<String>();
        this.m_availableCharacters = s_validCharacters;
        for (container = jPanel2; container != jPanel && container != null; container = container.getParent()) {
            if (!this.isTabRoot(container.getParent())) continue;
            this.m_roots.add(container);
        }
        if (container == null) {
            throw new IllegalArgumentException("childPanel is not a child of panel");
        }
        String string = DisplayNames.getPropertyDisplayName((String)"name");
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (s_validCharacters.indexOf(string.charAt(i)) <= -1) continue;
            bl = true;
            break;
        }
        this.m_skipLabels = !bl;
    }

    public void reserveMnemonic(char c) {
        if (c != '\u0000') {
            String string = Character.toString(c);
            this.m_availableCharacters = this.m_availableCharacters.replace(string, "");
        }
    }

    public static void addLabelOption(JComponent jComponent, String string, String string2) {
        LabelOptions labelOptions = (LabelOptions)jComponent.getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options");
        if (labelOptions == null) {
            labelOptions = new LabelOptions();
            jComponent.putClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options", labelOptions);
        }
        labelOptions.m_map.put(string, new Pair((Object)string2, null));
    }

    public static void setLabelOption(JComponent jComponent, String string) {
        Pair pair;
        LabelOptions labelOptions = (LabelOptions)jComponent.getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options");
        if (labelOptions != null && (pair = (Pair)labelOptions.m_map.get(string)) != null && pair.first != null) {
            Character c = (Character)pair.second;
            if (c == null) {
                c = Character.valueOf('\u0000');
            }
            DBUIMnemonicBuilder.setMnemonicAndText(jComponent, c, (String)pair.first);
            return;
        }
        throw new IllegalStateException("Option " + string + " not found");
    }

    public static void setIgnoreComponent(Component component, boolean bl) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (bl) {
                jComponent.putClientProperty(IGNORE_KEY, Boolean.TRUE);
            } else {
                jComponent.putClientProperty(IGNORE_KEY, null);
            }
        } else if (bl) {
            DBLog.getLogger(DBUIMnemonicBuilder.class).warning("setIgnoreComponent only supported on JComponent");
        }
    }

    private static boolean isIgnoreComponent(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = jComponent.getClientProperty(IGNORE_KEY);
            return Boolean.TRUE.equals(object);
        }
        return false;
    }

    public void build() {
        Object object;
        JEWTDialog jEWTDialog = this.getDialog();
        if (jEWTDialog != null) {
            this.reserveDialogMnemonics(jEWTDialog);
            object = this.getTabbedEditorPanel((Container)jEWTDialog);
            if (object != null && ((TabbedEditorPanel)object).getTop() != null) {
                this.reserveHeaderMnemonics((Container)((TabbedEditorPanel)object).getTop().getComponent());
            }
        }
        this.buildComponentList(this.m_panel);
        object = new ArrayList();
        if (this.m_skipLabels) {
            for (int i = 0; i < this.m_labels.size(); ++i) {
                object.add(null);
            }
        } else {
            MnemonicBuilder.build((String)this.m_availableCharacters, this.m_labels, (List)object);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Character c = (Character)iterator.next();
            if (c == null) continue;
            this.reserveMnemonic(c.charValue());
        }
        this.setMnemonics((List<Character>)object);
    }

    public void removeAll() {
        this.buildComponentList(this.m_panel);
        for (int i = 0; i < this.m_compList.size(); ++i) {
            Component component = this.m_compList.get(i);
            if (this.getExistingMnemonic(component) == 0) continue;
            DBUIMnemonicBuilder.setMnemonicAndText(component, Character.valueOf('\u0000'), this.getText(component));
        }
    }

    private void reserveDialogMnemonics(JEWTDialog jEWTDialog) {
        this.reserveMnemonic((char)jEWTDialog.getButtonMnemonic(1));
        this.reserveMnemonic((char)jEWTDialog.getButtonMnemonic(2));
        this.reserveMnemonic((char)jEWTDialog.getButtonMnemonic(4));
        this.reserveMnemonic((char)jEWTDialog.getButtonMnemonic(8));
        this.reserveMnemonic((char)jEWTDialog.getButtonMnemonic(16));
    }

    private void reserveHeaderMnemonics(Container container) {
        for (Component component : container.getComponents()) {
            int n = this.getExistingMnemonic(component);
            if (n != 0) {
                this.reserveMnemonic((char)n);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.reserveHeaderMnemonics((Container)component);
        }
    }

    private void buildComponentList(Container container) {
        List<Component> list = Arrays.asList(container.getComponents());
        Container component = null;
        if (this.isTabRoot(container)) {
            for (Container component2 : this.m_roots) {
                if (!list.contains(component2)) continue;
                component = component2;
                break;
            }
        }
        if (component != null) {
            list = Collections.singletonList(component);
        }
        for (Component component2 : list) {
            boolean bl;
            ReorderableTableWithTitleBar reorderableTableWithTitleBar;
            int n = this.getExistingMnemonic(component2);
            if (n != 0 && this.m_availableCharacters.indexOf(n) >= 0) {
                this.reserveMnemonic((char)n);
                continue;
            }
            if (component2 instanceof JLabel && ((JLabel)component2).getLabelFor() == null && (reorderableTableWithTitleBar = (ReorderableTableWithTitleBar)this.findParent(component2, ReorderableTableWithTitleBar.class, 10)) != null) {
                ((JLabel)component2).setLabelFor((Component)reorderableTableWithTitleBar);
            }
            if (!(bl = DBUIMnemonicBuilder.isIgnoreComponent(component2)) && component2 instanceof JComponent && ((JComponent)component2).getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options") != null) {
                LabelOptions labelOptions = (LabelOptions)((JComponent)component2).getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options");
                for (String string : labelOptions.m_map.keySet()) {
                    Pair pair = (Pair)labelOptions.m_map.get(string);
                    this.m_compList.add(component2);
                    this.m_labels.add((String)pair.first);
                    this.m_options.add(string);
                }
                continue;
            }
            if (!bl && component2 instanceof JLabel && ((JLabel)component2).getLabelFor() != null) {
                this.m_compList.add(component2);
                this.m_labels.add(this.getText(component2));
                this.m_options.add(null);
                continue;
            }
            if (!bl && component2 instanceof AbstractButton && (component2 instanceof JCheckBox || component2.getName() != null)) {
                this.m_compList.add(component2);
                this.m_labels.add(this.getText(component2));
                this.m_options.add(null);
                continue;
            }
            if (!(component2 instanceof Container)) continue;
            this.buildComponentList((Container)component2);
        }
    }

    private Component findParent(Component component, Class<? extends Component> clazz, int n) {
        if (n > 0 && component != null) {
            Container container = component.getParent();
            if (container != null && clazz.isAssignableFrom(container.getClass())) {
                return container;
            }
            return this.findParent(container, clazz, n - 1);
        }
        return null;
    }

    private boolean isTabRoot(Container container) {
        return container instanceof JTabbedPane;
    }

    private void setMnemonics(List<Character> list) {
        for (int i = 0; i < this.m_compList.size(); ++i) {
            Component component = this.m_compList.get(i);
            String string = this.m_options.get(i);
            String string2 = this.getText(component);
            Character c = list.get(i);
            if (c != null) {
                DBUIMnemonicBuilder.setMnemonicAndText(component, c, null);
            } else if (this.getExistingMnemonic(component) == 0 && this.m_availableCharacters.length() > 0) {
                CharSequence charSequence;
                if (string2 != null && string2.length() > 0) {
                    c = Character.valueOf(this.m_availableCharacters.charAt(0));
                    charSequence = new StringBuilder(string2);
                    int n = string2.lastIndexOf(":");
                    if (n > -1) {
                        ((StringBuilder)charSequence).insert(n, UIBundle.format("DBUIMNEMONICBUILDER_PARENTHESES", c));
                    } else {
                        ((StringBuilder)charSequence).append(UIBundle.format("DBUIMNEMONICBUILDER_PARENTHESES", c));
                    }
                    DBUIMnemonicBuilder.setMnemonicAndText(component, c, ((StringBuilder)charSequence).toString());
                } else {
                    c = Character.valueOf(this.m_availableCharacters.charAt(this.m_availableCharacters.length() - 1));
                    charSequence = null;
                    if (component instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        charSequence = jLabel.getToolTipText();
                    } else if (component instanceof AbstractButton) {
                        AbstractButton abstractButton = (AbstractButton)component;
                        charSequence = abstractButton.getToolTipText();
                    }
                    charSequence = charSequence == null ? UIBundle.format("DBUIMNEMONICBUILDER_TOOLTIP", c) : (String)charSequence + " " + UIBundle.format("DBUIMNEMONICBUILDER_TOOLTIP", c);
                    if (component instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        jLabel.setDisplayedMnemonic(c.charValue());
                        jLabel.setToolTipText((String)charSequence);
                    } else if (component instanceof AbstractButton) {
                        AbstractButton abstractButton = (AbstractButton)component;
                        abstractButton.setMnemonic(c.charValue());
                        abstractButton.setToolTipText((String)charSequence);
                    }
                }
                this.reserveMnemonic(c.charValue());
            }
            if (string == null) continue;
            ((Pair)((LabelOptions)((JComponent)component).getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options")).m_map.get(string)).setSecond((Object)c);
        }
    }

    private JEWTDialog getDialog() {
        Window window;
        JEWTDialog jEWTDialog = null;
        Dialog dialog = IdeUtil.findDialog((Component)this.m_panel);
        if (dialog == null && (window = IdeUtil.modalDialogOwner()) instanceof Dialog) {
            dialog = (Dialog)window;
        }
        if (dialog instanceof JEWTDialog) {
            jEWTDialog = (JEWTDialog)dialog;
        }
        return jEWTDialog;
    }

    private String getText(Component component) {
        String string = null;
        if (component instanceof JLabel) {
            string = ((JLabel)component).getText();
        } else if (component instanceof AbstractButton) {
            string = ((AbstractButton)component).getText();
        }
        return string;
    }

    private static void setMnemonicAndText(Component component, Character c, String string) {
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            if (string != null) {
                jLabel.setText(string);
            }
            jLabel.setDisplayedMnemonic(c.charValue());
            String string2 = jLabel.getText();
            int n = StringUtils.getMnemonicIndex((String)string2);
            if (n != -1) {
                jLabel.setDisplayedMnemonicIndex(n);
            }
        } else if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            if (string != null) {
                abstractButton.setText(string);
            }
            abstractButton.setMnemonic(c.charValue());
            String string3 = abstractButton.getText();
            int n = StringUtils.getMnemonicIndex((String)string3);
            if (n != -1) {
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private int getExistingMnemonic(Component component) {
        int n = 0;
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            n = jLabel.getDisplayedMnemonic();
        } else if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            n = abstractButton.getMnemonic();
        }
        return n;
    }

    private TabbedEditorPanel getTabbedEditorPanel(Container container) {
        for (Component component : container.getComponents()) {
            TabbedEditorPanel tabbedEditorPanel;
            if (component instanceof TabbedEditorPanel) {
                return (TabbedEditorPanel)((Object)component);
            }
            if (!(component instanceof Container) || (tabbedEditorPanel = this.getTabbedEditorPanel((Container)component)) == null) continue;
            return tabbedEditorPanel;
        }
        return null;
    }

    static {
        String string = UIBundle.get("DBUIMNEMONICBUILDER_CHARACTERS");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if (string.indexOf(string2) != i) continue;
            stringBuilder.append(string2);
        }
        s_validCharacters = stringBuilder.toString();
        if (!s_validCharacters.equals(string)) {
            DBLog.getLogger(DBUIMnemonicBuilder.class).warning("DBUIMnemonicBuilder: " + string + " contains repeated characters");
        }
    }

    private static class LabelOptions {
        private static final String KEY = "oracle.ideimpl.db.DBUIMnemonicBuilder.options";
        private final Map<String, Pair<String, Character>> m_map = new HashMap<String, Pair<String, Character>>();

        private LabelOptions() {
        }
    }
}

