/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.config.Preferences;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBLog;

public class DatabaseIdePreferences
extends HashStructureAdapter
implements PropertyStorage {
    static final String DEFAULT_FILE_NAME = "dbprefs.xml";
    static final String PREFS_KEY = "oracle.ideimpl.db.DatabaseIdePreferences";
    private URL m_url;

    private DatabaseIdePreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    private DatabaseIdePreferences(URL uRL, HashStructure hashStructure) {
        super(hashStructure);
        this.m_url = uRL;
    }

    public boolean isAdvancedView(String string) {
        return this._hash.getBoolean(this.getAdvancedViewKey(string), false);
    }

    public void setAdvancedView(String string, boolean bl) {
        this._hash.putBoolean(this.getAdvancedViewKey(string), bl);
    }

    private String getAdvancedViewKey(String string) {
        return string + "_ADVANCED_EDITOR";
    }

    private HashStructureIO getIO() {
        return new HashStructureIO("http://xmlns.oracle.com/ide/hash", "db-ui:settings");
    }

    private void open() throws IOException {
        if (this.m_url == null) {
            throw new IllegalStateException("Database UI Settings has no URL.");
        }
        HashStructureIO hashStructureIO = this.getIO();
        if (URLFileSystem.exists((URL)this.m_url)) {
            hashStructureIO.open(this.m_url, (Object)this._hash);
        }
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    public static final DatabaseIdePreferences getPreferences() {
        return new DatabaseIdePreferences(DatabaseIdePreferences.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)PREFS_KEY));
    }

    static final DatabaseIdePreferences loadFromOldFile(File file) {
        HashStructure hashStructure = HashStructure.newInstance();
        URL uRL = URLFactory.newFileURL((String)file.getPath());
        DatabaseIdePreferences databaseIdePreferences = new DatabaseIdePreferences(uRL, hashStructure);
        try {
            databaseIdePreferences.open();
        }
        catch (IOException iOException) {
            DBLog.getLogger(DatabaseIdePreferences.class).log(Level.WARNING, "Couldn't load preferences file for migration.", iOException);
        }
        return databaseIdePreferences;
    }
}

