/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.ui.StatusIndicator;

public class BooleanPropertyComponentWrapper
extends ComponentWrapper<JCheckBox> {
    private final JComponent m_statusComponent;
    private boolean m_onState = true;
    private String m_label;

    public BooleanPropertyComponentWrapper() {
        super(new JCheckBox());
        StatusIndicator statusIndicator = new StatusIndicator();
        statusIndicator.setStatus(StatusIndicator.Status.OK);
        this.m_statusComponent = statusIndicator.configureStandalone(StatusIndicator.OkPolicy.REMOVE);
    }

    @Override
    protected Component getDefaultValidationComponent() {
        return this.m_statusComponent;
    }

    @Override
    protected Component createComponentForLayout() {
        JPanel jPanel = new JPanel();
        JCheckBox jCheckBox = (JCheckBox)this.getActiveComponent();
        jPanel.setName(jCheckBox.getName() + "_Panel");
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel);
        dBUILayoutHelper.setMargins(0);
        dBUILayoutHelper.add(this.m_statusComponent);
        dBUILayoutHelper.add(jCheckBox, 1, 1, true, false);
        GridBagConstraints gridBagConstraints = dBUILayoutHelper.getConstraints(this.m_statusComponent);
        GridBagConstraints gridBagConstraints2 = dBUILayoutHelper.getConstraints(jCheckBox);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 8;
        gridBagConstraints2.insets.left = 0;
        dBUILayoutHelper.layout();
        return jPanel;
    }

    @Override
    public Object getPropertyValue() {
        boolean bl = this.m_onState ? ((JCheckBox)this.getActiveComponent()).isSelected() : !((JCheckBox)this.getActiveComponent()).isSelected();
        return bl;
    }

    @Override
    public void setPropertyValue(Object object) {
        boolean bl;
        JCheckBox jCheckBox = (JCheckBox)this.getActiveComponent();
        boolean bl2 = jCheckBox.isSelected();
        boolean bl3 = bl = Boolean.TRUE.equals(object) == this.m_onState;
        if (bl2 != bl) {
            jCheckBox.setSelected(bl);
            Collection collection = this.getProvider().getPropertyManager().getAllowedPropertyValues(this.getOriginalObject(), this.getUpdatedObject(), this.getPropertyName());
            boolean bl4 = true;
            if (collection != null) {
                boolean bl5 = collection.contains(true) && collection.contains(false);
                bl4 = !collection.contains(object) || bl5;
            }
            this.setEnabled(bl4);
        }
    }

    @Override
    public JLabel getLabel() {
        if (this.m_label != null) {
            ((JCheckBox)this.getActiveComponent()).setText(this.m_label);
        }
        return null;
    }

    @Override
    protected void initialiseComponentListener() {
        ((JCheckBox)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BooleanPropertyComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        String string = PropertyDisplayRegistry.getPropValueDisplay(this.getPropertyName(), "invert");
        if (!"invert".equals(string)) {
            this.m_onState = false;
            this.m_label = string;
        }
    }
}

