/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.OracleIndexPartitions;

public class IndexPartitionColumnsWrapper
extends ComponentWrapper<JComboBox> {
    public IndexPartitionColumnsWrapper() {
        super(new JComboBox(new DefaultComboBoxModel()));
    }

    @Override
    public Object getPropertyValue() {
        ComboBoxModel comboBoxModel = ((JComboBox)this.getActiveComponent()).getModel();
        DBObjectID dBObjectID = ((DBObject)comboBoxModel.getSelectedItem()).getID();
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        if (comboBoxModel.getSize() > 0) {
            int n = 0;
            DBObjectID dBObjectID2 = null;
            do {
                dBObjectID2 = ((DBObject)comboBoxModel.getElementAt(n)).getID();
                arrayList.add(dBObjectID2);
            } while (++n < comboBoxModel.getSize() && !dBObjectID.equals(dBObjectID2));
        }
        return arrayList.toArray(new DBObjectID[arrayList.size()]);
    }

    @Override
    public void setPropertyValue(Object object) {
        ComboBoxModel comboBoxModel = ((JComboBox)this.getActiveComponent()).getModel();
        if (object instanceof DBObjectID[] && ((DBObjectID[])object).length > 0) {
            DBObjectID[] dBObjectIDArray = (DBObjectID[])object;
            DBObjectID dBObjectID = dBObjectIDArray[dBObjectIDArray.length - 1];
            try {
                comboBoxModel.setSelectedItem(dBObjectID.resolveID());
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)this).log(Level.WARNING, dBException.getMessage(), dBException);
            }
        } else {
            comboBoxModel.setSelectedItem(null);
        }
    }

    @Override
    public void processComponent(boolean bl, boolean bl2) {
        super.processComponent(bl, bl2);
        this.populateCombo();
    }

    @Override
    protected void initialiseComponent() {
        ((JComboBox)this.getActiveComponent()).setRenderer(new DBObjectRenderer(false));
    }

    @Override
    protected void initialiseComponentListener() {
        ((JComboBox)this.getActiveComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    IndexPartitionColumnsWrapper.this.fireChangeEvent();
                }
            }
        });
    }

    @Override
    public String getPropertyDisplayName() {
        return UIBundle.get("INDEX_PARTITIONS_LAST_COLUMN");
    }

    private void populateCombo() {
        Column[] columnArray;
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)((JComboBox)this.getActiveComponent()).getModel();
        defaultComboBoxModel.removeAllElements();
        for (Column column : columnArray = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)((Index)this.getUpdatedObject()))) {
            defaultComboBoxModel.addElement(column);
        }
        ((JComboBox)this.getActiveComponent()).setModel(defaultComboBoxModel);
    }
}

