/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.components.DelegateComponentWrapper;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;
import oracle.ideimpl.db.components.table.BigDataAccessParametersComponentWrapper;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class AccessParametersComponentWrapper
extends DelegateComponentWrapper {
    private static final String DEFAULT = "DEFAULT";
    private static final String BIGDATA = "BIGDATA";
    private final BigDataAccessParametersComponentWrapper m_bigDataWrapper = new BigDataAccessParametersComponentWrapper();
    private ComponentWrapper m_clobWrapper;
    private final JCheckBox m_chkAdvanced = new JCheckBox(StringUtils.stripMnemonic((String)UIBundle.get("TABLE_INFO_ADVANCED")));

    public AccessParametersComponentWrapper() {
        this.m_chkAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AccessParametersComponentWrapper.this.isActive()) {
                    AccessParametersComponentWrapper.this.m_bigDataWrapper.writeUpdates();
                    AccessParametersComponentWrapper.this.getDelegate();
                }
            }
        });
        this.m_chkAdvanced.setOpaque(false);
    }

    public void setCLOBWrapper(ComponentWrapper componentWrapper) {
        this.m_clobWrapper = componentWrapper;
        componentWrapper.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AccessParametersComponentWrapper.this.getDelegate();
            }
        });
    }

    @Override
    protected void registerDelegateWrappers() {
        this.registerDelegateWrapper(DEFAULT, TextPropertyComponentWrapper.createTextWrapper(this.getComponentContext()));
        this.registerDelegateWrapper(BIGDATA, this.m_bigDataWrapper);
    }

    private void checkAdvancedEnabled() {
        this.m_chkAdvanced.setEnabled(!Boolean.TRUE.equals(this.m_clobWrapper.getPropertyValue()));
    }

    @Override
    protected String getDelegateKey() {
        String string = DEFAULT;
        String string2 = this.getCurrentDriver();
        if (BigDataAccessParameterMetadata.isBigDataAccessDriver((String)string2) && !this.m_chkAdvanced.isSelected() && this.m_clobWrapper != null && !((JCheckBox)this.m_clobWrapper.getActiveComponent()).isSelected()) {
            boolean bl;
            OracleExternalTableProperties oracleExternalTableProperties = this.getCurrentProperties();
            String string3 = oracleExternalTableProperties.getAccessParameters();
            boolean bl2 = bl = string3 != null && string3.trim().length() > 0;
            if (!bl || oracleExternalTableProperties.getAccessParametersFragment() != null) {
                string = BIGDATA;
            } else if (bl) {
                this.m_chkAdvanced.setSelected(true);
            }
        }
        this.checkAdvancedEnabled();
        return string;
    }

    private OracleExternalTableProperties getCurrentProperties() {
        return (OracleExternalTableProperties)this.getUpdatedObject().getProperty("OracleExternalTableProperties");
    }

    private String getCurrentDriver() {
        String string = null;
        OracleExternalTableProperties oracleExternalTableProperties = this.getCurrentProperties();
        if (oracleExternalTableProperties != null) {
            string = oracleExternalTableProperties.getAccessDriverType();
        }
        return string;
    }

    @Override
    protected Component createComponentForLayout() {
        JPanel jPanel = (JPanel)this.getActiveComponent();
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = this.m_bigDataWrapper.getKeyValueTable().getComponent();
        TableToolbar tableToolbar = reorderableTableWithTitleBar.getTableToolbar();
        Component component = this.m_clobWrapper.getComponent();
        DBUILayoutHelper.makeTransparentForFlatEditor((JComponent)component);
        tableToolbar.addActionControl(component, false);
        tableToolbar.addActionControl(Box.createHorizontalStrut(24), false);
        this.m_chkAdvanced.setName(((JPanel)this.getActiveComponent()).getName() + ".Advanced");
        reorderableTableWithTitleBar.setTableContainer((JComponent)jPanel);
        reorderableTableWithTitleBar.setPreferredSize(new Dimension(290, 150));
        return reorderableTableWithTitleBar;
    }

    @Override
    protected void fireDelegateChanged(String string, String string2) {
        boolean bl = BIGDATA.equals(string2);
        KeyValueTable keyValueTable = this.m_bigDataWrapper.getKeyValueTable();
        keyValueTable.setButtonsVisible(bl);
        TableToolbar tableToolbar = keyValueTable.getComponent().getTableToolbar();
        tableToolbar.removeActionControl((Component)this.m_chkAdvanced);
        if (bl || BigDataAccessParameterMetadata.isBigDataAccessDriver((String)this.getCurrentDriver())) {
            tableToolbar.addActionControl((Component)this.m_chkAdvanced, false);
        }
    }
}

