/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components.table;

import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.BigDataAccessParamsTable;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.ui.ResizeComponent;

public class BigDataAccessParametersComponentWrapper
extends AsynchronousComponentWrapper<JComponent> {
    private final BigDataAccessParamsTable m_table = (BigDataAccessParamsTable)KeyValueTable.getKeyValueTable((JComponent)this.getActiveComponent());

    public BigDataAccessParametersComponentWrapper() {
        super(new BigDataAccessParamsTable().getComponent().getTableContainer());
    }

    @Override
    protected void prepareForWrite() {
        this.m_table.stopCellEditing();
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getActiveComponent();
    }

    @Override
    public Component[] getFocusComponents() {
        return null;
    }

    final KeyValueTable getKeyValueTable() {
        return this.m_table;
    }

    @Override
    protected Component createComponentForLayout() {
        JComponent jComponent = (JComponent)this.getActiveComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            jComponent = new ResizeComponent(jComponent);
        }
        return jComponent;
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        this.m_table.addTableModelListener(new ExtendedTable.ExtendedTableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (BigDataAccessParametersComponentWrapper.this.isAddEvent(tableModelEvent)) {
                    BigDataAccessParametersComponentWrapper.this.markDirty();
                } else {
                    BigDataAccessParametersComponentWrapper.this.fireChangeEvent();
                }
            }

            @Override
            public void cellValueEdited(TableModelEvent tableModelEvent) {
                BigDataAccessParametersComponentWrapper.this.markDirty();
            }
        });
    }

    private boolean isAddEvent(TableModelEvent tableModelEvent) {
        boolean bl;
        boolean bl2 = bl = tableModelEvent.getType() == 1;
        if (!bl) {
            ExtendedTable.StringTableModel stringTableModel = this.getKeyValueTable().getModel();
            int n = tableModelEvent.getFirstRow();
            if (tableModelEvent.getLastRow() == n && n >= 0 && n < stringTableModel.getRowCount()) {
                bl = true;
                for (int i = 0; i < stringTableModel.getColumnCount(); ++i) {
                    if (stringTableModel.getValueAt(n, i) == null) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public Object getPropertyValue() {
        BigDataAccessParameters bigDataAccessParameters = this.m_table.getAccessParameters();
        return bigDataAccessParameters == null ? null : bigDataAccessParameters.getSQLText();
    }

    @Override
    public void setPropertyValue(Object object) {
        SQLFragment sQLFragment;
        OracleExternalTableProperties oracleExternalTableProperties;
        BigDataAccessParameters bigDataAccessParameters = null;
        if (object != null && (oracleExternalTableProperties = (OracleExternalTableProperties)this.getUpdatedObject().getProperty("OracleExternalTableProperties")) != null && (sQLFragment = oracleExternalTableProperties.getAccessParametersFragment()) instanceof BigDataAccessParameters) {
            bigDataAccessParameters = (BigDataAccessParameters)sQLFragment;
        }
        this.m_table.setAccessParameters(bigDataAccessParameters, (Relation)DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Relation.class), this.getProvider());
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        this.checkKeys();
    }

    @Override
    public boolean refreshObject(DBObject dBObject) {
        this.checkKeys();
        return super.refreshObject(dBObject);
    }

    private void checkKeys() {
        String string;
        Collection collection = null;
        OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)this.getUpdatedObject().getProperty("OracleExternalTableProperties");
        if (oracleExternalTableProperties != null && BigDataAccessParameterMetadata.isBigDataAccessDriver((String)(string = oracleExternalTableProperties.getAccessDriverType()))) {
            collection = BigDataAccessParameterMetadata.getAllowedParameterNames((String)string);
        }
        this.m_table.setKeys(collection);
    }
}

