/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.util.ModelUtil;

public class TextFieldWithCheckBoxPanel
extends JPanel {
    private final JTextField m_text = new JTextField();
    private final JCheckBox m_chk = new JCheckBox();
    private boolean m_presetState;
    private String m_presetValue;

    public TextFieldWithCheckBoxPanel() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
        dBUILayoutHelper.setMargins(0);
        dBUILayoutHelper.add(this.m_chk);
        dBUILayoutHelper.add(this.m_text);
        GridBagConstraints gridBagConstraints = dBUILayoutHelper.getConstraints(this.m_text);
        gridBagConstraints.insets.left = 8;
        dBUILayoutHelper.layout();
        this.m_chk.addActionListener(new ActionListener(){
            String m_lastValue = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (((JCheckBox)object).isSelected() == TextFieldWithCheckBoxPanel.this.m_presetState) {
                    TextFieldWithCheckBoxPanel.this.m_text.setEnabled(false);
                    this.m_lastValue = TextFieldWithCheckBoxPanel.this.m_text.getText();
                    TextFieldWithCheckBoxPanel.this.m_text.setText(TextFieldWithCheckBoxPanel.this.m_presetValue);
                } else {
                    TextFieldWithCheckBoxPanel.this.m_text.setEnabled(true);
                    TextFieldWithCheckBoxPanel.this.m_text.setText(this.m_lastValue);
                }
            }
        });
    }

    public void setCheckLabel(String string) {
        this.m_chk.setText(string);
    }

    public void setCheckStateForPreset(boolean bl) {
        this.m_presetState = bl;
    }

    public void setPresetValue(String string) {
        this.m_presetValue = string;
    }

    public void setValue(String string) {
        this.m_text.setText(string);
        if (ModelUtil.areEqual((Object)string, (Object)this.m_presetValue)) {
            this.m_text.setEnabled(false);
            this.m_chk.setSelected(this.m_presetState);
        }
    }

    public String getValue() {
        if (ModelUtil.areEqual((Object)this.m_chk.isSelected(), (Object)this.m_presetState)) {
            return this.m_presetValue;
        }
        return this.m_text.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_chk.setEnabled(bl);
        this.m_text.setEnabled(bl && this.m_chk.isSelected() != this.m_presetState);
    }

    @Override
    public boolean isEnabled() {
        return this.m_chk.isEnabled();
    }

    @Override
    public final void setName(String string) {
        this.m_text.setName(string);
        this.m_chk.setName(string + "_check");
    }

    public final void addItemListener(ItemListener itemListener) {
        this.m_chk.addItemListener(itemListener);
    }

    public final Document getDocument() {
        return this.m_text.getDocument();
    }

    public final JCheckBox getCheckBox() {
        return this.m_chk;
    }
}

